/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StudioEmbeddedRenderTarget
implements IAndroidTarget {
    private static final Logger LOG = Logger.getInstance(StudioEmbeddedRenderTarget.class);
    private static final String ONLY_FOR_RENDERING_ERROR = "This target is only for rendering";
    private static final String[] EMBEDDED_PATHS = new String[]{"/plugins/android/lib/layoutlib/", "/../../prebuilts/studio/layoutlib/", "/community/android/tools-base/layoutlib/", "/android/tools-base/layoutlib/"};
    private final String myBasePath = StudioEmbeddedRenderTarget.getEmbeddedLayoutLibPath();
    private static StudioEmbeddedRenderTarget ourStudioEmbeddedTarget;
    private static boolean ourDisableEmbeddedTargetForTesting;

    @VisibleForTesting
    public static void setDisableEmbeddedTarget(boolean value) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourDisableEmbeddedTargetForTesting = value;
    }

    public static CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/StudioEmbeddedRenderTarget", "getCompatibilityTarget"));
        }
        if (ourDisableEmbeddedTargetForTesting) {
            return new CompatibilityRenderTarget(target, target.getVersion().getApiLevel(), target);
        }
        int api = target.getVersion().getApiLevel();
        if (target instanceof CompatibilityRenderTarget) {
            CompatibilityRenderTarget compatRenderTarget = (CompatibilityRenderTarget)target;
            target = compatRenderTarget.getRealTarget();
        }
        return new CompatibilityRenderTarget(StudioEmbeddedRenderTarget.getInstance(), api, target);
    }

    private static StudioEmbeddedRenderTarget getInstance() throws IOException {
        if (ourStudioEmbeddedTarget == null) {
            ourStudioEmbeddedTarget = new StudioEmbeddedRenderTarget();
        }
        return ourStudioEmbeddedTarget;
    }

    private StudioEmbeddedRenderTarget() throws IOException {
    }

    private static String getEmbeddedLayoutLibPath() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : EMBEDDED_PATHS) {
            String jarPath = homePath + path;
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (root != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                if (!rootFile.exists() || !rootFile.isDirectory()) continue;
                LOG.debug("Embedded layoutlib found at " + jarPath);
                return rootFile.getAbsolutePath() + File.separator;
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.error("Unable to find embedded layoutlib in paths:\n" + notFoundPaths.toString());
        return null;
    }

    public String getLocation() {
        return this.myBasePath;
    }

    public String getVendor() {
        return "Android Open Source Project";
    }

    public AndroidVersion getVersion() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    public String getVersionName() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    public int getRevision() {
        return 1;
    }

    public boolean isPlatform() {
        return true;
    }

    public IAndroidTarget getParent() {
        return null;
    }

    public String getPath(int pathId) {
        switch (pathId) {
            case 7: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER;
            }
            case 8: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_ATTRS_XML;
            }
            case 9: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_ATTRS_MANIFEST_XML;
            }
            case 11: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_RESOURCES_FOLDER;
            }
            case 12: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_FONTS_FOLDER;
            }
        }
        assert (false) : this.getClass().getSimpleName() + " does not support path of type " + pathId;
        return this.getLocation();
    }

    public File getFile(int pathId) {
        return new File(this.getPath(pathId));
    }

    public BuildToolInfo getBuildToolInfo() {
        return null;
    }

    public List<String> getBootClasspath() {
        return ImmutableList.of((Object)this.getPath(1));
    }

    public boolean hasRenderingLibrary() {
        return true;
    }

    public String getName() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String getFullName() {
        return this.getName();
    }

    public String getClasspathName() {
        return this.getName();
    }

    public String getShortClasspathName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public List<IAndroidTarget.OptionalLibrary> getOptionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public List<IAndroidTarget.OptionalLibrary> getAdditionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public File[] getSkins() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public File getDefaultSkin() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String[] getPlatformLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String getProperty(String name) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public Map<String, String> getProperties() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public boolean canRunOn(IAndroidTarget target) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String hashString() {
        return "studio-embedded-render-target";
    }

    public int compareTo(IAndroidTarget o) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    static {
        ourDisableEmbeddedTargetForTesting = false;
    }
}

