/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ant.ForcedAntFileAttribute;
import com.intellij.lang.ant.dom.AntDomAntlib;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.GuiUtils;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class AntSupport {
    public static void markFileAsAntFile(VirtualFile file, Project project, boolean value) {
        if (file.isValid() && ForcedAntFileAttribute.isAntFile(file) != value) {
            ForcedAntFileAttribute.forceAntFile(file, value);
            GuiUtils.invokeLaterIfNeeded(() -> {
                ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
                AntSupport.restartDaemon(project);
            }, (ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed());
        }
    }

    private static void restartDaemon(Project project) {
        DaemonCodeAnalyzer daemon = DaemonCodeAnalyzer.getInstance((Project)project);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            daemon.restart();
        } else {
            SwingUtilities.invokeLater(() -> ((DaemonCodeAnalyzer)daemon).restart());
        }
    }

    @Nullable
    public static AntDomProject getAntDomProject(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomProject.class);
            return fileElement != null ? (AntDomProject)fileElement.getRootElement() : null;
        }
        return null;
    }

    @Nullable
    public static AntDomProject getAntDomProjectForceAntFile(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomProject.class);
            if (fileElement == null) {
                ForcedAntFileAttribute.forceAntFile(psiFile.getVirtualFile(), true);
                fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomProject.class);
            }
            return fileElement != null ? (AntDomProject)fileElement.getRootElement() : null;
        }
        return null;
    }

    @Nullable
    public static AntDomAntlib getAntLib(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomAntlib.class);
            return fileElement != null ? (AntDomAntlib)fileElement.getRootElement() : null;
        }
        return null;
    }

    @Nullable
    public static AntDomElement getAntDomElement(XmlTag xmlTag) {
        DomElement domElement = DomManager.getDomManager((Project)xmlTag.getProject()).getDomElement(xmlTag);
        return domElement instanceof AntDomElement ? (AntDomElement)domElement : null;
    }

    @Nullable
    public static AntDomElement getInvocationAntDomElement(ConvertContext context) {
        return (AntDomElement)context.getInvocationElement().getParentOfType(AntDomElement.class, false);
    }
}

