/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.actions.TargetActionStub;
import com.intellij.lang.ant.config.impl.ExecuteAfterCompilationEvent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntToolwindowRegistrar
extends AbstractProjectComponent {
    public AntToolwindowRegistrar(Project project) {
        super(project);
    }

    public void projectOpened() {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        String prefix = AntConfiguration.getActionIdPrefix(this.myProject);
        ActionManager actionManager = ActionManager.getInstance();
        for (Keymap keymap : keymapManager.getAllKeymaps()) {
            for (String id : keymap.getActionIdList()) {
                if (!id.startsWith(prefix) || actionManager.getAction(id) != null) continue;
                actionManager.registerAction(id, (AnAction)new TargetActionStub(id, this.myProject));
            }
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        compilerManager.addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfiguration config = AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                ((AntConfigurationBase)config).ensureInitialized();
                return config.executeTargetBeforeCompile(AntToolwindowRegistrar.createDataContext(context));
            }
        });
        compilerManager.addAfterTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfigurationBase config = (AntConfigurationBase)AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                config.ensureInitialized();
                if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                    AntBuildTarget target = config.getTargetForEvent(ExecuteAfterCompilationEvent.getInstance());
                    if (target != null) {
                        context.addMessage(CompilerMessageCategory.INFORMATION, "Skipping ant target \"" + target.getDisplayName() + "\" because of compilation errors", null, -1, -1);
                    }
                    return true;
                }
                return config.executeTargetAfterCompile(AntToolwindowRegistrar.createDataContext(context));
            }
        });
    }

    @NotNull
    private static DataContext createDataContext(CompileContext context) {
        CompileScope scope;
        Module[] modules;
        HashMap dataMap = new HashMap();
        Project project = context.getProject();
        if (project != null) {
            dataMap.put((Object)CommonDataKeys.PROJECT.getName(), (Object)project);
        }
        if ((modules = (scope = context.getCompileScope()).getAffectedModules()).length == 1) {
            dataMap.put((Object)LangDataKeys.MODULE.getName(), (Object)modules[0]);
        }
        dataMap.put((Object)LangDataKeys.MODULE_CONTEXT_ARRAY.getName(), (Object)modules);
        dataMap.put((Object)"COMPILER_CONTEXT_MAKE", (Object)context.isMake());
        DataContext dataContext = SimpleDataContext.getSimpleContext((Map)dataMap, null);
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/impl/AntToolwindowRegistrar", "createDataContext"));
        }
        return dataContext;
    }

    public void projectClosed() {
        String[] oldIds;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (String oldId : oldIds = actionManager.getActionIds(AntConfiguration.getActionIdPrefix(this.myProject))) {
            actionManager.unregisterAction(oldId);
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("AntToolwindowRegistrar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/impl/AntToolwindowRegistrar", "getComponentName"));
        }
        return "AntToolwindowRegistrar";
    }
}

