/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDomProjectProcessorUtils {
    private MavenDomProjectProcessorUtils() {
    }

    @NotNull
    public static Set<MavenDomProjectModel> getChildrenProjects(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "getChildrenProjects"));
        }
        HashSet models = new HashSet();
        MavenDomProjectProcessorUtils.collectChildrenProjects(model, (Set<MavenDomProjectModel>)models);
        HashSet hashSet = models;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "getChildrenProjects"));
        }
        return hashSet;
    }

    private static void collectChildrenProjects(@NotNull MavenDomProjectModel model, @NotNull Set<MavenDomProjectModel> models) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "collectChildrenProjects"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "collectChildrenProjects"));
        }
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            Project project = model.getManager().getProject();
            for (MavenProject inheritor : MavenProjectsManager.getInstance(project).findInheritors(mavenProject)) {
                MavenDomProjectModel inheritorProjectModel = MavenDomUtil.getMavenDomProjectModel(project, inheritor.getFile());
                if (inheritorProjectModel == null || models.contains(inheritorProjectModel)) continue;
                models.add(inheritorProjectModel);
                MavenDomProjectProcessorUtils.collectChildrenProjects(inheritorProjectModel, models);
            }
        }
    }

    @NotNull
    public static Set<MavenDomProjectModel> collectParentProjects(@NotNull MavenDomProjectModel projectDom) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "collectParentProjects"));
        }
        HashSet parents = new HashSet();
        Processor collectProcessor = arg_0 -> MavenDomProjectProcessorUtils.lambda$collectParentProjects$0((Set)parents, arg_0);
        MavenDomProjectProcessorUtils.processParentProjects(projectDom, (Processor<MavenDomProjectModel>)collectProcessor);
        HashSet hashSet = parents;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "collectParentProjects"));
        }
        return hashSet;
    }

    public static void processParentProjects(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomProjectModel> processor) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processParentProjects"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processParentProjects"));
        }
        HashSet processed = new HashSet();
        Project project = projectDom.getManager().getProject();
        MavenDomProjectModel parent = MavenDomProjectProcessorUtils.findParent(projectDom, project);
        while (parent != null && !processed.contains(parent)) {
            processed.add(parent);
            if (processor.process((Object)parent)) break;
            parent = MavenDomProjectProcessorUtils.findParent(parent, project);
        }
    }

    @Nullable
    public static MavenDomProjectModel findParent(@NotNull MavenDomProjectModel model, Project project) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "findParent"));
        }
        return MavenDomProjectProcessorUtils.findParent(model.getMavenParent(), project);
    }

    @Nullable
    public static MavenDomProjectModel findParent(@NotNull MavenDomParent mavenDomParent, Project project) {
        if (mavenDomParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenDomParent", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "findParent"));
        }
        if (!DomUtil.hasXml((DomElement)mavenDomParent)) {
            return null;
        }
        MavenId id = new MavenId(mavenDomParent.getGroupId().getStringValue(), mavenDomParent.getArtifactId().getStringValue(), mavenDomParent.getVersion().getStringValue());
        MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(id);
        return mavenProject != null ? MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile()) : null;
    }

    @Nullable
    public static XmlTag searchProperty(final @NotNull String propertyName, @NotNull MavenDomProjectModel projectDom, @NotNull Project project) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchProperty"));
        }
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchProperty"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchProperty"));
        }
        SearchProcessor<XmlTag, MavenDomProperties> searchProcessor = new SearchProcessor<XmlTag, MavenDomProperties>(){

            @Override
            protected XmlTag find(MavenDomProperties element) {
                return MavenDomProjectProcessorUtils.findProperty(element, propertyName);
            }
        };
        MavenDomProjectProcessorUtils.processProperties(projectDom, (Processor<MavenDomProperties>)searchProcessor, project);
        return (XmlTag)((SearchProcessor)searchProcessor).myResult;
    }

    @Nullable
    public static XmlTag findProperty(@NotNull MavenDomProperties mavenDomProperties, @NotNull String propertyName) {
        if (mavenDomProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenDomProperties", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "findProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "findProperty"));
        }
        XmlTag propertiesTag = mavenDomProperties.getXmlTag();
        if (propertiesTag == null) {
            return null;
        }
        for (XmlTag each : propertiesTag.getSubTags()) {
            if (!each.getName().equals(propertyName)) continue;
            return each;
        }
        return null;
    }

    public static Set<XmlTag> collectProperties(@NotNull MavenDomProjectModel projectDom, @NotNull Project project) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "collectProperties"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "collectProperties"));
        }
        HashSet properties = new HashSet();
        Processor collectProcessor = arg_0 -> MavenDomProjectProcessorUtils.lambda$collectProperties$1((Set)properties, arg_0);
        MavenDomProjectProcessorUtils.processProperties(projectDom, (Processor<MavenDomProperties>)collectProcessor, project);
        return properties;
    }

    @NotNull
    public static Set<MavenDomDependency> searchDependencyUsages(@NotNull MavenDomDependency dependency) {
        DependencyConflictId dependencyId;
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchDependencyUsages"));
        }
        MavenDomProjectModel model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false);
        if (model != null && (dependencyId = DependencyConflictId.create(dependency)) != null) {
            Set<MavenDomDependency> set = MavenDomProjectProcessorUtils.searchDependencyUsages(model, dependencyId, Collections.singleton(dependency));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchDependencyUsages"));
            }
            return set;
        }
        Set<MavenDomDependency> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchDependencyUsages"));
        }
        return set;
    }

    @NotNull
    public static Set<MavenDomDependency> searchDependencyUsages(@NotNull MavenDomProjectModel model, @NotNull DependencyConflictId dependencyId, @NotNull Set<MavenDomDependency> excludes) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchDependencyUsages"));
        }
        if (dependencyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyId", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchDependencyUsages"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchDependencyUsages"));
        }
        Project project = model.getManager().getProject();
        HashSet usages = new HashSet();
        Processor collectProcessor = arg_0 -> MavenDomProjectProcessorUtils.lambda$searchDependencyUsages$2(excludes, dependencyId, (Set)usages, arg_0);
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, (Processor<MavenDomProjectModel>)collectProcessor, project, (Set<MavenDomProjectModel>)new HashSet(), true);
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchDependencyUsages"));
        }
        return hashSet;
    }

    @NotNull
    public static Collection<MavenDomPlugin> searchManagedPluginUsages(@NotNull MavenDomPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagedPluginUsages"));
        }
        String artifactId = plugin.getArtifactId().getStringValue();
        if (artifactId == null) {
            List<MavenDomPlugin> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagedPluginUsages"));
            }
            return list;
        }
        String groupId = plugin.getGroupId().getStringValue();
        MavenDomProjectModel model = (MavenDomProjectModel)plugin.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            List<MavenDomPlugin> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagedPluginUsages"));
            }
            return list;
        }
        Collection<MavenDomPlugin> collection = MavenDomProjectProcessorUtils.searchManagedPluginUsages(model, groupId, artifactId);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagedPluginUsages"));
        }
        return collection;
    }

    @NotNull
    public static Collection<MavenDomPlugin> searchManagedPluginUsages(@NotNull MavenDomProjectModel model, @Nullable String groupId, @NotNull String artifactId) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagedPluginUsages"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagedPluginUsages"));
        }
        Project project = model.getManager().getProject();
        HashSet usages = new HashSet();
        Processor collectProcessor = arg_0 -> MavenDomProjectProcessorUtils.lambda$searchManagedPluginUsages$3(groupId, artifactId, (Set)usages, arg_0);
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, (Processor<MavenDomProjectModel>)collectProcessor, project, (Set<MavenDomProjectModel>)new HashSet(), true);
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagedPluginUsages"));
        }
        return hashSet;
    }

    public static void processChildrenRecursively(@Nullable MavenDomProjectModel model, @NotNull Processor<MavenDomProjectModel> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processChildrenRecursively"));
        }
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, processor, true);
    }

    public static void processChildrenRecursively(@Nullable MavenDomProjectModel model, @NotNull Processor<MavenDomProjectModel> processor, boolean processCurrentModel) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processChildrenRecursively"));
        }
        if (model != null) {
            MavenDomProjectProcessorUtils.processChildrenRecursively(model, processor, model.getManager().getProject(), (Set<MavenDomProjectModel>)new HashSet(), processCurrentModel);
        }
    }

    public static void processChildrenRecursively(@Nullable MavenDomProjectModel model, @NotNull Processor<MavenDomProjectModel> processor, @NotNull Project project, @NotNull Set<MavenDomProjectModel> processedModels, boolean strict) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processChildrenRecursively"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processChildrenRecursively"));
        }
        if (processedModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedModels", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processChildrenRecursively"));
        }
        if (model != null && !processedModels.contains(model)) {
            processedModels.add(model);
            if (strict && processor.process((Object)model)) {
                return;
            }
            MavenProject mavenProject = MavenDomUtil.findProject(model);
            if (mavenProject != null) {
                for (MavenProject childProject : MavenProjectsManager.getInstance(project).findInheritors(mavenProject)) {
                    MavenDomProjectModel childProjectModel = MavenDomUtil.getMavenDomProjectModel(project, childProject.getFile());
                    MavenDomProjectProcessorUtils.processChildrenRecursively(childProjectModel, processor, project, processedModels, true);
                }
            }
        }
    }

    @Nullable
    public static MavenDomDependency searchManagingDependency(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagingDependency"));
        }
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency, dependency.getManager().getProject());
    }

    @Nullable
    public static MavenDomDependency searchManagingDependency(@NotNull MavenDomDependency dependency, @NotNull Project project) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagingDependency"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagingDependency"));
        }
        DependencyConflictId depId = DependencyConflictId.create(dependency);
        if (depId == null) {
            return null;
        }
        MavenDomProjectModel model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            return null;
        }
        Ref res = new Ref();
        Processor processor = dependency1 -> {
            if (depId.equals(DependencyConflictId.create(dependency1))) {
                res.set(dependency1);
                return true;
            }
            return false;
        };
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, (Processor<MavenDomDependency>)processor, project);
        return (MavenDomDependency)res.get();
    }

    @Nullable
    public static MavenDomPlugin searchManagingPlugin(@NotNull MavenDomPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "searchManagingPlugin"));
        }
        final String artifactId = plugin.getArtifactId().getStringValue();
        final String groupId = plugin.getGroupId().getStringValue();
        if (artifactId == null) {
            return null;
        }
        final MavenDomProjectModel model = (MavenDomProjectModel)plugin.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            return null;
        }
        SearchProcessor<MavenDomPlugin, MavenDomPlugins> processor = new SearchProcessor<MavenDomPlugin, MavenDomPlugins>(){

            @Override
            protected MavenDomPlugin find(MavenDomPlugins mavenDomPlugins) {
                if (!model.equals(mavenDomPlugins.getParentOfType(MavenDomProjectModel.class, true))) {
                    for (MavenDomPlugin domPlugin : mavenDomPlugins.getPlugins()) {
                        if (!MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId)) continue;
                        return domPlugin;
                    }
                }
                return null;
            }
        };
        Function domProfileFunction = mavenDomProfile -> mavenDomProfile.getBuild().getPluginManagement().getPlugins();
        MavenDomProjectProcessorUtils.process(model, processor, model.getManager().getProject(), domProfileFunction, domProfileFunction);
        return (MavenDomPlugin)((SearchProcessor)processor).myResult;
    }

    public static boolean processDependenciesInDependencyManagement(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomDependency> processor, @NotNull Project project) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processDependenciesInDependencyManagement"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processDependenciesInDependencyManagement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processDependenciesInDependencyManagement"));
        }
        Processor managedDependenciesListProcessor = dependencies -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "lambda$processDependenciesInDependencyManagement$6"));
            }
            SmartList importDependencies = null;
            for (MavenDomDependency domDependency : dependencies.getDependencies()) {
                if ("import".equals(domDependency.getScope().getRawText())) {
                    if (importDependencies == null) {
                        importDependencies = new SmartList();
                    }
                    importDependencies.add((Object)domDependency);
                    continue;
                }
                if (!processor.process((Object)domDependency)) continue;
                return true;
            }
            if (importDependencies != null) {
                for (MavenDomDependency domDependency : importDependencies) {
                    MavenDomProjectModel dependModel;
                    GenericDomValueReference reference;
                    PsiElement resolve;
                    GenericDomValue<String> version = domDependency.getVersion();
                    if (version.getXmlElement() == null || !((resolve = (reference = new GenericDomValueReference(version)).resolve()) instanceof XmlFile) || (dependModel = MavenDomUtil.getMavenDomModel((PsiFile)resolve, MavenDomProjectModel.class)) == null) continue;
                    for (MavenDomDependency dep : dependModel.getDependencyManagement().getDependencies().getDependencies()) {
                        if (!processor.process((Object)dep)) continue;
                        return true;
                    }
                }
            }
            return false;
        };
        Function domFunction = mavenDomProfile -> mavenDomProfile.getDependencyManagement().getDependencies();
        return MavenDomProjectProcessorUtils.process(projectDom, managedDependenciesListProcessor, project, domFunction, domFunction);
    }

    public static boolean processDependencies(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomDependencies> processor) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processDependencies"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processDependencies"));
        }
        Function domFunction = mavenDomProfile -> mavenDomProfile.getDependencies();
        return MavenDomProjectProcessorUtils.process(projectDom, processor, projectDom.getManager().getProject(), domFunction, domFunction);
    }

    public static boolean processProperties(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomProperties> processor, @NotNull Project project) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processProperties"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processProperties"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processProperties"));
        }
        Function domFunction = mavenDomProfile -> mavenDomProfile.getProperties();
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domFunction, domFunction);
    }

    public static <T> boolean process(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<T> processor, @NotNull Project project, @NotNull Function<? super MavenDomProfile, T> domProfileFunction, @NotNull Function<? super MavenDomProjectModel, T> projectDomFunction) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (domProfileFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domProfileFunction", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (projectDomFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDomFunction", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domProfileFunction, projectDomFunction, (Set<MavenDomProjectModel>)new HashSet());
    }

    public static <T> boolean process(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<T> processor, @NotNull Project project, @NotNull Function<? super MavenDomProfile, T> domProfileFunction, @NotNull Function<? super MavenDomProjectModel, T> projectDomFunction, Set<MavenDomProjectModel> processed) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (domProfileFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domProfileFunction", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (projectDomFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDomFunction", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "process"));
        }
        if (processed.contains(projectDom)) {
            return true;
        }
        processed.add(projectDom);
        MavenProject mavenProjectOrNull = MavenDomUtil.findProject(projectDom);
        if (MavenDomProjectProcessorUtils.processSettingsXml(mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProject(projectDom, mavenProjectOrNull, processor, project, domProfileFunction, projectDomFunction)) {
            return true;
        }
        return MavenDomProjectProcessorUtils.processParentProjectFile(projectDom, processor, project, domProfileFunction, projectDomFunction, processed);
    }

    private static <T> boolean processParentProjectFile(MavenDomProjectModel projectDom, final Processor<T> processor, final Project project, final Function<? super MavenDomProfile, T> domProfileFunction, final Function<? super MavenDomProjectModel, T> projectDomFunction, final Set<MavenDomProjectModel> processed) {
        Boolean aBoolean = (Boolean)new DomParentProjectFileProcessor<Boolean>(MavenProjectsManager.getInstance(project)){

            @Override
            protected Boolean doProcessParent(VirtualFile parentFile) {
                MavenDomProjectModel parentProjectDom = MavenDomUtil.getMavenDomProjectModel(project, parentFile);
                if (parentProjectDom == null) {
                    return false;
                }
                return MavenDomProjectProcessorUtils.process(parentProjectDom, processor, project, domProfileFunction, projectDomFunction, processed);
            }
        }.process(projectDom);
        return aBoolean != null && aBoolean != false;
    }

    private static <T> boolean processSettingsXml(@Nullable MavenProject mavenProject, @NotNull Processor<T> processor, @NotNull Project project, Function<? super MavenDomProfile, T> domProfileFunction) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processSettingsXml"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "processSettingsXml"));
        }
        MavenGeneralSettings settings = MavenProjectsManager.getInstance(project).getGeneralSettings();
        for (VirtualFile each : settings.getEffectiveSettingsFiles()) {
            MavenDomSettingsModel settingsDom = MavenDomUtil.getMavenDomModel(project, each, MavenDomSettingsModel.class);
            if (settingsDom == null || !MavenDomProjectProcessorUtils.processProfiles(settingsDom.getProfiles(), mavenProject, processor, domProfileFunction)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean processProject(MavenDomProjectModel projectDom, MavenProject mavenProjectOrNull, Processor<T> processor, Project project, Function<? super MavenDomProfile, T> domProfileFunction, Function<? super MavenDomProjectModel, T> projectDomFunction) {
        if (MavenDomProjectProcessorUtils.processProfilesXml(MavenDomUtil.getVirtualFile(projectDom), mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProfiles(projectDom.getProfiles(), mavenProjectOrNull, processor, domProfileFunction)) {
            return true;
        }
        Object t = projectDomFunction.fun((Object)projectDom);
        return t != null && processor.process(t);
    }

    private static <T> boolean processProfilesXml(VirtualFile projectFile, MavenProject mavenProjectOrNull, Processor<T> processor, Project project, Function<? super MavenDomProfile, T> f) {
        VirtualFile profilesFile = MavenUtil.findProfilesXmlFile(projectFile);
        if (profilesFile == null) {
            return false;
        }
        MavenDomProfiles profiles = MavenDomUtil.getMavenDomProfilesModel(project, profilesFile);
        if (profiles == null) {
            return false;
        }
        return MavenDomProjectProcessorUtils.processProfiles(profiles, mavenProjectOrNull, processor, f);
    }

    private static <T> boolean processProfiles(MavenDomProfiles profilesDom, MavenProject mavenProjectOrNull, Processor<T> processor, Function<? super MavenDomProfile, T> f) {
        Collection activeProfiles = mavenProjectOrNull == null ? null : mavenProjectOrNull.getActivatedProfilesIds().getEnabledProfiles();
        for (MavenDomProfile each : profilesDom.getProfiles()) {
            XmlTag idTag = each.getId().getXmlTag();
            if (idTag == null || activeProfiles != null && !activeProfiles.contains(idTag.getValue().getTrimmedText()) || !MavenDomProjectProcessorUtils.processProfile(each, processor, f)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean processProfile(MavenDomProfile profileDom, Processor<T> processor, Function<? super MavenDomProfile, T> f) {
        Object t = f.fun((Object)profileDom);
        return t != null && processor.process(t);
    }

    private static /* synthetic */ boolean lambda$searchManagedPluginUsages$3(@Nullable String groupId, @NotNull String artifactId, Set usages, MavenDomProjectModel mavenDomProjectModel) {
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "lambda$searchManagedPluginUsages$3"));
        }
        for (MavenDomPlugin domPlugin : mavenDomProjectModel.getBuild().getPlugins().getPlugins()) {
            if (!MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId)) continue;
            usages.add(domPlugin);
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$searchDependencyUsages$2(@NotNull Set excludes, @NotNull DependencyConflictId dependencyId, Set usages, MavenDomProjectModel mavenDomProjectModel) {
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "lambda$searchDependencyUsages$2"));
        }
        if (dependencyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyId", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils", "lambda$searchDependencyUsages$2"));
        }
        for (MavenDomDependency domDependency : mavenDomProjectModel.getDependencies().getDependencies()) {
            if (excludes.contains(domDependency) || !dependencyId.equals(DependencyConflictId.create(domDependency))) continue;
            usages.add(domDependency);
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$collectProperties$1(Set properties, MavenDomProperties mavenDomProperties) {
        XmlTag propertiesTag = mavenDomProperties.getXmlTag();
        if (propertiesTag != null) {
            ContainerUtil.addAll((Collection)properties, (Object[])propertiesTag.getSubTags());
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$collectParentProjects$0(Set parents, MavenDomProjectModel model) {
        parents.add(model);
        return false;
    }

    public static abstract class SearchProcessor<R, T>
    implements Processor<T> {
        private R myResult;

        public final boolean process(T t) {
            R res = this.find(t);
            if (res != null) {
                this.myResult = res;
                return true;
            }
            return false;
        }

        @Nullable
        protected abstract R find(T var1);

        public R getResult() {
            return this.myResult;
        }
    }

    public static abstract class DomParentProjectFileProcessor<T>
    extends MavenParentProjectFileProcessor<T> {
        private final MavenProjectsManager myManager;

        public DomParentProjectFileProcessor(MavenProjectsManager manager) {
            this.myManager = manager;
        }

        @Override
        protected VirtualFile findManagedFile(@NotNull MavenId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils$DomParentProjectFileProcessor", "findManagedFile"));
            }
            MavenProject project = this.myManager.findProject(id);
            return project == null ? null : project.getFile();
        }

        @Nullable
        public T process(@NotNull MavenDomProjectModel projectDom) {
            VirtualFile projectFile;
            if (projectDom == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils$DomParentProjectFileProcessor", "process"));
            }
            MavenDomParent parent = projectDom.getMavenParent();
            MavenParentDesc parentDesc = null;
            if (DomUtil.hasXml((DomElement)parent)) {
                String parentGroupId = parent.getGroupId().getStringValue();
                String parentArtifactId = parent.getArtifactId().getStringValue();
                String parentVersion = parent.getVersion().getStringValue();
                String parentRelativePath = parent.getRelativePath().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)parentRelativePath)) {
                    parentRelativePath = "../pom.xml";
                }
                MavenId parentId = new MavenId(parentGroupId, parentArtifactId, parentVersion);
                parentDesc = new MavenParentDesc(parentId, parentRelativePath);
            }
            return (projectFile = MavenDomUtil.getVirtualFile(projectDom)) == null ? null : (T)this.process(this.myManager.getGeneralSettings(), projectFile, parentDesc);
        }
    }
}

