/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProfilesModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.plugins.groovy.MavenGroovyPomCompletionContributor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDomUtil {
    private static final Key<Pair<Long, Set<VirtualFile>>> FILTERED_RESOURCES_ROOTS_KEY = Key.create((String)"MavenDomUtil.FILTERED_RESOURCES_ROOTS");
    private static final Set<String> SUBTAGS_IN_SETTINGS_FILE = ContainerUtil.newHashSet((Object[])new String[]{"localRepository", "interactiveMode", "usePluginRegistry", "offline", "pluginGroups", "servers", "mirrors", "proxies", "profiles", "activeProfiles"});
    private static final Pattern XML_TAG_NAME_PATTERN = Pattern.compile("(\\S*)\\[(\\d*)\\]\\z");

    public static boolean isMavenFile(PsiFile file) {
        return MavenDomUtil.isProjectFile(file) || MavenDomUtil.isProfilesFile(file) || MavenDomUtil.isSettingsFile(file);
    }

    public static boolean isProjectFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return MavenUtil.isPomFileName(file.getName());
    }

    public static boolean isProfilesFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return "profiles.xml".equals(file.getName());
    }

    public static boolean isSettingsFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null || !"settings".equals(rootTag.getName())) {
            return false;
        }
        String xmlns = rootTag.getAttributeValue("xmlns");
        if (xmlns != null) {
            return xmlns.contains("maven");
        }
        boolean hasTag = false;
        for (PsiElement e = rootTag.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof XmlTag)) continue;
            if (SUBTAGS_IN_SETTINGS_FILE.contains(((XmlTag)e).getName())) {
                return true;
            }
            hasTag = true;
        }
        return !hasTag;
    }

    public static boolean isMavenFile(PsiElement element) {
        return MavenDomUtil.isMavenFile(element.getContainingFile());
    }

    @Nullable
    public static Module findContainingMavenizedModule(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findContainingMavenizedModule"));
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        Project project = psiFile.getProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject()) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = index.getModuleForFile(file);
        if (module == null || !manager.isMavenizedModule(module)) {
            return null;
        }
        return module;
    }

    public static boolean isMavenProperty(PsiElement target) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)target, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        return DomUtil.findDomElement((PsiElement)tag, MavenDomProperties.class) != null;
    }

    public static String calcRelativePath(VirtualFile parent, VirtualFile child) {
        String result = FileUtil.getRelativePath((String)parent.getPath(), (String)child.getPath(), (char)'/');
        if (result == null) {
            MavenLog.LOG.warn("cannot calculate relative path for\nparent: " + parent + "\nchild: " + child);
            result = child.getPath();
        }
        return FileUtil.toSystemIndependentName((String)result);
    }

    public static MavenDomParent updateMavenParent(MavenDomProjectModel mavenModel, MavenProject parentProject) {
        MavenDomParent result = mavenModel.getMavenParent();
        VirtualFile pomFile = DomUtil.getFile((DomElement)mavenModel).getVirtualFile();
        Project project = mavenModel.getXmlElement().getProject();
        MavenId parentId = parentProject.getMavenId();
        result.getGroupId().setStringValue(parentId.getGroupId());
        result.getArtifactId().setStringValue(parentId.getArtifactId());
        result.getVersion().setStringValue(parentId.getVersion());
        if (!Comparing.equal((Object)pomFile.getParent().getParent(), (Object)parentProject.getDirectoryFile())) {
            result.getRelativePath().setValue((Object)PsiManager.getInstance((Project)project).findFile(parentProject.getFile()));
        }
        return result;
    }

    public static <T> T getImmediateParent(ConvertContext context, Class<T> clazz) {
        DomElement parentElement = context.getInvocationElement().getParent();
        return (T)(clazz.isInstance(parentElement) ? parentElement : null);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getVirtualFile"));
        }
        XmlFile psiFile = DomUtil.getFile((DomElement)element);
        return MavenDomUtil.getVirtualFile((PsiFile)psiFile);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getVirtualFile"));
        }
        PsiFile psiFile = element.getContainingFile();
        return MavenDomUtil.getVirtualFile(psiFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = (psiFile = psiFile.getOriginalFile()).getVirtualFile();
        if (virtualFile instanceof LightVirtualFile) {
            virtualFile = (VirtualFile)ObjectUtils.chooseNotNull((Object)psiFile.getUserData(MavenGroovyPomCompletionContributor.ORIGINAL_POM_FILE), (Object)virtualFile);
        }
        return virtualFile;
    }

    @Nullable
    public static MavenProject findProject(@NotNull MavenDomProjectModel projectDom) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDom", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findProject"));
        }
        XmlElement element = projectDom.getXmlElement();
        if (element == null) {
            return null;
        }
        VirtualFile file = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findProject(file);
    }

    @Nullable
    public static MavenProject findContainingProject(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findContainingProject"));
        }
        XmlElement psi = element.getXmlElement();
        return psi == null ? null : MavenDomUtil.findContainingProject((PsiElement)psi);
    }

    @Nullable
    public static MavenProject findContainingProject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findContainingProject"));
        }
        VirtualFile file = MavenDomUtil.getVirtualFile(element);
        if (file == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findContainingProject(file);
    }

    @Nullable
    public static MavenDomProjectModel getMavenDomProjectModel(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomProjectModel"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomProjectModel"));
        }
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProjectModel.class);
    }

    @Nullable
    public static MavenDomProfiles getMavenDomProfilesModel(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomProfilesModel"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomProfilesModel"));
        }
        MavenDomProfilesModel model = MavenDomUtil.getMavenDomModel(project, file, MavenDomProfilesModel.class);
        if (model != null) {
            return model.getProfiles();
        }
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProfiles.class);
    }

    @Nullable
    public static <T extends MavenDomElement> T getMavenDomModel(@NotNull Project project, @NotNull VirtualFile file, @NotNull Class<T> clazz) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomModel"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomModel"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomModel"));
        }
        if (!file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(psiFile, clazz);
    }

    @Nullable
    public static <T extends MavenDomElement> T getMavenDomModel(@NotNull PsiFile file, @NotNull Class<T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomModel"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomModel"));
        }
        DomFileElement<T> fileElement = MavenDomUtil.getMavenDomFile(file, clazz);
        return (T)(fileElement == null ? null : (MavenDomElement)fileElement.getRootElement());
    }

    @Nullable
    private static <T extends MavenDomElement> DomFileElement<T> getMavenDomFile(@NotNull PsiFile file, @NotNull Class<T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomFile"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getMavenDomFile"));
        }
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, clazz);
    }

    @Nullable
    public static XmlTag findTag(@NotNull DomElement domElement, @NotNull String path) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findTag"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findTag"));
        }
        List elements = StringUtil.split((String)path, (String)".");
        if (elements.isEmpty()) {
            return null;
        }
        Pair<String, Integer> nameAndIndex = MavenDomUtil.translateTagName((String)elements.get(0));
        String name = (String)nameAndIndex.first;
        Integer index = (Integer)nameAndIndex.second;
        XmlTag result = domElement.getXmlTag();
        if (result == null || !name.equals(result.getName())) {
            return null;
        }
        result = MavenDomUtil.getIndexedTag(result, index);
        for (String each : elements.subList(1, elements.size())) {
            nameAndIndex = MavenDomUtil.translateTagName(each);
            name = (String)nameAndIndex.first;
            index = (Integer)nameAndIndex.second;
            if ((result = result.findFirstSubTag(name)) == null) {
                return null;
            }
            result = MavenDomUtil.getIndexedTag(result, index);
        }
        return result;
    }

    private static Pair<String, Integer> translateTagName(String text) {
        String tagName = text.trim();
        Integer index = null;
        Matcher matcher = XML_TAG_NAME_PATTERN.matcher(tagName);
        if (matcher.find()) {
            tagName = matcher.group(1);
            try {
                index = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return Pair.create((Object)tagName, index);
    }

    private static XmlTag getIndexedTag(XmlTag parent, Integer index) {
        if (index == null) {
            return parent;
        }
        XmlTag[] children = parent.getSubTags();
        if (index < 0 || index >= children.length) {
            return null;
        }
        return children[index];
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getPropertiesFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getPropertiesFile"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof PropertiesFile)) {
            return null;
        }
        return (PropertiesFile)psiFile;
    }

    @Nullable
    public static IProperty findProperty(@NotNull Project project, @NotNull VirtualFile file, @NotNull String propName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findProperty"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findProperty"));
        }
        if (propName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propName", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findProperty"));
        }
        PropertiesFile propertiesFile = MavenDomUtil.getPropertiesFile(project, file);
        return propertiesFile == null ? null : propertiesFile.findPropertyByKey(propName);
    }

    @Nullable
    public static PsiElement findPropertyValue(@NotNull Project project, @NotNull VirtualFile file, @NotNull String propName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findPropertyValue"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findPropertyValue"));
        }
        if (propName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propName", "org/jetbrains/idea/maven/dom/MavenDomUtil", "findPropertyValue"));
        }
        IProperty prop = MavenDomUtil.findProperty(project, file, propName);
        return prop == null ? null : prop.getPsiElement().getFirstChild().getNextSibling().getNextSibling();
    }

    private static Set<VirtualFile> getFilteredResourcesRoots(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getFilteredResourcesRoots"));
        }
        Pair cachedValue = mavenProject.getCachedValue(FILTERED_RESOURCES_ROOTS_KEY);
        if (cachedValue == null || ((Long)cachedValue.first).longValue() != VirtualFileManager.getInstance().getModificationCount()) {
            Set set = null;
            for (MavenResource resource : ContainerUtil.concat(mavenProject.getResources(), mavenProject.getTestResources())) {
                VirtualFile resourceDir;
                if (!resource.isFiltered() || (resourceDir = LocalFileSystem.getInstance().findFileByPath(resource.getDirectory())) == null) continue;
                if (set == null) {
                    set = new HashSet();
                }
                set.add(resourceDir);
            }
            if (set == null) {
                set = Collections.emptySet();
            }
            cachedValue = Pair.create((Object)VirtualFileManager.getInstance().getModificationCount(), set);
            mavenProject.putCachedValue(FILTERED_RESOURCES_ROOTS_KEY, cachedValue);
        }
        return (Set)cachedValue.second;
    }

    public static boolean isFilteredResourceFile(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        VirtualFile file = MavenDomUtil.getVirtualFile(psiFile);
        if (file == null) {
            return false;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(psiFile.getProject());
        MavenProject mavenProject = manager.findContainingProject(file);
        if (mavenProject == null) {
            return false;
        }
        Set<VirtualFile> filteredRoots = MavenDomUtil.getFilteredResourcesRoots(mavenProject);
        if (!filteredRoots.isEmpty()) {
            for (VirtualFile f = file.getParent(); f != null; f = f.getParent()) {
                if (!filteredRoots.contains(f)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<DomFileElement<MavenDomProjectModel>> collectProjectModels(Project p) {
        return DomService.getInstance().getFileElements(MavenDomProjectModel.class, p, GlobalSearchScope.projectScope((Project)p));
    }

    public static MavenId describe(PsiFile psiFile) {
        MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(psiFile, MavenDomProjectModel.class);
        String groupId = model.getGroupId().getStringValue();
        String artifactId = model.getArtifactId().getStringValue();
        String version = model.getVersion().getStringValue();
        if (groupId == null) {
            groupId = model.getMavenParent().getGroupId().getStringValue();
        }
        if (version == null) {
            version = model.getMavenParent().getVersion().getStringValue();
        }
        return new MavenId(groupId, artifactId, version);
    }

    @NotNull
    public static MavenDomDependency createDomDependency(MavenDomProjectModel model, @Nullable Editor editor, @NotNull MavenId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        MavenDomDependency mavenDomDependency = MavenDomUtil.createDomDependency(model.getDependencies(), editor, id);
        if (mavenDomDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        return mavenDomDependency;
    }

    @NotNull
    public static MavenDomDependency createDomDependency(MavenDomDependencies dependencies, @Nullable Editor editor, @NotNull MavenId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        MavenDomDependency dep = MavenDomUtil.createDomDependency(dependencies, editor);
        dep.getGroupId().setStringValue(id.getGroupId());
        dep.getArtifactId().setStringValue(id.getArtifactId());
        dep.getVersion().setStringValue(id.getVersion());
        MavenDomDependency mavenDomDependency = dep;
        if (mavenDomDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        return mavenDomDependency;
    }

    @NotNull
    public static MavenDomDependency createDomDependency(@NotNull MavenDomProjectModel model, @Nullable Editor editor) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        MavenDomDependency mavenDomDependency = MavenDomUtil.createDomDependency(model.getDependencies(), editor);
        if (mavenDomDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        return mavenDomDependency;
    }

    @NotNull
    public static MavenDomDependency createDomDependency(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor) {
        DomElement element;
        DomCollectionChildDescription childDescription;
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        int index = MavenDomUtil.getCollectionIndex(dependencies, editor);
        if (index >= 0 && (childDescription = dependencies.getGenericInfo().getCollectionChildDescription("dependency")) != null && (element = childDescription.addValue((DomElement)dependencies, index)) instanceof MavenDomDependency) {
            MavenDomDependency mavenDomDependency = (MavenDomDependency)element;
            if (mavenDomDependency == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
            }
            return mavenDomDependency;
        }
        MavenDomDependency mavenDomDependency = dependencies.addDependency();
        if (mavenDomDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenDomUtil", "createDomDependency"));
        }
        return mavenDomDependency;
    }

    public static int getCollectionIndex(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/idea/maven/dom/MavenDomUtil", "getCollectionIndex"));
        }
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            List<MavenDomDependency> dependencyList = dependencies.getDependencies();
            for (int i = 0; i < dependencyList.size(); ++i) {
                MavenDomDependency dependency = dependencyList.get(i);
                XmlElement xmlElement = dependency.getXmlElement();
                if (xmlElement == null || xmlElement.getTextRange().getStartOffset() < offset) continue;
                return i;
            }
        }
        return -1;
    }
}

