/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.plugins.api.MavenSoftAwareReferenceProvider;

public class MavenDependencyReferenceProvider
extends PsiReferenceProvider
implements MavenSoftAwareReferenceProvider {
    private boolean mySoft = true;
    private boolean myCanHasVersion = true;

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider", "getReferencesByElement"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        String text = range.substring(element.getText());
        int firstDelim = text.indexOf(58);
        if (firstDelim == -1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GroupReference(element, range, this.mySoft)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        int secondDelim = this.myCanHasVersion ? text.indexOf(58, firstDelim + 1) : -1;
        int start = range.getStartOffset();
        if (secondDelim == -1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GroupReference(element, new TextRange(start, start + firstDelim), this.mySoft), new ArtifactReference(text.substring(0, firstDelim), element, new TextRange(start + firstDelim + 1, range.getEndOffset()), this.mySoft)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        int lastDelim = text.indexOf(secondDelim + 1);
        if (lastDelim == -1) {
            lastDelim = text.length();
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new GroupReference(element, new TextRange(start, start + firstDelim), this.mySoft), new ArtifactReference(text.substring(0, firstDelim), element, new TextRange(start + firstDelim + 1, start + secondDelim), this.mySoft), new VersionReference(text.substring(0, firstDelim), text.substring(firstDelim + 1, secondDelim), element, new TextRange(start + secondDelim + 1, start + lastDelim), this.mySoft)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @Override
    public void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isCanHasVersion() {
        return this.myCanHasVersion;
    }

    public void setCanHasVersion(boolean canHasVersion) {
        this.myCanHasVersion = canHasVersion;
    }

    public static class VersionReference
    extends PsiReferenceBase<PsiElement> {
        private final String myGroupId;
        private final String myArtifactId;

        public VersionReference(@NotNull String groupId, @NotNull String artifactId, @NotNull PsiElement element, @NotNull TextRange range, @NotNull boolean soft) {
            if (groupId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference", "<init>"));
            }
            if (artifactId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference", "<init>"));
            }
            super(element, range, soft);
            this.myGroupId = groupId;
            this.myArtifactId = artifactId;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (StringUtil.isEmptyOrSpaces((String)this.myGroupId) || StringUtil.isEmptyOrSpaces((String)this.myArtifactId)) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(this.getElement().getProject());
            Object[] objectArray = manager.getVersions(this.myGroupId, this.myArtifactId).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference", "getVariants"));
            }
            return objectArray;
        }
    }

    public static class ArtifactReference
    extends PsiReferenceBase<PsiElement> {
        private final String myGroupId;

        public ArtifactReference(@NotNull String groupId, @NotNull PsiElement element, @NotNull TextRange range, @NotNull boolean soft) {
            if (groupId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$ArtifactReference", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$ArtifactReference", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$ArtifactReference", "<init>"));
            }
            super(element, range, soft);
            this.myGroupId = groupId;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (StringUtil.isEmptyOrSpaces((String)this.myGroupId)) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$ArtifactReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(this.getElement().getProject());
            Object[] objectArray = manager.getArtifactIds(this.myGroupId).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$ArtifactReference", "getVariants"));
            }
            return objectArray;
        }
    }

    private static class GroupReference
    extends PsiReferenceBase<PsiElement> {
        public GroupReference(PsiElement element, TextRange range, boolean soft) {
            super(element, range, soft);
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = MavenProjectIndicesManager.getInstance(this.getElement().getProject()).getGroupIds().toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$GroupReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

