/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

public abstract class FacetImporter<FACET_TYPE extends Facet, FACET_CONFIG_TYPE extends FacetConfiguration, FACET_TYPE_TYPE extends FacetType<FACET_TYPE, FACET_CONFIG_TYPE>>
extends MavenImporter {
    protected final FACET_TYPE_TYPE myFacetType;
    protected final String myDefaultFacetName;

    protected FacetImporter(String pluginGroupID, String pluginArtifactID, FACET_TYPE_TYPE type) {
        this(pluginGroupID, pluginArtifactID, type, type.getDefaultFacetName());
    }

    public FacetImporter(String pluginGroupID, String pluginArtifactID, FACET_TYPE_TYPE type, String defaultFacetName) {
        super(pluginGroupID, pluginArtifactID);
        this.myFacetType = type;
        this.myDefaultFacetName = defaultFacetName;
    }

    public FACET_TYPE_TYPE getFacetType() {
        return this.myFacetType;
    }

    public String getDefaultFacetName() {
        return this.myDefaultFacetName;
    }

    @Override
    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
        this.prepareImporter(mavenProject);
        if (!this.isFacetDetectionDisabled(module.getProject())) {
            this.disableFacetAutodetection(module, modifiableModelsProvider);
            this.ensureFacetExists(module, mavenProject, modifiableModelsProvider);
        }
    }

    private void ensureFacetExists(Module module, MavenProject mavenProject, IdeModifiableModelsProvider modifiableModelsProvider) {
        ModifiableFacetModel model = modifiableModelsProvider.getModifiableFacetModel(module);
        Object f = this.findFacet((FacetModel)model);
        if (f != null) {
            return;
        }
        f = this.myFacetType.createFacet(module, this.myDefaultFacetName, this.myFacetType.createDefaultConfiguration(), null);
        model.addFacet(f);
        this.setupFacet(f, mavenProject);
    }

    protected void prepareImporter(MavenProject p) {
    }

    protected boolean isDisableFacetAutodetection(Module module) {
        return true;
    }

    private void disableFacetAutodetection(Module module, IdeModifiableModelsProvider provider) {
        if (!this.isDisableFacetAutodetection(module)) {
            return;
        }
        DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)module.getProject());
        FrameworkType frameworkType = FrameworkDetectionUtil.findFrameworkTypeForFacetDetector(this.myFacetType);
        if (frameworkType != null) {
            for (VirtualFile file : provider.getContentRoots(module)) {
                excludesConfiguration.addExcludedFile(file, frameworkType);
            }
        }
    }

    protected abstract void setupFacet(FACET_TYPE var1, MavenProject var2);

    @Override
    public void process(IdeModifiableModelsProvider modifiableModelsProvider, Module module, MavenRootModelAdapter rootModel, MavenProjectsTree mavenModel, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        FACET_TYPE f = this.findFacet((FacetModel)modifiableModelsProvider.getModifiableFacetModel(module));
        if (f == null) {
            return;
        }
        if (!this.isFacetDetectionDisabled(module.getProject())) {
            this.reimportFacet(modifiableModelsProvider, module, rootModel, f, mavenModel, mavenProject, changes, mavenProjectToModuleName, postTasks);
        }
    }

    private FACET_TYPE findFacet(FacetModel model) {
        return (FACET_TYPE)this.findFacet(model, (FacetType)this.myFacetType, this.myDefaultFacetName);
    }

    protected <T extends Facet> T findFacet(FacetModel model, FacetType<T, ?> type, String defaultFacetName) {
        Facet result = model.findFacet(type.getId(), defaultFacetName);
        if (result == null) {
            result = model.getFacetByType(type.getId());
        }
        return (T)result;
    }

    protected abstract void reimportFacet(IdeModifiableModelsProvider var1, Module var2, MavenRootModelAdapter var3, FACET_TYPE var4, MavenProjectsTree var5, MavenProject var6, MavenProjectChanges var7, Map<MavenProject, String> var8, List<MavenProjectsProcessorTask> var9);

    protected String getTargetName(MavenProject p) {
        return p.getFinalName();
    }

    protected String getTargetFileName(MavenProject p) {
        return this.getTargetFileName(p, "." + this.getTargetExtension(p));
    }

    protected String getTargetFileName(MavenProject p, String suffix) {
        return this.getTargetName(p) + suffix;
    }

    protected String getTargetFilePath(MavenProject p, String suffix) {
        return this.makePath(p, p.getBuildDirectory(), this.getTargetName(p) + suffix);
    }

    protected String getTargetOutputPath(MavenProject p, String ... subFoldersAndFile) {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(p.getBuildDirectory());
        Collections.addAll(elements, subFoldersAndFile);
        return this.makePath(p, ArrayUtil.toStringArray(elements));
    }

    protected String makePath(MavenProject p, String ... elements) {
        StringBuilder tailBuff = new StringBuilder();
        for (String e : elements) {
            if (tailBuff.length() > 0) {
                tailBuff.append("/");
            }
            tailBuff.append(e);
        }
        String tail = tailBuff.toString();
        String result = FileUtil.isAbsolute((String)tail) ? tail : new File(p.getDirectory(), tail).getPath();
        return FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)result));
    }

    protected String getTargetExtension(MavenProject p) {
        return p.getPackaging();
    }

    protected boolean isFacetDetectionDisabled(Project project) {
        DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
        FrameworkType frameworkType = FrameworkDetectionUtil.findFrameworkTypeForFacetDetector(this.myFacetType);
        if (frameworkType == null) {
            return false;
        }
        return excludesConfiguration.isExcludedFromDetection(frameworkType);
    }
}

