/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.ChangeToPairCreateQuickFix;

public class DontUseNewPairInspection
extends DevKitInspectionBase {
    private static final String PAIR_FQN = "com.intellij.openapi.util.Pair";

    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/DontUseNewPairInspection", "buildInternalVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                Object[] types;
                PsiType type = expression.getType();
                PsiExpressionList params = expression.getArgumentList();
                if (type instanceof PsiClassType && ((PsiClassType)type).rawType().equalsToText(DontUseNewPairInspection.PAIR_FQN) && params != null && expression.getArgumentList() != null && Arrays.equals(types = ((PsiClassType)type).getParameters(), params.getExpressionTypes())) {
                    holder.registerProblem((PsiElement)expression, "Replace to Pair.create()", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ChangeToPairCreateQuickFix()});
                }
                super.visitNewExpression(expression);
            }
        };
    }

    @NotNull
    public String getShortName() {
        if ("DontUsePairConstructor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/DontUseNewPairInspection", "getShortName"));
        }
        return "DontUsePairConstructor";
    }
}

