/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateHtmlDescriptionFix
implements LocalQuickFix,
Iconable {
    @NonNls
    private static final String TEMPLATE_NAME = "InspectionDescription.html";
    private final String myFilename;
    private final Module myModule;
    private final DescriptionType myDescriptionType;

    public CreateHtmlDescriptionFix(String filename, Module module, DescriptionType descriptionType) {
        this.myModule = module;
        this.myDescriptionType = descriptionType;
        this.myFilename = this.getNormalizedFileName(filename);
    }

    private boolean isFixedDescriptionFilename() {
        return this.myDescriptionType.isFixedDescriptionFilename();
    }

    private static List<VirtualFile> getPotentialRoots(Module module, PsiDirectory[] dirs) {
        if (dirs.length != 0) {
            return ((StreamEx)StreamEx.of((Object[])dirs).map(PsiDirectory::getParentDirectory).nonNull()).map(PsiDirectory::getVirtualFile).toList();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        List resourceRoots = rootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (!resourceRoots.isEmpty()) {
            return resourceRoots;
        }
        return rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
    }

    private String getNormalizedFileName(String filename) {
        return this.myDescriptionType.isFixedDescriptionFilename() ? filename : filename + ".html";
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("create.description.file", this.getNewFileName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("DevKit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "getFamilyName"));
        }
        return "DevKit";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "applyFix"));
        }
        PsiDirectory[] dirs = this.getDirectories();
        List<VirtualFile> virtualFiles = CreateHtmlDescriptionFix.getPotentialRoots(this.myModule, dirs);
        Object[] roots = this.prepare(VfsUtilCore.toVirtualFileArray(virtualFiles));
        if (roots.length == 1) {
            ApplicationManager.getApplication().runWriteAction(() -> this.lambda$applyFix$0((VirtualFile[])roots));
        } else {
            List options = StreamEx.of((Object[])roots).map(this::getPath).toList();
            JBList files = new JBList((Object[])ArrayUtil.toStringArray((Collection)options));
            files.setSelectionMode(0);
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)files).setTitle(DevKitBundle.message("select.target.location.of.description", this.myFilename)).setItemChoosenCallback(() -> this.lambda$applyFix$2(files, (VirtualFile[])roots)).createPopup();
            Editor editor = FileEditorManager.getInstance((Project)this.myModule.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            popup.showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private String getPath(VirtualFile file) {
        String path = file.getPresentableUrl() + File.separator + this.getDescriptionFolderName() + File.separator + this.myFilename;
        if (this.isFixedDescriptionFilename()) {
            path = path + File.separator + "description.html";
        }
        return path;
    }

    private PsiDirectory[] getDirectories() {
        return DescriptionCheckerUtil.getDescriptionsDirs(this.myModule, this.myDescriptionType);
    }

    private void createDescription(VirtualFile root) {
        if (!root.isDirectory()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        PsiDirectory psiRoot = psiManager.findDirectory(root);
        if (psiRoot == null) {
            return;
        }
        PsiDirectory descrRoot = StreamEx.of((Object[])psiRoot.getSubdirectories()).findFirst(dir -> this.getDescriptionFolderName().equals(dir.getName())).orElse(null);
        try {
            VirtualFile file;
            FileTemplate descrTemplate;
            PsiElement template;
            PsiDirectory dir2;
            PsiDirectory psiDirectory = descrRoot = descrRoot == null ? psiRoot.createSubdirectory(this.getDescriptionFolderName()) : descrRoot;
            if (this.isFixedDescriptionFilename() && (dir2 = descrRoot.findSubdirectory(this.myFilename)) == null) {
                descrRoot = descrRoot.createSubdirectory(this.myFilename);
            }
            if ((template = FileTemplateUtil.createFromTemplate((FileTemplate)(descrTemplate = FileTemplateManager.getInstance((Project)this.myModule.getProject()).getJ2eeTemplate(TEMPLATE_NAME)), (String)this.getNewFileName(), null, (PsiDirectory)descrRoot)) instanceof PsiFile && (file = ((PsiFile)template).getVirtualFile()) != null) {
                FileEditorManager.getInstance((Project)this.myModule.getProject()).openFile(file, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getNewFileName() {
        return this.isFixedDescriptionFilename() ? "description.html" : this.myFilename;
    }

    public Icon getIcon(int flags) {
        return new LayeredIcon(new Icon[]{AllIcons.FileTypes.Html, AllIcons.Actions.New});
    }

    private VirtualFile[] prepare(VirtualFile[] roots) {
        VirtualFile[] found = (VirtualFile[])Arrays.stream(roots).filter(this::containsDescriptionDir).toArray(VirtualFile[]::new);
        return found.length > 0 ? found : roots;
    }

    private boolean containsDescriptionDir(VirtualFile root) {
        if (!root.isDirectory()) {
            return false;
        }
        return Arrays.stream(root.getChildren()).anyMatch(file -> file.isDirectory() && this.getDescriptionFolderName().equals(file.getName()));
    }

    private String getDescriptionFolderName() {
        return this.myDescriptionType.getDescriptionFolder();
    }

    private /* synthetic */ void lambda$applyFix$2(JBList files, VirtualFile[] roots) {
        int index = files.getSelectedIndex();
        if (0 <= index && index < roots.length) {
            ApplicationManager.getApplication().runWriteAction(() -> this.createDescription(roots[index]));
        }
    }

    private /* synthetic */ void lambda$applyFix$0(VirtualFile[] roots) {
        this.createDescription(roots[0]);
    }
}

