/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import org.jmol.adapter.readers.molxyz.V3000Rdr;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    private boolean optimize2D;
    private boolean haveAtomSerials;
    protected String dimension;
    protected boolean allow2D = true;
    private int iatom0;
    private V3000Rdr vr;

    @Override
    public void initializeReader() throws Exception {
        this.optimize2D = this.checkFilterKey("2D");
    }

    @Override
    protected boolean checkLine() throws Exception {
        boolean isMDL = this.line.startsWith("$MDL");
        if (isMDL) {
            this.discardLinesUntilStartsWith("$HDR");
            this.rd();
            if (this.line == null) {
                Logger.warn("$HDR not found in MDL RG file");
                this.continuing = false;
                return false;
            }
        } else if (this.line.equals("M  END")) {
            return true;
        }
        if (this.doGetModel(++this.modelNumber, null)) {
            this.iatom0 = this.asc.ac;
            this.processMolSdHeader();
            this.processCtab(isMDL);
            this.vr = null;
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        }
        if (this.line != null && this.line.indexOf("$$$$") < 0) {
            this.discardLinesUntilStartsWith("$$$$");
        }
        return true;
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderMR();
    }

    protected void finalizeReaderMR() throws Exception {
        if (this.optimize2D) {
            this.set2D();
        }
        this.isTrajectory = false;
        this.finalizeReaderASCR();
    }

    private void processMolSdHeader() throws Exception {
        String header = "";
        String thisDataSetName = this.line.trim();
        this.asc.setCollectionName(thisDataSetName);
        header = header + this.line + "\n";
        this.rd();
        if (this.line == null) {
            return;
        }
        header = header + this.line + "\n";
        String string = this.dimension = this.line.length() < 22 ? "3D" : this.line.substring(20, 22);
        if (this.dimension.equals("2D")) {
            if (!this.allow2D) {
                throw new Exception("File is 2D, not 3D");
            }
            this.appendLoadNote("This model is 2D. Its 3D structure has not been generated.");
        }
        this.asc.setInfo("dimension", this.dimension);
        this.rd();
        if (this.line == null) {
            return;
        }
        this.line = this.line.trim();
        header = header + this.line + "\n";
        Logger.info(header);
        this.checkCurrentLineForScript();
        this.asc.setInfo("fileHeader", header);
        this.newAtomSet(thisDataSetName);
    }

    private void processCtab(boolean isMDL) throws Exception {
        if (isMDL) {
            this.discardLinesUntilStartsWith("$CTAB");
        }
        if (this.rd() == null) {
            return;
        }
        if (this.line.indexOf("V3000") >= 0) {
            this.optimize2D = this.dimension.equals("2D");
            this.vr = ((V3000Rdr)this.getInterface("org.jmol.adapter.readers.molxyz.V3000Rdr")).set(this);
            this.discardLinesUntilContains("COUNTS");
            this.vr.readAtomsAndBonds(this.getTokens());
        } else {
            this.readAtomsAndBonds(this.parseIntRange(this.line, 0, 3), this.parseIntRange(this.line, 3, 6));
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtomsAndBonds(int ac, int bc) throws Exception {
        int i;
        for (i = 0; i < ac; ++i) {
            String elementSymbol;
            this.rd();
            int len = this.line.length();
            int charge = 0;
            int isotope = 0;
            int iAtom = Integer.MIN_VALUE;
            float x = this.parseFloatRange(this.line, 0, 10);
            float y = this.parseFloatRange(this.line, 10, 20);
            float z = this.parseFloatRange(this.line, 20, 30);
            if (len < 34) {
                elementSymbol = this.line.substring(31).trim();
            } else {
                elementSymbol = this.line.substring(31, 34).trim();
                if (len >= 39) {
                    int code = this.parseIntRange(this.line, 36, 39);
                    if (code >= 1 && code <= 7) {
                        charge = 4 - code;
                    }
                    if ((code = this.parseIntRange(this.line, 34, 36)) != 0 && code >= -3 && code <= 4) {
                        isotope = JmolAdapter.getNaturalIsotope(JmolAdapter.getElementNumber(elementSymbol));
                        switch (isotope) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                isotope = -code;
                                break;
                            }
                            default: {
                                isotope += code;
                            }
                        }
                    }
                    if (iAtom == Integer.MIN_VALUE && this.haveAtomSerials) {
                        iAtom = i + 1;
                    }
                }
            }
            this.addMolAtom(iAtom, isotope, elementSymbol, charge, x, y, z);
        }
        for (i = 0; i < bc; ++i) {
            this.rd();
            int stereo = 0;
            String iAtom1 = this.line.substring(0, 3).trim();
            String iAtom2 = this.line.substring(3, 6).trim();
            int order = this.parseIntRange(this.line, 6, 9);
            if (this.optimize2D && order == 1 && this.line.length() >= 12) {
                stereo = this.parseIntRange(this.line, 9, 12);
            }
            order = this.fixOrder(order, stereo);
            if (this.haveAtomSerials) {
                this.asc.addNewBondFromNames(iAtom1, iAtom2, order);
                continue;
            }
            this.asc.addNewBondWithOrder(this.iatom0 + this.parseIntStr(iAtom1) - 1, this.iatom0 + this.parseIntStr(iAtom2) - 1, order);
        }
        Hashtable<String, String> molData = new Hashtable<String, String>();
        this.rd();
        while (this.line != null && this.line.indexOf("$$$$") != 0) {
            if (this.line.indexOf(">") == 0) {
                this.readMolData(molData);
                continue;
            }
            if (this.line.startsWith("M  ISO")) {
                this.readIsotopes();
                continue;
            }
            this.rd();
        }
        if (!molData.isEmpty()) {
            this.asc.setModelInfoForSet("molData", molData, this.asc.iSet);
        }
    }

    private void readIsotopes() throws Exception {
        int n = this.parseIntAt(this.line, 6);
        try {
            int i0 = this.asc.getLastAtomSetAtomIndex();
            int pt = 9;
            for (int i = 0; i < n; ++i) {
                int ipt = this.parseIntAt(this.line, pt);
                Atom atom = this.asc.atoms[ipt + i0 - 1];
                int iso = this.parseIntAt(this.line, pt + 4);
                pt += 8;
                atom.elementSymbol = "" + iso + atom.elementSymbol;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.rd();
    }

    private void readMolData(Map<String, String> molData) throws Exception {
        Atom[] atoms = this.asc.atoms;
        String dataName = PT.trim(this.line, "> <").toLowerCase();
        String data = "";
        float[] fdata = null;
        while (this.rd() != null && !this.line.equals("$$$$") && this.line.length() > 0) {
            data = data + this.line + "\n";
        }
        data = PT.trim(data, "\n");
        Logger.info(dataName + ":" + PT.esc(data));
        molData.put(dataName, data);
        if (dataName.toUpperCase().contains("_PARTIAL_CHARGES")) {
            try {
                fdata = PT.parseFloatArray(data);
                int n = this.asc.ac;
                for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
                    atoms[i].partialCharge = 0.0f;
                }
                int pt = 0;
                int i = (int)fdata[pt++];
                while (--i >= 0) {
                    float partialCharge;
                    int atomIndex = (int)fdata[pt++] + this.iatom0 - 1;
                    atoms[atomIndex].partialCharge = partialCharge = fdata[pt++];
                }
            }
            catch (Exception e) {
                int n = this.asc.ac;
                for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
                    atoms[i].partialCharge = 0.0f;
                }
                return;
            }
        }
    }

    public void addMolAtom(int iAtom, int isotope, String elementSymbol, int charge, float x, float y, float z) {
        switch (isotope) {
            case 0: {
                break;
            }
            case -1: {
                elementSymbol = "D";
                break;
            }
            case -2: {
                elementSymbol = "T";
                break;
            }
            default: {
                elementSymbol = isotope + elementSymbol;
            }
        }
        if (this.optimize2D && z != 0.0f) {
            this.optimize2D = false;
        }
        Atom atom = new Atom();
        atom.elementSymbol = elementSymbol;
        atom.formalCharge = charge;
        this.setAtomCoordXYZ(atom, x, y, z);
        if (iAtom == Integer.MIN_VALUE) {
            this.asc.addAtom(atom);
        } else {
            this.haveAtomSerials = true;
            atom.atomSerial = iAtom;
            this.asc.addAtomWithMappedSerialNumber(atom);
        }
    }

    int fixOrder(int order, int stereo) {
        switch (order) {
            default: {
                return 1;
            }
            case 1: {
                switch (stereo) {
                    case 1: {
                        return 1025;
                    }
                    case 3: 
                    case 6: {
                        return 1041;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                return 515;
            }
            case 5: {
                return 66;
            }
            case 6: {
                return 513;
            }
            case 7: {
                return 514;
            }
            case 8: 
            case 9: {
                return 33;
            }
            case 14: {
                return 4;
            }
            case 15: {
                return 5;
            }
            case 16: {
                return 6;
            }
        }
        return order;
    }

    public void addMolBond(String iAtom1, String iAtom2, int order, int stereo) {
        order = this.fixOrder(order, stereo);
        if (this.haveAtomSerials) {
            this.asc.addNewBondFromNames(iAtom1, iAtom2, order);
        } else {
            this.asc.addNewBondWithOrder(this.iatom0 + this.parseIntStr(iAtom1) - 1, this.iatom0 + this.parseIntStr(iAtom2) - 1, order);
        }
    }
}

