/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.api.GenericBinaryDocument;
import javajs.util.OC;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.viewer.Viewer;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected GenericBinaryDocument binarydoc;
    protected OC out;
    protected String line;
    protected int[] next = new int[1];

    SurfaceFileReader() {
    }

    protected void setStream(String fileName, boolean isBigEndian) {
        this.binarydoc.setStream(fileName == null ? null : this.sg.atomDataServer.getBufferedInputStream(fileName), isBigEndian);
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initSR(sg);
    }

    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2SFR(sg, br);
    }

    void init2SFR(SurfaceGenerator sg, BufferedReader br) {
        this.init(sg);
        this.br = br;
    }

    GenericBinaryDocument newBinaryDocument() {
        return (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", (Viewer)this.sg.atomDataServer, "file");
    }

    @Override
    protected void setOutputChannel(OC out) {
        if (this.binarydoc == null) {
            this.out = out;
        } else {
            this.sg.setOutputChannel(this.binarydoc, out);
        }
    }

    @Override
    protected void closeReader() {
        this.closeReaderSFR();
    }

    protected void closeReaderSFR() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
        if (this.binarydoc != null) {
            this.binarydoc.close();
        }
    }

    @Override
    void discardTempData(boolean discardAll) {
        this.closeReader();
        this.discardTempDataSR(discardAll);
    }

    protected String[] getTokens() {
        return PT.getTokensAt(this.line, 0);
    }

    protected float parseFloat() {
        return PT.parseFloatNext(this.line, this.next);
    }

    protected float parseFloatStr(String s) {
        this.next[0] = 0;
        return PT.parseFloatNext(s, this.next);
    }

    protected float parseFloatRange(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return PT.parseFloatRange(s, iEnd, this.next);
    }

    protected int parseInt() {
        return PT.parseIntNext(this.line, this.next);
    }

    protected int parseIntStr(String s) {
        this.next[0] = 0;
        return PT.parseIntNext(s, this.next);
    }

    protected int parseIntNext(String s) {
        return PT.parseIntNext(s, this.next);
    }

    protected float[] parseFloatArrayStr(String s) {
        this.next[0] = 0;
        return PT.parseFloatArrayNext(s, this.next, null, null, null);
    }

    protected float[] parseFloatArray(float[] a, String strStart, String strEnd) {
        return PT.parseFloatArrayNext(this.line, this.next, a, strStart, strEnd);
    }

    protected String getQuotedStringNext() {
        return PT.getQuotedStringNext(this.line, this.next);
    }

    protected void skipTo(String info, String what) throws Exception {
        if (info != null) {
            while (this.rd().indexOf(info) < 0) {
            }
        }
        if (what != null) {
            this.next[0] = this.line.indexOf(what) + what.length() + 2;
        }
    }

    protected String rd() throws Exception {
        this.line = this.br.readLine();
        if (this.line != null) {
            this.nBytes += (long)this.line.length();
            if (this.out != null) {
                byte[] b = this.line.getBytes();
                this.out.write(b, 0, b.length);
                this.out.writeByteAsInt(10);
            }
        }
        return this.line;
    }
}

