/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

class RecentFilesDialog
extends JDialog
implements ActionListener,
WindowListener {
    String selectedFileName = null;
    private static final int MAX_FILES = 10;
    private JButton okButton;
    private JButton cancelButton;
    private JButton clearButton;
    String[] files = new String[10];
    JList<String> fileList;
    Properties props = new Properties();

    public RecentFilesDialog(Frame boss) {
        super(boss, GT._("Recent Files"), true);
        this.getFiles();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.okButton = this.addButton(buttonPanel, GT._("Open"));
        this.cancelButton = this.addButton(buttonPanel, GT._("Cancel"));
        this.clearButton = this.addButton(buttonPanel, GT._("Clear"));
        this.getContentPane().add("South", buttonPanel);
        this.fileList = new JList<String>(this.files);
        this.fileList.setSelectedIndex(0);
        this.fileList.setSelectionMode(0);
        MouseAdapter dblClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int dblClickIndex;
                if (e.getClickCount() == 2 && (dblClickIndex = RecentFilesDialog.this.fileList.locationToIndex(e.getPoint())) >= 0 && dblClickIndex < RecentFilesDialog.this.files.length && RecentFilesDialog.this.files[dblClickIndex] != null) {
                    RecentFilesDialog.this.selectedFileName = RecentFilesDialog.this.files[dblClickIndex];
                    RecentFilesDialog.this.close();
                }
            }
        };
        this.fileList.addMouseListener(dblClickListener);
        this.getContentPane().add("Center", this.fileList);
        this.setLocation(100, 100);
        this.pack();
    }

    private JButton addButton(JPanel buttonPanel, String label) {
        JButton btn = new JButton(label);
        btn.addActionListener(this);
        buttonPanel.add(btn);
        return btn;
    }

    private void getFiles() {
        this.props = JmolPanel.historyFile.getProperties();
        for (int i = 0; i < 10; ++i) {
            this.files[i] = this.props.getProperty("recentFilesFile" + i);
        }
    }

    public void addFile(String name) {
        int i;
        int currentPosition = -1;
        for (i = 0; i < 10; ++i) {
            if (!name.equals(this.files[i])) continue;
            currentPosition = i;
        }
        if (currentPosition == 0) {
            return;
        }
        if (currentPosition > 0) {
            for (i = currentPosition; i < 9; ++i) {
                this.files[i] = this.files[i + 1];
            }
        }
        for (int j = 8; j >= 0; --j) {
            this.files[j + 1] = this.files[j];
        }
        this.files[0] = name;
        this.fileList.setListData((String[])this.files);
        this.fileList.setSelectedIndex(0);
        this.pack();
        this.saveList();
    }

    public void saveList() {
        for (int i = 0; i < 10; ++i) {
            if (this.files[i] == null) continue;
            this.props.setProperty("recentFilesFile" + i, this.files[i]);
        }
        JmolPanel.historyFile.addProperties(this.props);
    }

    public String getFile() {
        return this.selectedFileName;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cancel();
        this.close();
    }

    void cancel() {
        this.selectedFileName = null;
    }

    void clear() {
        this.files = new String[10];
        this.fileList.setListData((String[])this.files);
        for (int i = 0; i < 10; ++i) {
            this.props.setProperty("recentFilesFile" + i, "");
        }
        JmolPanel.historyFile.addProperties(this.props);
        this.cancel();
    }

    void close() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int fileIndex = this.fileList.getSelectedIndex();
            if (fileIndex < this.files.length) {
                this.selectedFileName = this.files[fileIndex];
                this.close();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.cancel();
            this.close();
        } else if (e.getSource() == this.clearButton) {
            this.clear();
            this.close();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void notifyFileOpen(String fullPathName) {
        if (fullPathName != null && !fullPathName.equals("Jmol Model Kit")) {
            this.addFile(fullPathName);
        }
    }
}

