/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.AggregatePrimitivesVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValidateUploadHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet aPIDataSet) {
        OsmValidator.initializeTests();
        Collection<Test> collection = OsmValidator.getEnabledTests(true);
        if (collection.isEmpty()) {
            return true;
        }
        AggregatePrimitivesVisitor aggregatePrimitivesVisitor = new AggregatePrimitivesVisitor();
        aggregatePrimitivesVisitor.visit(aPIDataSet.getPrimitivesToAdd());
        Collection<OsmPrimitive> collection2 = aggregatePrimitivesVisitor.visit(aPIDataSet.getPrimitivesToUpdate());
        ArrayList<TestError> arrayList = new ArrayList<TestError>(30);
        for (Test test : collection) {
            test.setBeforeUpload(true);
            test.setPartialSelection(true);
            test.startTest(null);
            test.visit(collection2);
            test.endTest();
            if (ValidatorPreference.PREF_OTHER.get().booleanValue() && ValidatorPreference.PREF_OTHER_UPLOAD.get().booleanValue()) {
                arrayList.addAll(test.getErrors());
                continue;
            }
            for (TestError testError : test.getErrors()) {
                if (testError.getSeverity() == Severity.OTHER) continue;
                arrayList.add(testError);
            }
        }
        OsmDataLayer osmDataLayer = Main.getLayerManager().getEditLayer();
        if (osmDataLayer != null) {
            osmDataLayer.validationErrors.clear();
            osmDataLayer.validationErrors.addAll(arrayList);
        }
        if (Main.map != null) {
            Main.map.validatorDialog.tree.setErrors(arrayList);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        if (ValidatorPreference.PREF_USE_IGNORE.get().booleanValue()) {
            int n = 0;
            for (TestError testError : arrayList) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(testError.getIgnoreState());
                arrayList2.add(testError.getIgnoreGroup());
                arrayList2.add(testError.getIgnoreSubGroup());
                for (String string : arrayList2) {
                    if (string == null || !OsmValidator.hasIgnoredError(string)) continue;
                    testError.setIgnored(true);
                }
                if (testError.isIgnored()) continue;
                ++n;
            }
            if (n == 0) {
                return true;
            }
        }
        return ValidateUploadHook.displayErrorScreen(arrayList);
    }

    private static boolean displayErrorScreen(List<TestError> list) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ValidatorTreePanel validatorTreePanel = new ValidatorTreePanel(list);
        validatorTreePanel.expandAll();
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText("<html><body>" + I18n.tr("The following are results of automatic validation. Try fixing these, but be careful (don''t destroy valid data). When in doubt ignore them.<br>When you cancel this dialog, you can find the entries in the validator side panel to inspect them.", new Object[0]) + "<table align=\"center\"><tr><td align=\"left\"><b>" + I18n.tr("Errors", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Usually this should be fixed.", new Object[0]) + "</td></tr><tr><td align=\"left\"><b>" + I18n.tr("Warnings", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Fix these when possible.", new Object[0]) + "</td></tr><tr><td align=\"left\"><b>" + I18n.tr("Other", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Informational warnings, expect many false entries.", new Object[0]) + "</td></tr></table>");
        htmlPanel.setPreferredSize(new Dimension(500, 150));
        jPanel.add((Component)htmlPanel, GBC.eol().fill(2));
        jPanel.add((Component)new JScrollPane(validatorTreePanel), GBC.eol().fill(1));
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Suspicious data found. Upload anyway?", new Object[0]), I18n.tr("Continue upload", new Object[0]), I18n.tr("Cancel", new Object[0]));
        extendedDialog.setButtonIcons("ok.png", "cancel.png");
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            OsmValidator.initializeTests();
            OsmValidator.initializeErrorLayer();
            Main.map.validatorDialog.unfurlDialog();
            Main.getLayerManager().getLayersOfType(ValidatorLayer.class).forEach(AbstractMapViewPaintable::invalidate);
            return false;
        }
        return true;
    }
}

