/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.imagery.WMTSDefaultLayer;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class ImageryInfo
extends TileSourceInfo
implements Comparable<ImageryInfo>,
Attributed {
    private String origName;
    private String langName;
    private boolean defaultEntry;
    private String cookies;
    private String eulaAcceptanceRequired;
    private ImageryType imageryType = ImageryType.WMS;
    private double pixelPerDegree;
    private int defaultMaxZoom;
    private int defaultMinZoom;
    private ImageryBounds bounds;
    private List<String> serverProjections = Collections.emptyList();
    private String description;
    private String langDescription;
    private String attributionText;
    private String permissionReferenceURL;
    private String attributionLinkURL;
    private String attributionImage;
    private String attributionImageURL;
    private String termsOfUseText;
    private String termsOfUseURL;
    private String countryCode = "";
    private String date;
    private boolean bestMarked;
    private List<ImageryInfo> mirrors;
    private String icon;
    private boolean isGeoreferenceValid;
    private Collection<DefaultLayer> defaultLayers = Collections.emptyList();

    public ImageryInfo() {
    }

    public ImageryInfo(String string) {
        super(string);
    }

    public ImageryInfo(String string, String string2) {
        this(string);
        this.setExtendedUrl(string2);
    }

    public ImageryInfo(String string, String string2, String string3) {
        this(string);
        this.setExtendedUrl(string2);
        this.eulaAcceptanceRequired = string3;
    }

    public ImageryInfo(String string, String string2, String string3, String string4, String string5) {
        this(string);
        this.setExtendedUrl(string2);
        ImageryType imageryType = ImageryType.fromString(string3);
        this.cookies = string5;
        this.eulaAcceptanceRequired = string4;
        if (imageryType != null) {
            this.imageryType = imageryType;
        } else if (string3 != null && !string3.isEmpty()) {
            throw new IllegalArgumentException("unknown type: " + string3);
        }
    }

    public ImageryInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5);
        this.setId(string6);
    }

    public ImageryInfo(ImageryPreferenceEntry imageryPreferenceEntry) {
        super(imageryPreferenceEntry.name, imageryPreferenceEntry.url, imageryPreferenceEntry.id);
        CheckParameterUtil.ensureParameterNotNull(imageryPreferenceEntry.name, "name");
        CheckParameterUtil.ensureParameterNotNull(imageryPreferenceEntry.url, "url");
        this.description = imageryPreferenceEntry.description;
        this.cookies = imageryPreferenceEntry.cookies;
        this.eulaAcceptanceRequired = imageryPreferenceEntry.eula;
        this.imageryType = ImageryType.fromString(imageryPreferenceEntry.type);
        if (this.imageryType == null) {
            throw new IllegalArgumentException("unknown type");
        }
        this.pixelPerDegree = imageryPreferenceEntry.pixel_per_eastnorth;
        this.defaultMaxZoom = imageryPreferenceEntry.max_zoom;
        this.defaultMinZoom = imageryPreferenceEntry.min_zoom;
        if (imageryPreferenceEntry.bounds != null) {
            this.bounds = new ImageryBounds(imageryPreferenceEntry.bounds, ",");
            if (imageryPreferenceEntry.shapes != null) {
                try {
                    for (String string : imageryPreferenceEntry.shapes.split(";")) {
                        this.bounds.addShape(new Shape(string, ","));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.warn(illegalArgumentException);
                }
            }
        }
        if (imageryPreferenceEntry.projections != null && !imageryPreferenceEntry.projections.isEmpty()) {
            this.serverProjections = Arrays.asList(imageryPreferenceEntry.projections.split(","));
        }
        this.attributionText = imageryPreferenceEntry.attribution_text;
        this.attributionLinkURL = imageryPreferenceEntry.attribution_url;
        this.permissionReferenceURL = imageryPreferenceEntry.permission_reference_url;
        this.attributionImage = imageryPreferenceEntry.logo_image;
        this.attributionImageURL = imageryPreferenceEntry.logo_url;
        this.date = imageryPreferenceEntry.date;
        this.bestMarked = imageryPreferenceEntry.bestMarked;
        this.termsOfUseText = imageryPreferenceEntry.terms_of_use_text;
        this.termsOfUseURL = imageryPreferenceEntry.terms_of_use_url;
        this.countryCode = imageryPreferenceEntry.country_code;
        this.icon = imageryPreferenceEntry.icon;
        if (imageryPreferenceEntry.noTileHeaders != null) {
            this.noTileHeaders = imageryPreferenceEntry.noTileHeaders.toMap();
        }
        if (imageryPreferenceEntry.noTileChecksums != null) {
            this.noTileChecksums = imageryPreferenceEntry.noTileChecksums.toMap();
        }
        this.setTileSize(imageryPreferenceEntry.tileSize);
        this.metadataHeaders = imageryPreferenceEntry.metadataHeaders;
        this.isGeoreferenceValid = imageryPreferenceEntry.valid_georeference;
    }

    public ImageryInfo(ImageryInfo imageryInfo) {
        super(imageryInfo.name, imageryInfo.url, imageryInfo.id);
        this.origName = imageryInfo.origName;
        this.langName = imageryInfo.langName;
        this.bestMarked = imageryInfo.bestMarked;
        this.defaultEntry = imageryInfo.defaultEntry;
        this.cookies = imageryInfo.cookies;
        this.eulaAcceptanceRequired = null;
        this.imageryType = imageryInfo.imageryType;
        this.pixelPerDegree = imageryInfo.pixelPerDegree;
        this.defaultMaxZoom = imageryInfo.defaultMaxZoom;
        this.defaultMinZoom = imageryInfo.defaultMinZoom;
        this.bounds = imageryInfo.bounds;
        this.serverProjections = imageryInfo.serverProjections;
        this.attributionText = imageryInfo.attributionText;
        this.attributionLinkURL = imageryInfo.attributionLinkURL;
        this.permissionReferenceURL = imageryInfo.permissionReferenceURL;
        this.attributionImage = imageryInfo.attributionImage;
        this.attributionImageURL = imageryInfo.attributionImageURL;
        this.termsOfUseText = imageryInfo.termsOfUseText;
        this.termsOfUseURL = imageryInfo.termsOfUseURL;
        this.countryCode = imageryInfo.countryCode;
        this.date = imageryInfo.date;
        this.icon = imageryInfo.icon;
        this.description = imageryInfo.description;
        this.noTileHeaders = imageryInfo.noTileHeaders;
        this.noTileChecksums = imageryInfo.noTileChecksums;
        this.metadataHeaders = imageryInfo.metadataHeaders;
        this.isGeoreferenceValid = imageryInfo.isGeoreferenceValid;
        this.defaultLayers = imageryInfo.defaultLayers;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.imageryType});
    }

    public boolean equalsPref(ImageryInfo imageryInfo) {
        if (imageryInfo == null) {
            return false;
        }
        return Objects.equals(this.name, imageryInfo.name) && Objects.equals(this.id, imageryInfo.id) && Objects.equals(this.url, imageryInfo.url) && Objects.equals(this.bestMarked, imageryInfo.bestMarked) && Objects.equals(this.isGeoreferenceValid, imageryInfo.isGeoreferenceValid) && Objects.equals(this.cookies, imageryInfo.cookies) && Objects.equals(this.eulaAcceptanceRequired, imageryInfo.eulaAcceptanceRequired) && Objects.equals((Object)this.imageryType, (Object)imageryInfo.imageryType) && Objects.equals(this.defaultMaxZoom, imageryInfo.defaultMaxZoom) && Objects.equals(this.defaultMinZoom, imageryInfo.defaultMinZoom) && Objects.equals(this.bounds, imageryInfo.bounds) && Objects.equals(this.serverProjections, imageryInfo.serverProjections) && Objects.equals(this.attributionText, imageryInfo.attributionText) && Objects.equals(this.attributionLinkURL, imageryInfo.attributionLinkURL) && Objects.equals(this.permissionReferenceURL, imageryInfo.permissionReferenceURL) && Objects.equals(this.attributionImageURL, imageryInfo.attributionImageURL) && Objects.equals(this.attributionImage, imageryInfo.attributionImage) && Objects.equals(this.termsOfUseText, imageryInfo.termsOfUseText) && Objects.equals(this.termsOfUseURL, imageryInfo.termsOfUseURL) && Objects.equals(this.countryCode, imageryInfo.countryCode) && Objects.equals(this.date, imageryInfo.date) && Objects.equals(this.icon, imageryInfo.icon) && Objects.equals(this.description, imageryInfo.description) && Objects.equals(this.noTileHeaders, imageryInfo.noTileHeaders) && Objects.equals(this.noTileChecksums, imageryInfo.noTileChecksums) && Objects.equals(this.metadataHeaders, imageryInfo.metadataHeaders) && Objects.equals(this.defaultLayers, imageryInfo.defaultLayers);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ImageryInfo imageryInfo = (ImageryInfo)object;
        return this.imageryType == imageryInfo.imageryType && Objects.equals(this.url, imageryInfo.url);
    }

    public String toString() {
        return "ImageryInfo{name='" + this.name + '\'' + ", countryCode='" + this.countryCode + '\'' + ", url='" + this.url + '\'' + ", imageryType=" + (Object)((Object)this.imageryType) + '}';
    }

    @Override
    public int compareTo(ImageryInfo imageryInfo) {
        int n = this.countryCode.compareTo(imageryInfo.countryCode);
        if (n == 0) {
            n = this.name.toLowerCase(Locale.ENGLISH).compareTo(imageryInfo.name.toLowerCase(Locale.ENGLISH));
        }
        if (n == 0) {
            n = this.url.compareTo(imageryInfo.url);
        }
        if (n == 0) {
            n = Double.compare(this.pixelPerDegree, imageryInfo.pixelPerDegree);
        }
        return n;
    }

    public boolean equalsBaseValues(ImageryInfo imageryInfo) {
        return this.url.equals(imageryInfo.url);
    }

    public void setPixelPerDegree(double d) {
        this.pixelPerDegree = d;
    }

    public void setDefaultMaxZoom(int n) {
        this.defaultMaxZoom = n;
    }

    public void setDefaultMinZoom(int n) {
        this.defaultMinZoom = n;
    }

    public void setBounds(ImageryBounds imageryBounds) {
        this.bounds = imageryBounds;
    }

    public ImageryBounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean requiresAttribution() {
        return this.attributionText != null || this.attributionLinkURL != null || this.attributionImage != null || this.termsOfUseText != null || this.termsOfUseURL != null;
    }

    @Override
    public String getAttributionText(int n, ICoordinate iCoordinate, ICoordinate iCoordinate2) {
        return this.attributionText;
    }

    @Override
    public String getAttributionLinkURL() {
        return this.attributionLinkURL;
    }

    public String getPermissionReferenceURL() {
        return this.permissionReferenceURL;
    }

    @Override
    public Image getAttributionImage() {
        ImageIcon imageIcon = ImageProvider.getIfAvailable(this.attributionImage);
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    public String getAttributionImageRaw() {
        return this.attributionImage;
    }

    @Override
    public String getAttributionImageURL() {
        return this.attributionImageURL;
    }

    @Override
    public String getTermsOfUseText() {
        return this.termsOfUseText;
    }

    @Override
    public String getTermsOfUseURL() {
        return this.termsOfUseURL;
    }

    public void setAttributionText(String string) {
        this.attributionText = string;
    }

    public void setAttributionImageURL(String string) {
        this.attributionImageURL = string;
    }

    public void setAttributionImage(String string) {
        this.attributionImage = string;
    }

    public void setAttributionLinkURL(String string) {
        this.attributionLinkURL = string;
    }

    public void setPermissionReferenceURL(String string) {
        this.permissionReferenceURL = string;
    }

    public void setTermsOfUseText(String string) {
        this.termsOfUseText = string;
    }

    public void setTermsOfUseURL(String string) {
        this.termsOfUseURL = string;
    }

    public void setExtendedUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string);
        this.url = string;
        this.imageryType = ImageryType.WMS;
        this.defaultMaxZoom = 0;
        this.defaultMinZoom = 0;
        for (ImageryType imageryType : ImageryType.values()) {
            Matcher object = Pattern.compile(imageryType.getTypeString() + "(?:\\[(?:(\\d+)[,-])?(\\d+)\\])?:(.*)").matcher(string);
            if (!object.matches()) continue;
            this.url = object.group(3);
            this.imageryType = imageryType;
            if (object.group(2) != null) {
                this.defaultMaxZoom = Integer.parseInt(object.group(2));
            }
            if (object.group(1) == null) break;
            this.defaultMinZoom = Integer.parseInt(object.group(1));
            break;
        }
        if (this.serverProjections.isEmpty()) {
            this.serverProjections = new ArrayList<String>();
            Matcher matcher = Pattern.compile(".*\\{PROJ\\(([^)}]+)\\)\\}.*").matcher(string.toUpperCase(Locale.ENGLISH));
            if (matcher.matches()) {
                for (String string2 : matcher.group(1).split(",")) {
                    this.serverProjections.add(string2);
                }
            }
        }
    }

    public String getOriginalName() {
        return this.origName != null ? this.origName : this.name;
    }

    public void setName(String string, String string2) {
        boolean bl = LanguageInfo.getJOSMLocaleCode(null).equals(string);
        if (LanguageInfo.isBetterLanguage(this.langName, string)) {
            this.name = bl ? I18n.tr(string2, new Object[0]) : string2;
            this.langName = string;
        }
        if (this.origName == null || bl) {
            this.origName = string2;
        }
    }

    public void clearId() {
        if (this.id != null) {
            TreeSet<String> treeSet = new TreeSet<String>(Main.pref.getCollection("imagery.layers.addedIds"));
            treeSet.add(this.id);
            Main.pref.putCollection("imagery.layers.addedIds", treeSet);
        }
        this.setId(null);
    }

    public boolean isDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(boolean bl) {
        this.defaultEntry = bl;
    }

    @Override
    public String getCookies() {
        return this.cookies;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    @Override
    public int getMaxZoom() {
        return this.defaultMaxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.defaultMinZoom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string, String string2) {
        boolean bl = LanguageInfo.getJOSMLocaleCode(null).equals(string);
        if (LanguageInfo.isBetterLanguage(this.langDescription, string)) {
            this.description = bl ? I18n.tr(string2, new Object[0]) : string2;
            this.langDescription = string;
        }
    }

    public String getToolTipText() {
        String string;
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        boolean bl = false;
        String string2 = this.getDate();
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append("<br>").append(I18n.tr("Date of imagery: {0}", string2));
            bl = true;
        }
        if (this.bestMarked) {
            stringBuilder.append("<br>").append(I18n.tr("This imagery is marked as best in this region in other editors.", new Object[0]));
            bl = true;
        }
        if ((string = this.getDescription()) != null && !string.isEmpty()) {
            stringBuilder.append("<br>").append(Utils.escapeReservedCharactersHTML(string));
            bl = true;
        }
        if (bl) {
            stringBuilder.insert(0, "<html>").append("</html>");
        }
        return stringBuilder.toString();
    }

    public String getEulaAcceptanceRequired() {
        return this.eulaAcceptanceRequired;
    }

    public void setEulaAcceptanceRequired(String string) {
        this.eulaAcceptanceRequired = string;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String string) {
        this.countryCode = string;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    public List<String> getServerProjections() {
        return Collections.unmodifiableList(this.serverProjections);
    }

    public void setServerProjections(Collection<String> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "serverProjections");
        this.serverProjections = new ArrayList<String>(collection);
    }

    public String getExtendedUrl() {
        return this.imageryType.getTypeString() + (this.defaultMaxZoom != 0 ? '[' + (this.defaultMinZoom != 0 ? Integer.toString(this.defaultMinZoom) + ',' : "") + this.defaultMaxZoom + ']' : "") + ':' + this.url;
    }

    public String getToolbarName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + "#PPD=" + this.pixelPerDegree;
        }
        return string;
    }

    public String getMenuName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + " (" + this.pixelPerDegree + ')';
        }
        return string;
    }

    public boolean hasAttribution() {
        return this.attributionText != null;
    }

    public void copyAttribution(ImageryInfo imageryInfo) {
        this.attributionImage = imageryInfo.attributionImage;
        this.attributionImageURL = imageryInfo.attributionImageURL;
        this.attributionText = imageryInfo.attributionText;
        this.attributionLinkURL = imageryInfo.attributionLinkURL;
        this.termsOfUseText = imageryInfo.termsOfUseText;
        this.termsOfUseURL = imageryInfo.termsOfUseURL;
    }

    public void setAttribution(AbstractTileSource abstractTileSource) {
        ImageIcon imageIcon;
        if (this.attributionText != null) {
            if ("osm".equals(this.attributionText)) {
                abstractTileSource.setAttributionText(new OsmTileSource.Mapnik().getAttributionText(0, null, null));
            } else {
                abstractTileSource.setAttributionText(this.attributionText);
            }
        }
        if (this.attributionLinkURL != null) {
            if ("osm".equals(this.attributionLinkURL)) {
                abstractTileSource.setAttributionLinkURL(new OsmTileSource.Mapnik().getAttributionLinkURL());
            } else {
                abstractTileSource.setAttributionLinkURL(this.attributionLinkURL);
            }
        }
        if (this.attributionImage != null && (imageIcon = ImageProvider.getIfAvailable(null, this.attributionImage)) != null) {
            abstractTileSource.setAttributionImage(imageIcon.getImage());
        }
        if (this.attributionImageURL != null) {
            abstractTileSource.setAttributionImageURL(this.attributionImageURL);
        }
        if (this.termsOfUseText != null) {
            abstractTileSource.setTermsOfUseText(this.termsOfUseText);
        }
        if (this.termsOfUseURL != null) {
            if ("osm".equals(this.termsOfUseURL)) {
                abstractTileSource.setTermsOfUseURL(new OsmTileSource.Mapnik().getTermsOfUseURL());
            } else {
                abstractTileSource.setTermsOfUseURL(this.termsOfUseURL);
            }
        }
    }

    public ImageryType getImageryType() {
        return this.imageryType;
    }

    public void setImageryType(ImageryType imageryType) {
        this.imageryType = imageryType;
    }

    public boolean isBlacklisted() {
        Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
        return capabilities != null && capabilities.isOnImageryBlacklist(this.url);
    }

    public void setNoTileHeaders(MultiMap<String, String> multiMap) {
        this.noTileHeaders = multiMap == null || multiMap.isEmpty() ? null : multiMap.toMap();
    }

    @Override
    public Map<String, Set<String>> getNoTileHeaders() {
        return this.noTileHeaders;
    }

    public void setNoTileChecksums(MultiMap<String, String> multiMap) {
        this.noTileChecksums = multiMap == null || multiMap.isEmpty() ? null : multiMap.toMap();
    }

    @Override
    public Map<String, Set<String>> getNoTileChecksums() {
        return this.noTileChecksums;
    }

    public void setMetadataHeaders(Map<String, String> map) {
        this.metadataHeaders = map == null || map.isEmpty() ? null : map;
    }

    public boolean isGeoreferenceValid() {
        return this.isGeoreferenceValid;
    }

    public void setGeoreferenceValid(boolean bl) {
        this.isGeoreferenceValid = bl;
    }

    public boolean isBestMarked() {
        return this.bestMarked;
    }

    public void setBestMarked(boolean bl) {
        this.bestMarked = bl;
    }

    public void addMirror(ImageryInfo imageryInfo) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<ImageryInfo>();
        }
        this.mirrors.add(imageryInfo);
    }

    public List<ImageryInfo> getMirrors() {
        ArrayList<ImageryInfo> arrayList = new ArrayList<ImageryInfo>();
        if (this.mirrors != null) {
            int n = 1;
            for (ImageryInfo imageryInfo : this.mirrors) {
                ImageryInfo imageryInfo2 = new ImageryInfo(this);
                if (imageryInfo.defaultMaxZoom != 0) {
                    imageryInfo2.defaultMaxZoom = imageryInfo.defaultMaxZoom;
                }
                if (imageryInfo.defaultMinZoom != 0) {
                    imageryInfo2.defaultMinZoom = imageryInfo.defaultMinZoom;
                }
                imageryInfo2.setServerProjections(imageryInfo.getServerProjections());
                imageryInfo2.url = imageryInfo.url;
                imageryInfo2.imageryType = imageryInfo.imageryType;
                if (imageryInfo.getTileSize() != 0) {
                    imageryInfo2.setTileSize(imageryInfo.getTileSize());
                }
                if (imageryInfo2.id != null) {
                    imageryInfo2.id = imageryInfo2.id + "_mirror" + n;
                }
                if (n > 1) {
                    imageryInfo2.name = I18n.tr("{0} mirror server {1}", imageryInfo2.name, n);
                    if (imageryInfo2.origName != null) {
                        imageryInfo2.origName = imageryInfo2.origName + " mirror server " + n;
                    }
                } else {
                    imageryInfo2.name = I18n.tr("{0} mirror server", imageryInfo2.name);
                    if (imageryInfo2.origName != null) {
                        imageryInfo2.origName = imageryInfo2.origName + " mirror server";
                    }
                }
                arrayList.add(imageryInfo2);
                ++n;
            }
        }
        return arrayList;
    }

    public Collection<DefaultLayer> getDefaultLayers() {
        return this.defaultLayers;
    }

    public void setDefaultLayers(Collection<DefaultLayer> collection) {
        if (ImageryType.WMTS.equals((Object)this.imageryType)) {
            CheckParameterUtil.ensureThat(collection == null || collection.isEmpty() || collection.iterator().next() instanceof WMTSDefaultLayer, "Incorrect default layer");
        }
        this.defaultLayers = collection;
    }

    public static class ImageryPreferenceEntry {
        @Preferences.pref
        String name;
        @Preferences.pref
        String d;
        @Preferences.pref
        String id;
        @Preferences.pref
        String type;
        @Preferences.pref
        String url;
        @Preferences.pref
        double pixel_per_eastnorth;
        @Preferences.pref
        String eula;
        @Preferences.pref
        String attribution_text;
        @Preferences.pref
        String attribution_url;
        @Preferences.pref
        String permission_reference_url;
        @Preferences.pref
        String logo_image;
        @Preferences.pref
        String logo_url;
        @Preferences.pref
        String terms_of_use_text;
        @Preferences.pref
        String terms_of_use_url;
        @Preferences.pref
        String country_code = "";
        @Preferences.pref
        String date;
        @Preferences.pref
        int max_zoom;
        @Preferences.pref
        int min_zoom;
        @Preferences.pref
        String cookies;
        @Preferences.pref
        String bounds;
        @Preferences.pref
        String shapes;
        @Preferences.pref
        String projections;
        @Preferences.pref
        String icon;
        @Preferences.pref
        String description;
        @Preferences.pref
        MultiMap<String, String> noTileHeaders;
        @Preferences.pref
        MultiMap<String, String> noTileChecksums;
        @Preferences.pref
        int tileSize = -1;
        @Preferences.pref
        Map<String, String> metadataHeaders;
        @Preferences.pref
        boolean valid_georeference;
        @Preferences.pref
        boolean bestMarked;

        public ImageryPreferenceEntry() {
        }

        public ImageryPreferenceEntry(ImageryInfo imageryInfo) {
            this.name = imageryInfo.name;
            this.id = imageryInfo.id;
            this.type = imageryInfo.imageryType.getTypeString();
            this.url = imageryInfo.url;
            this.pixel_per_eastnorth = imageryInfo.pixelPerDegree;
            this.eula = imageryInfo.eulaAcceptanceRequired;
            this.attribution_text = imageryInfo.attributionText;
            this.attribution_url = imageryInfo.attributionLinkURL;
            this.permission_reference_url = imageryInfo.permissionReferenceURL;
            this.date = imageryInfo.date;
            this.bestMarked = imageryInfo.bestMarked;
            this.logo_image = imageryInfo.attributionImage;
            this.logo_url = imageryInfo.attributionImageURL;
            this.terms_of_use_text = imageryInfo.termsOfUseText;
            this.terms_of_use_url = imageryInfo.termsOfUseURL;
            this.country_code = imageryInfo.countryCode;
            this.max_zoom = imageryInfo.defaultMaxZoom;
            this.min_zoom = imageryInfo.defaultMinZoom;
            this.cookies = imageryInfo.cookies;
            this.icon = imageryInfo.icon;
            this.description = imageryInfo.description;
            if (imageryInfo.bounds != null) {
                this.bounds = imageryInfo.bounds.encodeAsString(",");
                StringBuilder stringBuilder = new StringBuilder();
                for (Shape shape : imageryInfo.bounds.getShapes()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(';');
                    }
                    stringBuilder.append(shape.encodeAsString(","));
                }
                if (stringBuilder.length() > 0) {
                    this.shapes = stringBuilder.toString();
                }
            }
            this.projections = imageryInfo.serverProjections.stream().collect(Collectors.joining(","));
            if (imageryInfo.noTileHeaders != null && !imageryInfo.noTileHeaders.isEmpty()) {
                this.noTileHeaders = new MultiMap(imageryInfo.noTileHeaders);
            }
            if (imageryInfo.noTileChecksums != null && !imageryInfo.noTileChecksums.isEmpty()) {
                this.noTileChecksums = new MultiMap(imageryInfo.noTileChecksums);
            }
            if (imageryInfo.metadataHeaders != null && !imageryInfo.metadataHeaders.isEmpty()) {
                this.metadataHeaders = imageryInfo.metadataHeaders;
            }
            this.tileSize = imageryInfo.getTileSize();
            this.valid_georeference = imageryInfo.isGeoreferenceValid();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ImageryPreferenceEntry [name=").append(this.name);
            if (this.id != null) {
                stringBuilder.append(" id=").append(this.id);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static class ImageryBounds
    extends Bounds {
        private List<Shape> shapes = new ArrayList<Shape>();

        public ImageryBounds(String string, String string2) {
            super(string, string2);
        }

        public final void addShape(Shape shape) {
            this.shapes.add(shape);
        }

        public final void setShapes(List<Shape> list) {
            this.shapes = list;
        }

        public final List<Shape> getShapes() {
            return this.shapes;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.shapes);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ImageryBounds imageryBounds = (ImageryBounds)object;
            return Objects.equals(this.shapes, imageryBounds.shapes);
        }
    }

    public static enum ImageryType {
        WMS("wms"),
        TMS("tms"),
        BING("bing"),
        SCANEX("scanex"),
        WMS_ENDPOINT("wms_endpoint"),
        WMTS("wmts");

        private final String typeString;

        private ImageryType(String string2) {
            this.typeString = string2;
        }

        public final String getTypeString() {
            return this.typeString;
        }

        public static ImageryType fromString(String string) {
            for (ImageryType imageryType : ImageryType.values()) {
                if (!imageryType.getTypeString().equals(string)) continue;
                return imageryType;
            }
            return null;
        }
    }
}

