/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractTagPaster;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.TextTagParser;

public final class TextTagPaster
extends AbstractTagPaster {
    private static final String help = HelpUtil.ht("/Action/PasteTags");

    public TextTagPaster() {
        super(DataFlavor.stringFlavor);
    }

    @Override
    public boolean supports(TransferHandler.TransferSupport transferSupport) {
        try {
            return super.supports(transferSupport) && this.containsValidTags(transferSupport);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Main.warn(exception);
            return false;
        }
    }

    private boolean containsValidTags(TransferHandler.TransferSupport transferSupport) throws UnsupportedFlavorException, IOException {
        return !this.getTagsImpl(transferSupport).isEmpty();
    }

    @Override
    protected Map<String, String> getTags(TransferHandler.TransferSupport transferSupport) throws UnsupportedFlavorException, IOException {
        Map<String, String> map = this.getTagsImpl(transferSupport);
        if (map.isEmpty()) {
            TextTagParser.showBadBufferMessage(help);
            throw new IOException("Invalid tags to paste.");
        }
        if (!TextTagParser.validateTags(map)) {
            throw new IOException("Tags to paste are not valid.");
        }
        return map;
    }

    private Map<String, String> getTagsImpl(TransferHandler.TransferSupport transferSupport) throws UnsupportedFlavorException, IOException {
        return TextTagParser.readTagsFromText((String)transferSupport.getTransferable().getTransferData(this.df));
    }
}

