/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.impl.SimpleLogger;

public class MavenSimpleLogger
extends SimpleLogger {
    MavenSimpleLogger(String name) {
        super(name);
    }

    @Override
    protected String renderLevel(int level) {
        switch (level) {
            case 0: {
                return MessageUtils.buffer().debug((Object)"TRACE").toString();
            }
            case 10: {
                return MessageUtils.buffer().debug((Object)"DEBUG").toString();
            }
            case 20: {
                return MessageUtils.buffer().info((Object)"INFO").toString();
            }
            case 30: {
                return MessageUtils.buffer().warning((Object)"WARNING").toString();
            }
        }
        return MessageUtils.buffer().error((Object)"ERROR").toString();
    }

    @Override
    protected void renderThrowable(Throwable t, PrintStream stream) {
        stream.print(MessageUtils.buffer().failure((Object)t.getClass().getName()));
        if (t.getMessage() != null) {
            stream.print(": ");
            stream.print(MessageUtils.buffer().failure((Object)t.getMessage()));
        }
        stream.println();
        while (t != null) {
            for (StackTraceElement e : t.getStackTrace()) {
                stream.print("    ");
                stream.print(MessageUtils.buffer().strong((Object)"at"));
                stream.print(" " + e.getClassName() + "." + e.getMethodName());
                stream.print(MessageUtils.buffer().a((CharSequence)" (").strong((Object)this.getLocation(e)).a((CharSequence)")"));
                stream.println();
            }
            if ((t = t.getCause()) == null) continue;
            stream.print(MessageUtils.buffer().strong((Object)"Caused by").a((CharSequence)": ").a((CharSequence)t.getClass().getName()));
            if (t.getMessage() != null) {
                stream.print(": ");
                stream.print(MessageUtils.buffer().failure((Object)t.getMessage()));
            }
            stream.println();
        }
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return String.format("%s:%s", e.getFileName(), e.getLineNumber());
        }
        return e.getFileName();
    }
}

