/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Cursor;
import java.io.CharArrayReader;
import java.io.File;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JTextArea;
import proguard.gui.GUIResources;
import proguard.gui.MessageDialogRunnable;
import proguard.gui.TextAreaWriter;
import proguard.retrace.ReTrace;

final class ReTraceRunnable
implements Runnable {
    private final JTextArea consoleTextArea;
    private final boolean verbose;
    private final File mappingFile;
    private final String stackTrace;

    public ReTraceRunnable(JTextArea jTextArea, boolean bl, File file, String string) {
        this.consoleTextArea = jTextArea;
        this.verbose = bl;
        this.mappingFile = file;
        this.stackTrace = string;
    }

    public void run() {
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(3));
        this.consoleTextArea.setText("");
        LineNumberReader lineNumberReader = new LineNumberReader(new CharArrayReader(this.stackTrace.toCharArray()));
        PrintWriter printWriter = new PrintWriter((Writer)new TextAreaWriter(this.consoleTextArea), true);
        try {
            new ReTrace("(?:.*?\\bat\\s+%c\\.%m\\s*\\(%s(?::%l)?\\)\\s*(?:~\\[.*\\])?)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)", this.verbose, this.mappingFile).retrace(lineNumberReader, printWriter);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, exception.getMessage(), this.msg("errorReTracing"), 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.out.println(this.msg("outOfMemory"));
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, this.msg("outOfMemory"), this.msg("errorReTracing"), 0);
        }
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(0));
        this.consoleTextArea.setCaretPosition(0);
    }

    private String msg(String string) {
        return GUIResources.getMessage(string);
    }
}

