/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.DamagedHomeIOException;
import com.eteks.sweethome3d.io.HomeContentContext;
import com.eteks.sweethome3d.io.HomeXMLHandler;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHomeInputStream
extends FilterInputStream {
    private final ContentRecording contentRecording;
    private final HomeXMLHandler xmlHandler;
    private final UserPreferences preferences;
    private final boolean preferPreferencesContent;
    private File file;

    public DefaultHomeInputStream(InputStream inputStream) throws IOException {
        this(inputStream, ContentRecording.INCLUDE_ALL_CONTENT);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording) throws IOException {
        this(inputStream, contentRecording, null, false);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording, UserPreferences userPreferences, boolean bl) {
        this(inputStream, contentRecording, null, userPreferences, bl);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording, HomeXMLHandler homeXMLHandler, UserPreferences userPreferences, boolean bl) {
        super(inputStream);
        this.contentRecording = contentRecording;
        this.xmlHandler = homeXMLHandler;
        this.preferences = userPreferences;
        this.preferPreferencesContent = bl;
    }

    public DefaultHomeInputStream(File file, ContentRecording contentRecording, HomeXMLHandler homeXMLHandler, UserPreferences userPreferences, boolean bl) throws FileNotFoundException {
        super(new FileInputStream(file));
        this.file = file;
        this.contentRecording = contentRecording;
        this.xmlHandler = homeXMLHandler;
        this.preferences = userPreferences;
        this.preferPreferencesContent = bl;
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Home readHome() throws IOException, ClassNotFoundException {
        boolean bl = true;
        HomeContentContext homeContentContext = null;
        if (this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
            InputStream inputStream;
            Object object;
            if (this.file == null) {
                this.file = OperatingSystem.createTemporaryFile("open", ".sweethome3d");
                object = new BufferedOutputStream(new FileOutputStream(this.file));
                inputStream = new CopiedInputStream(new BufferedInputStream(this.in), (OutputStream)object);
            } else {
                inputStream = this.in;
            }
            object = new ArrayList<ZipEntry>();
            boolean bl2 = bl = this.isZipFileValidUsingInputStream(inputStream, (List<ZipEntry>)object) && object.size() > 0;
            if (!bl) {
                int n = object.size();
                object.clear();
                this.isZipFileValidUsingDictionnary(this.file, (List<ZipEntry>)object);
                this.file = object.size() > n ? this.createTemporaryFileFromValidEntries(this.file, (List<ZipEntry>)object) : this.createTemporaryFileFromValidEntriesCount(this.file, n);
            }
            homeContentContext = new HomeContentContext(this.file.toURI().toURL(), this.preferences, this.preferPreferencesContent);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        ZipInputStream zipInputStream = new ZipInputStream(this.contentRecording == ContentRecording.INCLUDE_NO_CONTENT ? this.in : new FileInputStream(this.file));
        ZipEntry zipEntry = null;
        try {
            Home home;
            Object object;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if ("Home".equals(zipEntry.getName())) {
                    bl3 = true;
                } else if (this.xmlHandler != null && "Home.xml".equals(zipEntry.getName())) {
                    bl4 = true;
                }
                if (!(this.contentRecording == ContentRecording.INCLUDE_NO_CONTENT ? bl3 || bl4 : bl3 && bl4)) continue;
            }
            DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            if (!bl3 && !bl4) {
                throw new IOException("Missing entry \"Home\" or \"Home.xml\"");
            }
            if (this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                zipInputStream.close();
                zipInputStream = new ZipInputStream(new FileInputStream(this.file));
                do {
                    zipEntry = zipInputStream.getNextEntry();
                } while (bl4 && !"Home.xml".equals(zipEntry.getName()) || !bl4 && !"Home".equals(zipEntry.getName()));
            }
            DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            if ("Home".equals(zipEntry.getName())) {
                object = new HomeObjectInputStream(zipInputStream, homeContentContext);
                home = (Home)((ObjectInputStream)object).readObject();
            } else {
                try {
                    object = SAXParserFactory.newInstance();
                    SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
                    this.xmlHandler.setContentContext(homeContentContext);
                    sAXParser.parse((InputStream)zipInputStream, (DefaultHandler)this.xmlHandler);
                    home = this.xmlHandler.getHome();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    IOException iOException = new IOException("Can't parse home XML stream");
                    iOException.initCause(parserConfigurationException);
                    throw iOException;
                }
                catch (SAXException sAXException) {
                    IOException iOException = new IOException("Can't parse home XML stream");
                    iOException.initCause(sAXException);
                    throw iOException;
                }
            }
            if (homeContentContext != null && (!bl || homeContentContext.containsInvalidContents())) {
                if (homeContentContext.containsCheckedContents()) {
                    home.setRepaired(true);
                } else {
                    throw new DamagedHomeIOException(home, homeContentContext.getInvalidContents());
                }
            }
            object = home;
            return object;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileValidUsingInputStream(InputStream inputStream, List<ZipEntry> list) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            byte[] byArray = new byte[8192];
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                while (zipInputStream.read(byArray) != -1) {
                }
                list.add(zipEntry);
                DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileValidUsingDictionnary(File file, List<ZipEntry> list) throws IOException {
        ZipFile zipFile = null;
        boolean bl = true;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    byte[] byArray = new byte[8192];
                    while (inputStream.read(byArray) != -1) {
                    }
                    inputStream.close();
                    list.add(zipEntry);
                    DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTemporaryFileFromValidEntriesCount(File file, int n) throws IOException {
        if (n <= 0) {
            throw new IOException("No valid entries");
        }
        File file2 = OperatingSystem.createTemporaryFile("part", ".sh3d");
        ZipOutputStream zipOutputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setLevel(0);
            while (n-- > 0) {
                this.copyEntry(zipInputStream, zipInputStream.getNextEntry(), zipOutputStream);
            }
            File file3 = file2;
            return file3;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTemporaryFileFromValidEntries(File file, List<ZipEntry> list) throws IOException {
        if (list.size() <= 0) {
            throw new IOException("No valid entries");
        }
        File file2 = OperatingSystem.createTemporaryFile("part", ".sh3d");
        ZipOutputStream zipOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setLevel(0);
            for (ZipEntry zipEntry : list) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                this.copyEntry(inputStream, zipEntry, zipOutputStream);
                inputStream.close();
            }
            File file3 = file2;
            return file3;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private void copyEntry(InputStream inputStream, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setExtra(zipEntry.getExtra());
        zipOutputStream.putNextEntry(zipEntry2);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        zipOutputStream.closeEntry();
    }

    private class HomeObjectInputStream
    extends ObjectInputStream {
        private HomeContentContext contentContext;

        public HomeObjectInputStream(InputStream inputStream, HomeContentContext homeContentContext) throws IOException {
            super(inputStream);
            if (DefaultHomeInputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableResolveObject(true);
                this.contentContext = homeContentContext;
            }
        }

        protected Object resolveObject(Object object) throws IOException {
            String string;
            if (object instanceof URLContent && (string = ((URLContent)object).getURL().toString()).startsWith("jar:file:temp!/")) {
                return this.contentContext.lookupContent(string.substring(string.indexOf(33) + 2));
            }
            return object;
        }
    }

    private class CopiedInputStream
    extends FilterInputStream {
        private OutputStream out;

        protected CopiedInputStream(InputStream inputStream, OutputStream outputStream) {
            super(inputStream);
            this.out = outputStream;
        }

        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                this.out.write(n);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.out.write(byArray, n, n3);
            }
            return n3;
        }

        public void close() throws IOException {
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = this.in.read(byArray)) != -1) {
                    this.out.write(byArray, 0, n);
                }
                this.out.flush();
            }
            finally {
                this.out.close();
                super.close();
            }
        }
    }
}

