/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.UndoManager;
import CH.ifa.draw.util.Undoable;

public class UndoCommand
extends AbstractCommand {
    public UndoCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        UndoManager um = this.getDrawingEditor().getUndoManager();
        if (um == null || !um.isUndoable()) {
            return;
        }
        Undoable lastUndoable = um.popUndo();
        boolean hasBeenUndone = lastUndoable.undo();
        if (hasBeenUndone && lastUndoable.isRedoable()) {
            um.pushRedo(lastUndoable);
        }
        lastUndoable.getDrawingView().checkDamage();
        this.getDrawingEditor().figureSelectionChanged(lastUndoable.getDrawingView());
    }

    public boolean isExecutableWithView() {
        UndoManager um = this.getDrawingEditor().getUndoManager();
        return um != null && um.getUndoSize() > 0;
    }
}

