/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpResponseHeader;

public class HttpOutputStream
extends BufferedOutputStream {
    private static final int BUFFER_SIZE = 4096;
    private static final String CODEPAGE = "8859_1";

    public HttpOutputStream(OutputStream outputStream) {
        super(outputStream, 4096);
    }

    public void write(String string) throws IOException {
        super.write(string.getBytes(CODEPAGE));
        this.flush();
    }

    public void write(HttpBody httpBody) throws IOException {
        if (httpBody != null && httpBody.length() > 0) {
            this.write(httpBody.toString().getBytes(CODEPAGE));
        }
    }

    public void write(HttpResponseHeader httpResponseHeader) throws IOException {
        this.write(httpResponseHeader.toString());
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.write(byArray, 0, n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return;
        }
        super.write(byArray, n, n2);
        this.flush();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }
}

