/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertTreeCellRenderer;
import org.zaproxy.zap.extension.alert.AlertTreeModel;
import org.zaproxy.zap.extension.alert.AlertViewPanel;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.DeselectableButtonGroup;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;

public class AlertPanel
extends AbstractPanel {
    public static final String ALERT_TREE_PANEL_NAME = "treeAlert";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AlertPanel.class);
    private ViewDelegate view = null;
    private JTree treeAlert = null;
    private JScrollPane paneScroll = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JSplitPane splitPane = null;
    private AlertViewPanel alertViewPanel = null;
    private ZapToggleButton scopeButton = null;
    private AlertTreeModel linkWithSitesTreeModel;
    private LinkWithSitesTreeSelectionListener linkWithSitesTreeSelectionListener;
    private ZapToggleButton linkWithSitesTreeButton;
    private DeselectableButtonGroup alertsTreeFiltersButtonGroup;
    private JButton editButton = null;
    private ExtensionAlert extension = null;
    private ExtensionHistory extHist = null;

    public AlertPanel(ExtensionAlert extensionAlert) {
        this.extension = extensionAlert;
        this.alertsTreeFiltersButtonGroup = new DeselectableButtonGroup();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(274, 251);
        this.setName(Constant.messages.getString("alerts.panel.title"));
        this.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/071.png")));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("alerts.panel.mnemonic"));
        this.setShowByDefault(true);
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName("AlertPanel");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getSplitPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("AlertToolbar");
            this.panelToolbar.add(this.getScopeButton());
            this.panelToolbar.add(this.getLinkWithSitesTreeButton());
            this.panelToolbar.addSeparator();
            this.panelToolbar.add(this.getEditButton());
        }
        return this.panelToolbar;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setName("AlertPanels");
            this.splitPane.setDividerSize(3);
            this.splitPane.setDividerLocation(400);
            this.splitPane.setOrientation(1);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this.getPanelToolbar(), LayoutHelper.getGBC(0, 0, 1, 0.0));
            jPanel.add((Component)this.getPaneScroll(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
            this.splitPane.setLeftComponent(jPanel);
            this.splitPane.setRightComponent(this.getAlertViewPanel());
            this.splitPane.setPreferredSize(new Dimension(100, 200));
        }
        return this.splitPane;
    }

    public AlertViewPanel getAlertViewPanel() {
        if (this.alertViewPanel == null) {
            this.alertViewPanel = new AlertViewPanel();
        }
        return this.alertViewPanel;
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/fugue/target-grey.png")));
            this.scopeButton.setToolTipText(Constant.messages.getString("history.scope.button.unselected"));
            this.scopeButton.setSelectedIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/fugue/target.png")));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("history.scope.button.selected"));
            DisplayUtils.scaleIcon(this.scopeButton);
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AlertPanel.this.extension.setShowJustInScope(AlertPanel.this.scopeButton.isSelected());
                }
            });
            this.alertsTreeFiltersButtonGroup.add(this.scopeButton);
        }
        return this.scopeButton;
    }

    private JToggleButton getLinkWithSitesTreeButton() {
        if (this.linkWithSitesTreeButton == null) {
            this.linkWithSitesTreeButton = new ZapToggleButton();
            this.linkWithSitesTreeButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/earth-grey.png")));
            this.linkWithSitesTreeButton.setToolTipText(Constant.messages.getString("alerts.panel.linkWithSitesSelection.unselected.button.tooltip"));
            this.linkWithSitesTreeButton.setSelectedIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/094.png")));
            this.linkWithSitesTreeButton.setSelectedToolTipText(Constant.messages.getString("alerts.panel.linkWithSitesSelection.selected.button.tooltip"));
            DisplayUtils.scaleIcon(this.linkWithSitesTreeButton);
            this.linkWithSitesTreeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AlertPanel.this.setLinkWithSitesTreeSelection(AlertPanel.this.linkWithSitesTreeButton.isSelected());
                }
            });
            this.alertsTreeFiltersButtonGroup.add(this.linkWithSitesTreeButton);
        }
        return this.linkWithSitesTreeButton;
    }

    public void setLinkWithSitesTreeSelection(boolean bl) {
        this.linkWithSitesTreeButton.setSelected(bl);
        if (bl) {
            this.extension.setShowJustInScope(false);
            JTree jTree = this.view.getSiteTreePanel().getTreeSite();
            TreePath treePath = jTree.getSelectionPath();
            this.getTreeAlert().setModel(this.getLinkWithSitesTreeModel());
            if (treePath != null) {
                this.recreateLinkWithSitesTreeModel((SiteNode)treePath.getLastPathComponent());
            }
            jTree.addTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        } else {
            this.extension.setMainTreeModel();
            ((AlertNode)this.getLinkWithSitesTreeModel().getRoot()).removeAllChildren();
            this.view.getSiteTreePanel().getTreeSite().removeTreeSelectionListener(this.getLinkWithSitesTreeSelectionListener());
        }
    }

    private AlertTreeModel getLinkWithSitesTreeModel() {
        if (this.linkWithSitesTreeModel == null) {
            this.linkWithSitesTreeModel = new AlertTreeModel();
        }
        return this.linkWithSitesTreeModel;
    }

    private void recreateLinkWithSitesTreeModel(SiteNode siteNode) {
        if (siteNode == null) {
            throw new IllegalArgumentException("Parameter siteNode must not be null.");
        }
        ((AlertNode)this.getLinkWithSitesTreeModel().getRoot()).removeAllChildren();
        if (siteNode.isRoot()) {
            this.getLinkWithSitesTreeModel().reload();
            this.extension.recalcAlerts();
            return;
        }
        String string = null;
        HistoryReference historyReference = siteNode.getHistoryReference();
        if (historyReference != null) {
            string = historyReference.getURI().toString();
        }
        for (Alert alert : siteNode.getAlerts()) {
            if (string != null && !alert.getUri().equals(string)) continue;
            this.getLinkWithSitesTreeModel().addPath(alert);
        }
        this.getLinkWithSitesTreeModel().reload();
        this.expandRootChildNodes();
        this.extension.recalcAlerts();
    }

    private LinkWithSitesTreeSelectionListener getLinkWithSitesTreeSelectionListener() {
        if (this.linkWithSitesTreeSelectionListener == null) {
            this.linkWithSitesTreeSelectionListener = new LinkWithSitesTreeSelectionListener();
        }
        return this.linkWithSitesTreeSelectionListener;
    }

    JTree getTreeAlert() {
        if (this.treeAlert == null) {
            this.treeAlert = new JTree(){
                private static final long serialVersionUID = 1L;

                @Override
                public Point getPopupLocation(MouseEvent mouseEvent) {
                    TreePath treePath;
                    if (mouseEvent != null && (treePath = AlertPanel.this.treeAlert.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && !AlertPanel.this.treeAlert.getSelectionModel().isPathSelected(treePath)) {
                        AlertPanel.this.treeAlert.getSelectionModel().setSelectionPath(treePath);
                    }
                    return super.getPopupLocation(mouseEvent);
                }
            };
            this.treeAlert.setName(ALERT_TREE_PANEL_NAME);
            this.treeAlert.setShowsRootHandles(true);
            this.treeAlert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.treeAlert.setComponentPopupMenu(new JPopupMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public void show(Component component, int n, int n2) {
                    Object object;
                    int n3 = AlertPanel.this.treeAlert.getSelectionCount();
                    ArrayList<HistoryReference> arrayList = new ArrayList<HistoryReference>(n3);
                    if (n3 > 0) {
                        object = new TreeSet();
                        for (TreePath treePath : AlertPanel.this.treeAlert.getSelectionPaths()) {
                            HistoryReference historyReference;
                            AlertNode alertNode = (AlertNode)treePath.getLastPathComponent();
                            Alert alert = alertNode.getUserObject();
                            if (!(alert instanceof Alert) || (historyReference = alert.getHistoryRef()) == null || object.contains(historyReference.getHistoryId())) continue;
                            object.add(historyReference.getHistoryId());
                            arrayList.add(historyReference);
                        }
                        arrayList.trimToSize();
                    }
                    object = new DefaultSelectableHistoryReferencesContainer(AlertPanel.this.treeAlert.getName(), AlertPanel.this.treeAlert, Collections.emptyList(), arrayList);
                    AlertPanel.this.view.getPopupMenu().show((MessageContainer<?>)object, n, n2);
                }
            });
            this.treeAlert.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                        AlertPanel.this.editSelectedAlert();
                    }
                }
            });
            this.treeAlert.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AlertPanel.this.treeAlert.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() != null) {
                        Object object = defaultMutableTreeNode.getUserObject();
                        if (object instanceof Alert) {
                            Alert alert = (Alert)object;
                            AlertPanel.this.setMessage(alert.getMessage(), alert.getEvidence());
                            AlertPanel.this.treeAlert.requestFocusInWindow();
                            AlertPanel.this.getAlertViewPanel().displayAlert(alert);
                        } else {
                            AlertPanel.this.getAlertViewPanel().clearAlert();
                        }
                    } else {
                        AlertPanel.this.getAlertViewPanel().clearAlert();
                    }
                }
            });
            this.treeAlert.setCellRenderer(new AlertTreeCellRenderer());
            this.treeAlert.setExpandsSelectedPaths(true);
        }
        return this.treeAlert;
    }

    private JScrollPane getPaneScroll() {
        if (this.paneScroll == null) {
            this.paneScroll = new JScrollPane();
            this.paneScroll.setName("paneScroll");
            this.paneScroll.setViewportView(this.getTreeAlert());
        }
        return this.paneScroll;
    }

    void setView(ViewDelegate viewDelegate) {
        this.view = viewDelegate;
    }

    private ViewDelegate getView() {
        return this.view;
    }

    public void expandRoot() {
        if (EventQueue.isDispatchThread()) {
            this.getTreeAlert().expandPath(new TreePath(this.getTreeAlert().getModel().getRoot()));
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertPanel.this.expandRoot();
                }
            });
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void expandRootChildNodes() {
        TreeNode treeNode = (TreeNode)this.getTreeAlert().getModel().getRoot();
        if (treeNode == null) {
            return;
        }
        TreePath treePath = new TreePath(treeNode);
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.getTreeAlert().expandPath(treePath.pathByAddingChild(treeNode.getChildAt(i)));
        }
    }

    private void setMessage(HttpMessage httpMessage, String string) {
        this.getView().displayMessage(httpMessage);
        if (httpMessage == null) {
            return;
        }
        if (!httpMessage.getResponseHeader().isEmpty()) {
            HttpPanelRequest httpPanelRequest = this.getView().getRequestPanel();
            HttpPanelResponse httpPanelResponse = this.getView().getResponsePanel();
            SearchMatch searchMatch = null;
            if (string != null && string.length() != 0) {
                int n = httpMessage.getResponseHeader().toString().indexOf(string);
                if (n >= 0) {
                    searchMatch = new SearchMatch(httpMessage, SearchMatch.Location.RESPONSE_HEAD, n, n + string.length());
                    httpPanelResponse.highlightHeader(searchMatch);
                    httpPanelResponse.setTabFocus();
                } else {
                    n = httpMessage.getResponseBody().toString().indexOf(string);
                    if (n >= 0) {
                        searchMatch = new SearchMatch(httpMessage, SearchMatch.Location.RESPONSE_BODY, n, n + string.length());
                        httpPanelResponse.highlightBody(searchMatch);
                        httpPanelResponse.setTabFocus();
                    } else {
                        n = httpMessage.getRequestHeader().toString().indexOf(string);
                        if (n >= 0) {
                            searchMatch = new SearchMatch(httpMessage, SearchMatch.Location.REQUEST_HEAD, n, n + string.length());
                            httpPanelRequest.highlightHeader(searchMatch);
                            httpPanelRequest.setTabFocus();
                        } else {
                            n = httpMessage.getRequestBody().toString().indexOf(string);
                            if (n >= 0) {
                                searchMatch = new SearchMatch(httpMessage, SearchMatch.Location.REQUEST_BODY, n, n + string.length());
                                httpPanelRequest.highlightBody(searchMatch);
                                httpPanelRequest.setTabFocus();
                            }
                        }
                    }
                }
            }
        }
    }

    private void editSelectedAlert() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeAlert.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() != null && (object = defaultMutableTreeNode.getUserObject()) instanceof Alert) {
            Alert alert = (Alert)object;
            if (this.extHist == null) {
                this.extHist = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
            }
            if (this.extHist != null) {
                this.extHist.showAlertAddDialog(alert);
            }
        }
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setToolTipText(Constant.messages.getString("alert.edit.button.tooltip"));
            this.editButton.setIcon(new ImageIcon(AlertPanel.class.getResource("/resource/icon/16/018.png")));
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AlertPanel.this.editSelectedAlert();
                }
            });
        }
        return this.editButton;
    }

    private class LinkWithSitesTreeSelectionListener
    implements TreeSelectionListener {
        private LinkWithSitesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            AlertPanel.this.recreateLinkWithSitesTreeModel((SiteNode)treeSelectionEvent.getPath().getLastPathComponent());
        }
    }
}

