/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.ascan.CategoryTableModel;
import org.zaproxy.zap.utils.DisplayUtils;

public class PolicyCategoryPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JTable tableTest = null;
    private JScrollPane jScrollPane = null;
    private CategoryTableModel categoryTableModel = null;
    private static final int[] width = new int[]{300, 100, 100, 200};
    private int category;

    public PolicyCategoryPanel(int n, PluginFactory pluginFactory, Plugin.AlertThreshold alertThreshold) {
        this.category = n;
        this.initialize();
        this.getCategoryTableModel().setTable(n, pluginFactory, alertThreshold);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setSize(375, 204);
        this.setName("categoryPanel");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
    }

    private JTable getTableTest() {
        if (this.tableTest == null) {
            Object object;
            this.tableTest = new JTable();
            this.tableTest.setModel(this.getCategoryTableModel());
            this.tableTest.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableTest.setIntercellSpacing(new Dimension(1, 1));
            this.tableTest.setAutoCreateRowSorter(true);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(1);
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            this.tableTest.getRowSorter().setSortKeys(arrayList);
            for (int i = 0; i < this.tableTest.getColumnCount() - 1; ++i) {
                object = this.tableTest.getColumnModel().getColumn(i);
                ((TableColumn)object).setPreferredWidth(width[i]);
            }
            JComboBox<String> jComboBox = new JComboBox<String>();
            for (Plugin.AlertThreshold alertThreshold : Plugin.AlertThreshold.values()) {
                jComboBox.addItem(Constant.messages.getString("ascan.policy.level." + alertThreshold.name().toLowerCase()));
            }
            this.tableTest.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
            object = new JComboBox();
            for (Plugin.AttackStrength attackStrength : Plugin.AttackStrength.values()) {
                ((JComboBox)object).addItem(Constant.messages.getString("ascan.policy.level." + attackStrength.name().toLowerCase()));
            }
            this.tableTest.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor((JComboBox<?>)object));
        }
        return this.tableTest;
    }

    @Override
    public void initParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableTest());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private CategoryTableModel getCategoryTableModel() {
        if (this.categoryTableModel == null) {
            this.categoryTableModel = new CategoryTableModel();
        }
        return this.categoryTableModel;
    }

    public void setPluginFactory(PluginFactory pluginFactory, Plugin.AlertThreshold alertThreshold) {
        this.getCategoryTableModel().setTable(this.category, pluginFactory, alertThreshold);
        this.modelChanged();
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.scanpolicy";
    }

    public void modelChanged() {
        this.getCategoryTableModel().fireTableDataChanged();
    }
}

