/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.layout.region.BorderStyle;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.StrokeBorder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.scene.paint.Paint;

public final class StrokeBorderConverter
extends StyleConverter<ParsedValue[], List<StrokeBorder>> {
    public static StrokeBorderConverter getInstance() {
        return Holder.STROKE_BORDER_CONVERTER;
    }

    private StrokeBorderConverter() {
    }

    @Override
    public List<StrokeBorder> convert(Map<StyleableProperty, Object> map) {
        Object object;
        int n;
        Paint[][] paintArray = null;
        BorderStyle[][] borderStyleArray = null;
        Margins[] marginsArray = null;
        Margins[] marginsArray2 = null;
        Insets[] insetsArray = null;
        List<StyleableProperty> list = StrokeBorder.impl_CSS_STYLEABLES();
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            Object object2 = map.get(object);
            if (object2 == null) continue;
            if ("-fx-border-color".equals(((StyleableProperty)object).getProperty())) {
                paintArray = (Paint[][])object2;
                continue;
            }
            if ("-fx-border-style".equals(((StyleableProperty)object).getProperty())) {
                borderStyleArray = (BorderStyle[][])object2;
                continue;
            }
            if ("-fx-border-width".equals(((StyleableProperty)object).getProperty())) {
                marginsArray = (Margins[])object2;
                continue;
            }
            if ("-fx-border-radius".equals(((StyleableProperty)object).getProperty())) {
                marginsArray2 = (Margins[])object2;
                continue;
            }
            if (!"-fx-border-insets".equals(((StyleableProperty)object).getProperty())) continue;
            insetsArray = (Insets[])object2;
        }
        n = paintArray != null ? paintArray.length : 0;
        object = new ArrayList();
        for (int i = 0; i < n; ++i) {
            BorderStyle[] borderStyleArray2 = borderStyleArray != null ? borderStyleArray[Math.min(i, borderStyleArray.length - 1)] : null;
            Margins margins = marginsArray != null ? marginsArray[Math.min(i, marginsArray.length - 1)] : null;
            Margins margins2 = marginsArray2 != null ? marginsArray2[Math.min(i, marginsArray2.length - 1)] : null;
            Insets insets = insetsArray != null ? insetsArray[Math.min(i, insetsArray.length - 1)] : null;
            StrokeBorder.Builder builder = new StrokeBorder.Builder();
            builder.setTopFill(paintArray[i][0]).setRightFill(paintArray[i][1]).setBottomFill(paintArray[i][2]).setLeftFill(paintArray[i][3]);
            if (margins != null) {
                builder.setTopWidth(margins.getTop()).setRightWidth(margins.getRight()).setBottomWidth(margins.getBottom()).setLeftWidth(margins.getLeft()).setProportionalWidth(margins.isProportional());
            }
            if (margins2 != null) {
                builder.setTopLeftCornerRadius(margins2.getTop()).setTopRightCornerRadius(margins2.getRight()).setBottomRightCornerRadius(margins2.getBottom()).setBottomLeftCornerRadius(margins2.getLeft()).setProportionalWidth(margins2.isProportional());
            }
            if (insets != null) {
                builder.setOffsets(insets);
            }
            if (borderStyleArray2 != null) {
                builder.setTopStyle(borderStyleArray2[0]).setRightStyle(borderStyleArray2[1]).setBottomStyle(borderStyleArray2[2]).setLeftStyle(borderStyleArray2[3]);
            }
            object.add(builder.build());
        }
        return object;
    }

    public String toString() {
        return "StrokeBorderType";
    }

    private static class Holder {
        private static final StrokeBorderConverter STROKE_BORDER_CONVERTER = new StrokeBorderConverter();

        private Holder() {
        }
    }
}

