/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.StringTokenizer;
import joptsimple.ArgumentList;
import joptsimple.OptionArgumentConversionException;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.internal.Reflection;
import joptsimple.internal.ReflectionException;
import joptsimple.internal.Strings;

public abstract class ArgumentAcceptingOptionSpec
extends OptionSpec {
    private static final char NIL_VALUE_SEPARATOR = '\u0000';
    private final boolean argumentRequired;
    private Member converter;
    private String argumentDescription = "";
    private String valueSeparator = String.valueOf('\u0000');
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    ArgumentAcceptingOptionSpec(String option, boolean argumentRequired) {
        super(option);
        this.argumentRequired = argumentRequired;
    }

    ArgumentAcceptingOptionSpec(List options, boolean argumentRequired, String description) {
        super(options, description);
        this.argumentRequired = argumentRequired;
    }

    public ArgumentAcceptingOptionSpec ofType(Class argumentType) {
        this.converter = Reflection.findConverter(argumentType);
        return this;
    }

    public final ArgumentAcceptingOptionSpec describedAs(String description) {
        this.argumentDescription = description;
        return this;
    }

    public final ArgumentAcceptingOptionSpec withValuesSeparatedBy(char separator) {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("cannot use U+0000 as separator");
        }
        this.valueSeparator = String.valueOf(separator);
        return this;
    }

    final void handleOption(OptionParser parser, ArgumentList arguments, OptionSet detectedOptions, String detectedArgument) {
        if (Strings.isNullOrEmpty(detectedArgument)) {
            this.detectOptionArgument(parser, arguments, detectedOptions);
        } else {
            this.addArguments(detectedOptions, detectedArgument);
        }
    }

    protected void addArguments(OptionSet detectedOptions, String detectedArgument) {
        StringTokenizer lexer = new StringTokenizer(detectedArgument, this.valueSeparator);
        while (lexer.hasMoreTokens()) {
            detectedOptions.addAllWithArgument(this.options(), this.convert(lexer.nextToken()));
        }
    }

    protected abstract void detectOptionArgument(OptionParser var1, ArgumentList var2, OptionSet var3);

    protected final Object convert(String argument) {
        if (this.converter == null) {
            return argument;
        }
        Object[] args = new Object[]{argument};
        try {
            if (this.converter instanceof Constructor) {
                return Reflection.instantiate((Constructor)this.converter, args);
            }
            return Reflection.invoke((Method)this.converter, args);
        }
        catch (ReflectionException ignored) {
            throw new OptionArgumentConversionException(this.options(), argument, this.converter.getDeclaringClass());
        }
    }

    protected boolean canConvertArgument(String argument) {
        StringTokenizer lexer = new StringTokenizer(argument, this.valueSeparator);
        try {
            while (lexer.hasMoreTokens()) {
                this.convert(lexer.nextToken());
            }
            return true;
        }
        catch (OptionException ignored) {
            return false;
        }
    }

    protected boolean isArgumentOfNumberType() {
        return this.converter != null && (class$java$lang$Number == null ? (class$java$lang$Number = ArgumentAcceptingOptionSpec.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.converter.getDeclaringClass());
    }

    boolean acceptsArguments() {
        return true;
    }

    boolean requiresArgument() {
        return this.argumentRequired;
    }

    String argumentDescription() {
        return this.argumentDescription;
    }

    Class argumentType() {
        Class clazz = this.converter == null ? (class$java$lang$String == null ? (class$java$lang$String = ArgumentAcceptingOptionSpec.class$("java.lang.String")) : class$java$lang$String) : this.converter.getDeclaringClass();
        return clazz;
    }

    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        ArgumentAcceptingOptionSpec other = (ArgumentAcceptingOptionSpec)that;
        return this.requiresArgument() == other.requiresArgument();
    }

    public int hashCode() {
        return super.hashCode() ^ (this.argumentRequired ? 0 : 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

