/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.function.LongSupplier;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptSettings;

public class QueryRewriteContext {
    protected final MapperService mapperService;
    protected final ScriptService scriptService;
    protected final IndexSettings indexSettings;
    private final NamedXContentRegistry xContentRegistry;
    protected final Client client;
    protected final IndexReader reader;
    protected final LongSupplier nowInMillis;

    public QueryRewriteContext(IndexSettings indexSettings, MapperService mapperService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Client client, IndexReader reader, LongSupplier nowInMillis) {
        this.mapperService = mapperService;
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.reader = reader;
        this.nowInMillis = nowInMillis;
    }

    public Client getClient() {
        return this.client;
    }

    public final IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public final MapperService getMapperService() {
        return this.mapperService;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public QueryParseContext newParseContext(XContentParser parser) {
        return new QueryParseContext(parser);
    }

    public QueryParseContext newParseContextWithLegacyScriptLanguage(XContentParser parser) {
        String defaultScriptLanguage = ScriptSettings.getLegacyDefaultLang(this.indexSettings.getNodeSettings());
        return new QueryParseContext(defaultScriptLanguage, parser);
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public BytesReference getTemplateBytes(Script template) {
        ExecutableScript executable = this.scriptService.executable(template, ScriptContext.Standard.SEARCH);
        return (BytesReference)executable.run();
    }
}

