/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.AbstractRandomAccessOrds;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class GlobalOrdinalsStringTermsAggregator
extends AbstractStringTermsAggregator {
    protected final ValuesSource.Bytes.WithOrdinals valuesSource;
    protected final IncludeExclude.OrdinalsFilter includeExclude;
    protected LongBitSet acceptedGlobalOrdinals;
    protected RandomAccessOrds globalOrds;

    public GlobalOrdinalsStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals valuesSource, Terms.Order order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.OrdinalsFilter includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        this.globalOrds = this.valuesSource.globalOrdinalsValues(ctx);
        if (this.acceptedGlobalOrdinals == null && this.includeExclude != null) {
            this.acceptedGlobalOrdinals = this.includeExclude.acceptedGlobalOrdinals(this.globalOrds);
        }
        if (this.acceptedGlobalOrdinals != null) {
            this.globalOrds = new FilteredOrdinals(this.globalOrds, this.acceptedGlobalOrdinals);
        }
        return this.newCollector(this.globalOrds, sub);
    }

    protected LeafBucketCollector newCollector(final RandomAccessOrds ords, final LeafBucketCollector sub) {
        this.grow(ords.getValueCount());
        final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)ords);
        if (singleValues != null) {
            return new LeafBucketCollectorBase(sub, ords){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    assert (bucket == 0L);
                    int ord = singleValues.getOrd(doc);
                    if (ord >= 0) {
                        GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(sub, doc, ord);
                    }
                }
            };
        }
        return new LeafBucketCollectorBase(sub, ords){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                ords.setDocument(doc);
                int numOrds = ords.cardinality();
                for (int i = 0; i < numOrds; ++i) {
                    long globalOrd = ords.ordAt(i);
                    GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(sub, doc, globalOrd);
                }
            }
        };
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        InternalTerms.Bucket bucket;
        int i;
        if (this.globalOrds == null) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.globalOrds.getValueCount(), (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue<Terms.Bucket> ordered = new BucketPriorityQueue<Terms.Bucket>(size, this.order.comparator(this));
        OrdBucket spare = new OrdBucket(-1L, 0L, null, this.showTermDocCountError, 0L);
        for (long globalTermOrd = 0L; globalTermOrd < this.globalOrds.getValueCount(); ++globalTermOrd) {
            int bucketDocCount;
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalTermOrd)) continue;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            int n = bucketDocCount = bucketOrd < 0L ? 0 : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0) continue;
            otherDocCount += (long)bucketDocCount;
            spare.globalOrd = globalTermOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount || (spare = (OrdBucket)ordered.insertWithOverflow(spare)) != null) continue;
            spare = new OrdBucket(-1L, 0L, null, this.showTermDocCountError, 0L);
        }
        StringTerms.Bucket[] list = new StringTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            bucket = (OrdBucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            BytesRef scratch = new BytesRef();
            GlobalOrdinalsStringTermsAggregator.copy(this.globalOrds.lookupOrd(bucket.globalOrd), scratch);
            list[i] = new StringTerms.Bucket(scratch, bucket.docCount, null, this.showTermDocCountError, 0L, this.format);
            list[i].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[i].docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            bucket = list[i];
            ((StringTerms.Bucket)bucket).aggregations = ((StringTerms.Bucket)bucket).docCount == 0L ? this.bucketEmptyAggregations() : this.bucketAggregations(((StringTerms.Bucket)bucket).bucketOrd);
            ((StringTerms.Bucket)bucket).docCountError = 0L;
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(list), 0L);
    }

    private static final class FilteredOrdinals
    extends AbstractRandomAccessOrds {
        private final RandomAccessOrds inner;
        private final LongBitSet accepted;
        private int cardinality;
        private long[] ords = new long[0];

        private FilteredOrdinals(RandomAccessOrds inner, LongBitSet accepted) {
            this.inner = inner;
            this.accepted = accepted;
        }

        public long getValueCount() {
            return this.inner.getValueCount();
        }

        public long ordAt(int index) {
            return this.ords[index];
        }

        @Override
        public void doSetDocument(int docId) {
            this.inner.setDocument(docId);
            int innerCardinality = this.inner.cardinality();
            this.ords = ArrayUtil.grow((long[])this.ords, (int)innerCardinality);
            this.cardinality = 0;
            for (int slot = 0; slot < innerCardinality; ++slot) {
                long ord = this.inner.ordAt(slot);
                if (!this.accepted.get(ord)) continue;
                this.ords[this.cardinality++] = ord;
            }
        }

        public int cardinality() {
            return this.cardinality;
        }

        public BytesRef lookupOrd(long ord) {
            return this.inner.lookupOrd(ord);
        }
    }

    public static class LowCardinality
    extends GlobalOrdinalsStringTermsAggregator {
        private IntArray segmentDocCounts;
        private RandomAccessOrds segmentOrds;

        public LowCardinality(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals valuesSource, Terms.Order order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, factories, valuesSource, order, format, bucketCountThresholds, null, context, parent, collectionMode, showTermDocCountError, pipelineAggregators, metaData);
            assert (factories == null || factories.countAggregators() == 0);
            this.segmentDocCounts = context.bigArrays().newIntArray(1L, true);
        }

        @Override
        protected LeafBucketCollector newCollector(final RandomAccessOrds ords, LeafBucketCollector sub) {
            this.segmentDocCounts = this.context.bigArrays().grow(this.segmentDocCounts, 1L + ords.getValueCount());
            assert (sub == LeafBucketCollector.NO_OP_COLLECTOR);
            final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)ords);
            if (singleValues != null) {
                return new LeafBucketCollectorBase(sub, ords){

                    @Override
                    public void collect(int doc, long bucket) throws IOException {
                        assert (bucket == 0L);
                        int ord = singleValues.getOrd(doc);
                        segmentDocCounts.increment(ord + 1, 1);
                    }
                };
            }
            return new LeafBucketCollectorBase(sub, ords){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    assert (bucket == 0L);
                    ords.setDocument(doc);
                    int numOrds = ords.cardinality();
                    for (int i = 0; i < numOrds; ++i) {
                        long segmentOrd = ords.ordAt(i);
                        segmentDocCounts.increment(segmentOrd + 1L, 1);
                    }
                }
            };
        }

        @Override
        public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
            if (this.segmentOrds != null) {
                this.mapSegmentCountsToGlobalCounts();
            }
            this.globalOrds = this.valuesSource.globalOrdinalsValues(ctx);
            this.segmentOrds = this.valuesSource.ordinalsValues(ctx);
            return this.newCollector(this.segmentOrds, sub);
        }

        @Override
        protected void doPostCollection() {
            if (this.segmentOrds != null) {
                this.mapSegmentCountsToGlobalCounts();
            }
        }

        @Override
        protected void doClose() {
            Releasables.close(this.segmentDocCounts);
        }

        private void mapSegmentCountsToGlobalCounts() {
            GlobalOrdinalMapping mapping = this.globalOrds.getValueCount() == this.segmentOrds.getValueCount() ? null : (GlobalOrdinalMapping)this.globalOrds;
            for (long i = 1L; i < this.segmentDocCounts.size(); ++i) {
                int inc = this.segmentDocCounts.set(i, 0);
                if (inc == 0) continue;
                long ord = i - 1L;
                long globalOrd = mapping == null ? ord : mapping.getGlobalOrd(ord);
                this.incrementBucketDocCount(globalOrd, inc);
            }
        }
    }

    public static class WithHash
    extends GlobalOrdinalsStringTermsAggregator {
        private final LongHash bucketOrds;

        public WithHash(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals valuesSource, Terms.Order order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.OrdinalsFilter includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, factories, valuesSource, order, format, bucketCountThresholds, includeExclude, context, parent, collectionMode, showTermDocCountError, pipelineAggregators, metaData);
            this.bucketOrds = new LongHash(1L, context.bigArrays());
        }

        @Override
        protected LeafBucketCollector newCollector(final RandomAccessOrds ords, final LeafBucketCollector sub) {
            final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)ords);
            if (singleValues != null) {
                return new LeafBucketCollectorBase(sub, ords){

                    @Override
                    public void collect(int doc, long bucket) throws IOException {
                        int globalOrd = singleValues.getOrd(doc);
                        if (globalOrd >= 0) {
                            long bucketOrd = bucketOrds.add(globalOrd);
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                this.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                    }
                };
            }
            return new LeafBucketCollectorBase(sub, ords){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    ords.setDocument(doc);
                    int numOrds = ords.cardinality();
                    for (int i = 0; i < numOrds; ++i) {
                        long globalOrd = ords.ordAt(i);
                        long bucketOrd = bucketOrds.add(globalOrd);
                        if (bucketOrd < 0L) {
                            bucketOrd = -1L - bucketOrd;
                            this.collectExistingBucket(sub, doc, bucketOrd);
                            continue;
                        }
                        this.collectBucket(sub, doc, bucketOrd);
                    }
                }
            };
        }

        @Override
        protected long getBucketOrd(long termOrd) {
            return this.bucketOrds.find(termOrd);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.bucketOrds);
        }
    }

    static class OrdBucket
    extends InternalTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError) {
            super(docCount, aggregations, showDocCountError, docCountError, null);
            this.globalOrd = globalOrd;
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return Long.compare(this.globalOrd, ((OrdBucket)other).globalOrd);
        }

        @Override
        public String getKeyAsString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        OrdBucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number getKeyAsNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

