/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;

public final class SnapshotInfo
implements Comparable<SnapshotInfo>,
ToXContent,
Writeable {
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = "SNAPSHOT";
    private static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("strictDateOptionalTime");
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INDICES = "indices";
    private static final String STATE = "state";
    private static final String REASON = "reason";
    private static final String START_TIME = "start_time";
    private static final String START_TIME_IN_MILLIS = "start_time_in_millis";
    private static final String END_TIME = "end_time";
    private static final String END_TIME_IN_MILLIS = "end_time_in_millis";
    private static final String DURATION = "duration";
    private static final String DURATION_IN_MILLIS = "duration_in_millis";
    private static final String FAILURES = "failures";
    private static final String SHARDS = "shards";
    private static final String TOTAL = "total";
    private static final String FAILED = "failed";
    private static final String SUCCESSFUL = "successful";
    private static final String VERSION_ID = "version_id";
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String TOTAL_SHARDS = "total_shards";
    private static final String SUCCESSFUL_SHARDS = "successful_shards";
    private static final Version VERSION_INCOMPATIBLE_INTRODUCED = Version.V_5_2_0;
    private final SnapshotId snapshotId;
    private final SnapshotState state;
    private final String reason;
    private final List<String> indices;
    private final long startTime;
    private final long endTime;
    private final int totalShards;
    private final int successfulShards;
    @Nullable
    private final Version version;
    private final List<SnapshotShardFailure> shardFailures;

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, long startTime) {
        this(snapshotId, indices, SnapshotState.IN_PROGRESS, null, Version.CURRENT, startTime, 0L, 0, 0, Collections.emptyList());
    }

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, long startTime, String reason, long endTime, int totalShards, List<SnapshotShardFailure> shardFailures) {
        this(snapshotId, indices, SnapshotInfo.snapshotState(reason, shardFailures), reason, Version.CURRENT, startTime, endTime, totalShards, totalShards - shardFailures.size(), shardFailures);
    }

    private SnapshotInfo(SnapshotId snapshotId, List<String> indices, SnapshotState state, String reason, Version version, long startTime, long endTime, int totalShards, int successfulShards, List<SnapshotShardFailure> shardFailures) {
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indices = Objects.requireNonNull(indices);
        this.state = Objects.requireNonNull(state);
        this.reason = reason;
        this.version = version;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.shardFailures = Objects.requireNonNull(shardFailures);
    }

    public SnapshotInfo(StreamInput in) throws IOException {
        this.snapshotId = new SnapshotId(in);
        int size = in.readVInt();
        ArrayList<String> indicesListBuilder = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            indicesListBuilder.add(in.readString());
        }
        this.indices = Collections.unmodifiableList(indicesListBuilder);
        this.state = SnapshotState.fromValue(in.readByte());
        this.reason = in.readOptionalString();
        this.startTime = in.readVLong();
        this.endTime = in.readVLong();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        size = in.readVInt();
        if (size > 0) {
            ArrayList<SnapshotShardFailure> failureBuilder = new ArrayList<SnapshotShardFailure>();
            for (int i = 0; i < size; ++i) {
                failureBuilder.add(SnapshotShardFailure.readSnapshotShardFailure(in));
            }
            this.shardFailures = Collections.unmodifiableList(failureBuilder);
        } else {
            this.shardFailures = Collections.emptyList();
        }
        this.version = in.getVersion().before(VERSION_INCOMPATIBLE_INTRODUCED) ? Version.readVersion(in) : (in.readBoolean() ? Version.readVersion(in) : null);
    }

    public static SnapshotInfo incompatible(SnapshotId snapshotId) {
        return new SnapshotInfo(snapshotId, Collections.emptyList(), SnapshotState.INCOMPATIBLE, "the snapshot is incompatible with the current version of Elasticsearch and its exact version is unknown", null, 0L, 0L, 0, 0, Collections.emptyList());
    }

    public SnapshotId snapshotId() {
        return this.snapshotId;
    }

    public SnapshotState state() {
        return this.state;
    }

    public String reason() {
        return this.reason;
    }

    public List<String> indices() {
        return this.indices;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public List<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    @Nullable
    public Version version() {
        return this.version;
    }

    @Override
    public int compareTo(SnapshotInfo o) {
        return Long.compare(this.startTime, o.startTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo that = (SnapshotInfo)o;
        return this.startTime == that.startTime && this.snapshotId.equals(that.snapshotId);
    }

    public int hashCode() {
        int result = this.snapshotId.hashCode();
        result = 31 * result + Long.hashCode(this.startTime);
        return result;
    }

    public String toString() {
        return "SnapshotInfo[snapshotId=" + this.snapshotId + ", state=" + (Object)((Object)this.state) + ", indices=" + this.indices + "]";
    }

    public RestStatus status() {
        if (this.state == SnapshotState.FAILED) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.shardFailures.size() == 0) {
            return RestStatus.OK;
        }
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures.toArray(new ShardOperationFailedException[this.shardFailures.size()]));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (CONTEXT_MODE_SNAPSHOT.equals(params.param(CONTEXT_MODE_PARAM))) {
            return this.toXContentSnapshot(builder, params);
        }
        builder.startObject();
        builder.field(SNAPSHOT, this.snapshotId.getName());
        builder.field(UUID, this.snapshotId.getUUID());
        if (this.version != null) {
            builder.field(VERSION_ID, this.version.id);
            builder.field(VERSION, this.version.toString());
        } else {
            builder.field(VERSION, "unknown");
        }
        builder.startArray(INDICES);
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.field(STATE, (Object)this.state);
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        if (this.startTime != 0L) {
            builder.field(START_TIME, DATE_TIME_FORMATTER.printer().print(this.startTime));
            builder.field(START_TIME_IN_MILLIS, this.startTime);
        }
        if (this.endTime != 0L) {
            builder.field(END_TIME, DATE_TIME_FORMATTER.printer().print(this.endTime));
            builder.field(END_TIME_IN_MILLIS, this.endTime);
            builder.timeValueField(DURATION_IN_MILLIS, DURATION, this.endTime - this.startTime);
        }
        builder.startArray(FAILURES);
        for (SnapshotShardFailure shardFailure : this.shardFailures) {
            builder.startObject();
            shardFailure.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.startObject(SHARDS);
        builder.field(TOTAL, this.totalShards);
        builder.field(FAILED, this.failedShards());
        builder.field(SUCCESSFUL, this.successfulShards);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private XContentBuilder toXContentSnapshot(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SNAPSHOT);
        builder.field(NAME, this.snapshotId.getName());
        builder.field(UUID, this.snapshotId.getUUID());
        assert (this.version != null) : "version must always be known when writing a snapshot metadata blob";
        builder.field(VERSION_ID, this.version.id);
        builder.startArray(INDICES);
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.field(STATE, (Object)this.state);
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        builder.field(START_TIME, this.startTime);
        builder.field(END_TIME, this.endTime);
        builder.field(TOTAL_SHARDS, this.totalShards);
        builder.field(SUCCESSFUL_SHARDS, this.successfulShards);
        builder.startArray(FAILURES);
        for (SnapshotShardFailure shardFailure : this.shardFailures) {
            builder.startObject();
            shardFailure.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SnapshotInfo fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String name = null;
        String uuid = null;
        Version version = Version.CURRENT;
        SnapshotState state = SnapshotState.IN_PROGRESS;
        String reason = null;
        List<String> indices = Collections.emptyList();
        long startTime = 0L;
        long endTime = 0L;
        int totalShards = 0;
        int successfulShards = 0;
        List<SnapshotShardFailure> shardFailures = Collections.emptyList();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        if ((token = parser.nextToken()) == XContentParser.Token.START_OBJECT) {
            String currentFieldName = parser.currentName();
            if (SNAPSHOT.equals(currentFieldName)) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if (NAME.equals(currentFieldName)) {
                            name = parser.text();
                            continue;
                        }
                        if (UUID.equals(currentFieldName)) {
                            uuid = parser.text();
                            continue;
                        }
                        if (STATE.equals(currentFieldName)) {
                            state = SnapshotState.valueOf(parser.text());
                            continue;
                        }
                        if (REASON.equals(currentFieldName)) {
                            reason = parser.text();
                            continue;
                        }
                        if (START_TIME.equals(currentFieldName)) {
                            startTime = parser.longValue();
                            continue;
                        }
                        if (END_TIME.equals(currentFieldName)) {
                            endTime = parser.longValue();
                            continue;
                        }
                        if (TOTAL_SHARDS.equals(currentFieldName)) {
                            totalShards = parser.intValue();
                            continue;
                        }
                        if (SUCCESSFUL_SHARDS.equals(currentFieldName)) {
                            successfulShards = parser.intValue();
                            continue;
                        }
                        if (!VERSION_ID.equals(currentFieldName)) continue;
                        version = Version.fromId(parser.intValue());
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (INDICES.equals(currentFieldName)) {
                            ArrayList<String> indicesArray = new ArrayList<String>();
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                indicesArray.add(parser.text());
                            }
                            indices = Collections.unmodifiableList(indicesArray);
                            continue;
                        }
                        if (FAILURES.equals(currentFieldName)) {
                            ArrayList<SnapshotShardFailure> shardFailureArrayList = new ArrayList<SnapshotShardFailure>();
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                shardFailureArrayList.add(SnapshotShardFailure.fromXContent(parser));
                            }
                            shardFailures = Collections.unmodifiableList(shardFailureArrayList);
                            continue;
                        }
                        parser.skipChildren();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT) continue;
                    parser.skipChildren();
                }
            }
        } else {
            throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]", new Object[0]);
        }
        if (uuid == null) {
            uuid = name;
        }
        return new SnapshotInfo(new SnapshotId(name, uuid), indices, state, reason, version, startTime, endTime, totalShards, successfulShards, shardFailures);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshotId.writeTo(out);
        out.writeVInt(this.indices.size());
        for (String index : this.indices) {
            out.writeString(index);
        }
        if (out.getVersion().before(VERSION_INCOMPATIBLE_INTRODUCED) && this.state == SnapshotState.INCOMPATIBLE) {
            out.writeByte(SnapshotState.FAILED.value());
        } else {
            out.writeByte(this.state.value());
        }
        out.writeOptionalString(this.reason);
        out.writeVLong(this.startTime);
        out.writeVLong(this.endTime);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.size());
        for (SnapshotShardFailure failure : this.shardFailures) {
            failure.writeTo(out);
        }
        if (out.getVersion().before(VERSION_INCOMPATIBLE_INTRODUCED)) {
            Version versionToWrite = this.version;
            if (versionToWrite == null) {
                versionToWrite = Version.CURRENT;
            }
            Version.writeVersion(versionToWrite, out);
        } else if (this.version != null) {
            out.writeBoolean(true);
            Version.writeVersion(this.version, out);
        } else {
            out.writeBoolean(false);
        }
    }

    private static SnapshotState snapshotState(String reason, List<SnapshotShardFailure> shardFailures) {
        if (reason == null) {
            if (shardFailures.isEmpty()) {
                return SnapshotState.SUCCESS;
            }
            return SnapshotState.PARTIAL;
        }
        return SnapshotState.FAILED;
    }
}

