/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginFactory;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipCachedTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipCachedTaskExecuter.class);
    private final BuildCacheService buildCache;
    private final TaskOutputPacker packer;
    private final TaskExecuter delegate;
    private final TaskOutputsGenerationListener taskOutputsGenerationListener;
    private final TaskOutputOriginFactory taskOutputOriginFactory;

    public SkipCachedTaskExecuter(TaskOutputOriginFactory taskOutputOriginFactory, BuildCacheService buildCache, TaskOutputPacker packer, TaskOutputsGenerationListener taskOutputsGenerationListener, TaskExecuter delegate) {
        this.taskOutputOriginFactory = taskOutputOriginFactory;
        this.buildCache = buildCache;
        this.packer = packer;
        this.taskOutputsGenerationListener = taskOutputsGenerationListener;
        this.delegate = delegate;
    }

    public void execute(final TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        final Timer clock = Timers.startTimer();
        LOGGER.debug("Determining if {} is cached already", (Object)task);
        final TaskOutputsInternal taskOutputs = task.getOutputs();
        TaskOutputCachingBuildCacheKey cacheKey = context.getBuildCacheKey();
        boolean taskOutputCachingEnabled = state.getTaskOutputCaching().isEnabled();
        if (taskOutputCachingEnabled) {
            if (cacheKey.isValid()) {
                TaskArtifactState taskState = context.getTaskArtifactState();
                if (taskState.isAllowedToUseCachedResults()) {
                    boolean found = this.buildCache.load(cacheKey, new BuildCacheEntryReader(){

                        public void readFrom(InputStream input) {
                            SkipCachedTaskExecuter.this.taskOutputsGenerationListener.beforeTaskOutputsGenerated();
                            SkipCachedTaskExecuter.this.packer.unpack(taskOutputs, input, SkipCachedTaskExecuter.this.taskOutputOriginFactory.createReader(task));
                            LOGGER.info("Unpacked output for {} from cache (took {}).", (Object)task, (Object)clock.getElapsed());
                        }
                    });
                    if (found) {
                        state.setOutcome(TaskExecutionOutcome.FROM_CACHE);
                        return;
                    }
                } else {
                    LOGGER.info("Not loading {} from cache because pulling from cache is disabled for this task", (Object)task);
                }
            } else {
                LOGGER.info("Not caching {} because no valid cache key was generated", (Object)task);
            }
        }
        this.delegate.execute(task, state, context);
        if (taskOutputCachingEnabled) {
            if (cacheKey.isValid()) {
                if (state.getFailure() == null) {
                    this.buildCache.store(cacheKey, new BuildCacheEntryWriter(){

                        public void writeTo(OutputStream output) {
                            LOGGER.info("Packing {}", (Object)task.getPath());
                            SkipCachedTaskExecuter.this.packer.pack(taskOutputs, output, SkipCachedTaskExecuter.this.taskOutputOriginFactory.createWriter(task, clock.getElapsedMillis()));
                        }
                    });
                } else {
                    LOGGER.debug("Not pushing result from {} to cache because the task failed", (Object)task);
                }
            } else {
                LOGGER.info("Not pushing results from {} to cache because no valid cache key was generated", (Object)task);
            }
        }
    }
}

