/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSharedModeCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final CacheInitializationAction initializationAction;
    private final Action<FileLock> onOpenAction;
    private final Action<FileLock> onCloseAction;
    private FileLock fileLock;

    public FixedSharedModeCrossProcessCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, FileLockManager lockManager, CacheInitializationAction initializationAction, Action<FileLock> onOpenAction, Action<FileLock> onCloseAction) {
        assert (lockOptions.getMode() == FileLockManager.LockMode.Shared);
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = lockManager;
        this.initializationAction = initializationAction;
        this.onOpenAction = onOpenAction;
        this.onCloseAction = onCloseAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.fileLock != null) {
            throw new IllegalStateException("File lock " + this.lockTarget + " is already open.");
        }
        FileLock fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName);
        try {
            boolean rebuild = this.initializationAction.requiresInitialization(fileLock);
            if (rebuild) {
                for (int tries = 0; rebuild && tries < 3; ++tries) {
                    fileLock.close();
                    fileLock = null;
                    final FileLock exclusiveLock = this.lockManager.lock(this.lockTarget, this.lockOptions.withMode(FileLockManager.LockMode.Exclusive), this.cacheDisplayName);
                    try {
                        rebuild = this.initializationAction.requiresInitialization(exclusiveLock);
                        if (rebuild) {
                            exclusiveLock.writeFile(new Runnable(){

                                public void run() {
                                    FixedSharedModeCrossProcessCacheAccess.this.initializationAction.initialize(exclusiveLock);
                                }
                            });
                        }
                    }
                    finally {
                        exclusiveLock.close();
                    }
                    fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName);
                    rebuild = this.initializationAction.requiresInitialization(fileLock);
                }
                if (rebuild) {
                    throw new CacheOpenException(String.format("Failed to initialize %s", this.cacheDisplayName));
                }
            }
            this.onOpenAction.execute((Object)fileLock);
        }
        catch (Exception e) {
            if (fileLock != null) {
                fileLock.close();
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.fileLock = fileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.fileLock != null) {
            try {
                this.onCloseAction.execute((Object)this.fileLock);
                this.fileLock.close();
            }
            finally {
                this.fileLock = null;
            }
        }
    }

    @Override
    public Runnable acquireFileLock() {
        throw this.failure();
    }

    @Override
    public <T> T withFileLock(Factory<T> factory) {
        throw this.failure();
    }

    protected UnsupportedOperationException failure() {
        return new UnsupportedOperationException("Cannot escalate a shared lock to an exclusive lock. This is not yet supported.");
    }
}

