/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.CachedJarFileStore;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.file.JarCache;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCachedClasspathTransformer
implements CachedClasspathTransformer,
Closeable {
    private final PersistentCache cache;
    private final Transformer<File, File> jarFileTransformer;

    public DefaultCachedClasspathTransformer(CacheRepository cacheRepository, JarCache jarCache, List<CachedJarFileStore> fileStores) {
        this.cache = cacheRepository.cache("jars-3").withDisplayName("jars").withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
        this.jarFileTransformer = new CachedJarFileTransformer(jarCache, this.cache, fileStores);
    }

    @Override
    public ClassPath transform(ClassPath classPath) {
        return DefaultClassPath.of((Collection)CollectionUtils.collect((List)classPath.getAsFiles(), this.jarFileTransformer));
    }

    @Override
    public Collection<URL> transform(Collection<URL> urls) {
        return CollectionUtils.collect(urls, (Transformer)new Transformer<URL, URL>(){

            public URL transform(URL url) {
                if (url.getProtocol().equals("file")) {
                    try {
                        return ((File)DefaultCachedClasspathTransformer.this.jarFileTransformer.transform((Object)new File(url.toURI()))).toURI().toURL();
                    }
                    catch (URISyntaxException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                    catch (MalformedURLException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                return url;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedJarFileTransformer
    implements Transformer<File, File> {
        private final JarCache jarCache;
        private final PersistentCache cache;
        private final List<String> prefixes;

        CachedJarFileTransformer(JarCache jarCache, PersistentCache cache, List<CachedJarFileStore> fileStores) {
            this.jarCache = jarCache;
            this.cache = cache;
            this.prefixes = new ArrayList<String>(fileStores.size() + 1);
            this.prefixes.add(cache.getBaseDir().getAbsolutePath() + File.separator);
            for (CachedJarFileStore fileStore : fileStores) {
                this.prefixes.add(fileStore.getJarFileStoreDirectory().getAbsolutePath() + File.separator);
            }
        }

        public File transform(final File original) {
            if (this.shouldUseFromCache(original)) {
                return this.cache.useCache(new Factory<File>(){

                    public File create() {
                        return CachedJarFileTransformer.this.jarCache.getCachedJar(original, (Factory<File>)Factories.constant((Object)CachedJarFileTransformer.this.cache.getBaseDir()));
                    }
                });
            }
            return original;
        }

        private boolean shouldUseFromCache(File original) {
            if (!original.isFile()) {
                return false;
            }
            for (String prefix : this.prefixes) {
                if (!original.getAbsolutePath().startsWith(prefix)) continue;
                return false;
            }
            return true;
        }
    }
}

