/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.api.Transformer;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.gradle.internal.progress.BuildOperationDetails;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.WorkerDaemon;
import org.gradle.workers.internal.WorkerDaemonAction;
import org.gradle.workers.internal.WorkerDaemonWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkerDaemonClient
implements WorkerDaemon,
Stoppable {
    private final DaemonForkOptions forkOptions;
    private final WorkerDaemonWorker workerDaemonWorker;
    private final WorkerProcess workerProcess;
    private final BuildOperationExecutor buildOperationExecutor;
    private int uses;

    public WorkerDaemonClient(DaemonForkOptions forkOptions, WorkerDaemonWorker workerDaemonWorker, WorkerProcess workerProcess, BuildOperationExecutor buildOperationExecutor) {
        this.forkOptions = forkOptions;
        this.workerDaemonWorker = workerDaemonWorker;
        this.workerProcess = workerProcess;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends WorkSpec> DefaultWorkResult execute(final WorkerDaemonAction<T> action, final T spec, BuildOperationWorkerRegistry.Operation parentWorkerOperation, BuildOperationExecutor.Operation parentBuildOperation) {
        BuildOperationWorkerRegistry.Completion workerLease = parentWorkerOperation.operationStart();
        BuildOperationDetails buildOperation = BuildOperationDetails.displayName((String)action.getDescription()).parent(parentBuildOperation).build();
        try {
            DefaultWorkResult defaultWorkResult = (DefaultWorkResult)this.buildOperationExecutor.run(buildOperation, (Transformer)new Transformer<DefaultWorkResult, BuildOperationContext>(){

                public DefaultWorkResult transform(BuildOperationContext buildOperationContext) {
                    WorkerDaemonClient.this.uses++;
                    return WorkerDaemonClient.this.workerDaemonWorker.execute(action, spec);
                }
            });
            return defaultWorkResult;
        }
        finally {
            workerLease.operationFinish();
        }
    }

    @Override
    public <T extends WorkSpec> DefaultWorkResult execute(WorkerDaemonAction<T> action, T spec) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompatibleWith(DaemonForkOptions required) {
        return this.forkOptions.isCompatibleWith(required);
    }

    JvmMemoryStatus getJvmMemoryStatus() {
        return this.workerProcess.getJvmMemoryStatus();
    }

    public void stop() {
        this.workerDaemonWorker.stop();
    }

    DaemonForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public int getUses() {
        return this.uses;
    }
}

