/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.wagon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionEventSupport;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.gradle.api.GradleException;
import org.gradle.api.publication.maven.internal.wagon.RepositoryTransportWagonAdapter;
import org.gradle.internal.resource.local.FileLocalResource;
import org.gradle.internal.resource.local.LocalResource;

public class RepositoryTransportDeployWagon
implements Wagon {
    private static final ThreadLocal<RepositoryTransportWagonAdapter> CURRENT_DELEGATE = new InheritableThreadLocal<RepositoryTransportWagonAdapter>();
    private SessionEventSupport sessionEventSupport = new SessionEventSupport();
    private TransferEventSupport transferEventSupport = new TransferEventSupport();
    private Repository mutatingRepository;

    public static void contextualize(RepositoryTransportWagonAdapter adapter) {
        CURRENT_DELEGATE.set(adapter);
    }

    public static void decontextualize() {
        CURRENT_DELEGATE.remove();
    }

    public final void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.transferEventSupport.fireTransferInitiated(this.transferEvent(resource, 0, 5));
        this.transferEventSupport.fireTransferStarted(this.transferEvent(resource, 1, 5));
        try {
            if (!destination.exists()) {
                destination.getParentFile().mkdirs();
                destination.createNewFile();
            }
            if (!this.getDelegate().getRemoteFile(destination, resourceName)) {
                throw new ResourceDoesNotExistException(String.format("Resource '%s' does not exist", resourceName));
            }
            this.transferEventSupport.fireTransferCompleted(this.transferEvent(resource, 2, 5));
        }
        catch (ResourceDoesNotExistException e) {
            this.transferEventSupport.fireTransferError(this.transferEvent(resource, (Exception)((Object)e), 5));
            throw e;
        }
        catch (Exception e) {
            this.transferEventSupport.fireTransferError(this.transferEvent(resource, e, 5));
            throw new TransferFailedException(String.format("Could not get resource '%s'", resourceName), (Throwable)e);
        }
    }

    public final void put(File file, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.transferEventSupport.fireTransferInitiated(this.transferEvent(resource, 0, 6));
        try {
            MavenTransferLoggingFileResource localResource = new MavenTransferLoggingFileResource(file, resource);
            this.getDelegate().putRemoteFile((LocalResource)localResource, resourceName);
        }
        catch (Exception e) {
            this.transferEventSupport.fireTransferError(this.transferEvent(resource, e, 6));
            throw new TransferFailedException(String.format("Could not write to resource '%s'", resourceName), (Throwable)e);
        }
        this.transferEventSupport.fireTransferCompleted(this.transferEvent(resource, 2, 6));
    }

    private RepositoryTransportWagonAdapter getDelegate() {
        return CURRENT_DELEGATE.get();
    }

    public final boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        this.throwNotImplemented("getIfNewer(String resourceName, File file, long timestamp)");
        return false;
    }

    public final boolean getIfNewer(String resourceName, File file, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.throwNotImplemented("getIfNewer(String resourceName, File file, long timestamp)");
        return false;
    }

    public final void putDirectory(File file, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.throwNotImplemented("putDirectory(File file, String resourceName)");
    }

    public final List getFileList(String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.throwNotImplemented("getFileList(String resourceName)");
        return null;
    }

    public final boolean supportsDirectoryCopy() {
        return false;
    }

    public final Repository getRepository() {
        return this.mutatingRepository;
    }

    public final void openConnection() throws ConnectionException, AuthenticationException {
    }

    public final void connect(Repository repository) throws ConnectionException, AuthenticationException {
        this.mutatingRepository = repository;
        this.sessionEventSupport.fireSessionLoggedIn(this.sessionEvent(7));
        this.sessionEventSupport.fireSessionOpened(this.sessionEvent(6));
    }

    public final void connect(Repository repository, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository);
    }

    public final void connect(Repository repository, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.connect(repository);
    }

    public final void connect(Repository repository, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository);
    }

    public final void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository);
    }

    public final void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.connect(repository);
    }

    public final void disconnect() throws ConnectionException {
        this.sessionEventSupport.fireSessionDisconnecting(this.sessionEvent(2));
        this.sessionEventSupport.fireSessionLoggedOff(this.sessionEvent(8));
        this.sessionEventSupport.fireSessionDisconnected(this.sessionEvent(8));
    }

    public final void addSessionListener(SessionListener sessionListener) {
        this.sessionEventSupport.addSessionListener(sessionListener);
    }

    public final void removeSessionListener(SessionListener sessionListener) {
        this.sessionEventSupport.removeSessionListener(sessionListener);
    }

    public final boolean hasSessionListener(SessionListener sessionListener) {
        return this.sessionEventSupport.hasSessionListener(sessionListener);
    }

    public final void addTransferListener(TransferListener transferListener) {
        this.transferEventSupport.addTransferListener(transferListener);
    }

    public final void removeTransferListener(TransferListener transferListener) {
        this.transferEventSupport.removeTransferListener(transferListener);
    }

    public final boolean hasTransferListener(TransferListener transferListener) {
        return this.transferEventSupport.hasTransferListener(transferListener);
    }

    public final boolean isInteractive() {
        return false;
    }

    public final void setInteractive(boolean b) {
    }

    public final void setTimeout(int i) {
    }

    public final int getTimeout() {
        return 0;
    }

    public final void setReadTimeout(int i) {
    }

    public final int getReadTimeout() {
        return 0;
    }

    private SessionEvent sessionEvent(int e) {
        return new SessionEvent((Wagon)this, e);
    }

    private void throwNotImplemented(String s) {
        throw new GradleException("This wagon does not yet support the method:" + s);
    }

    private TransferEvent transferEvent(Resource resource, int eventType, int requestType) {
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, eventType, requestType);
        transferEvent.setTimestamp(new Date().getTime());
        return transferEvent;
    }

    private TransferEvent transferEvent(Resource resource, Exception e, int requestType) {
        return new TransferEvent((Wagon)this, resource, e, requestType);
    }

    private class MavenTransferLoggingFileResource
    extends FileLocalResource {
        private final Resource resource;

        private MavenTransferLoggingFileResource(File file, Resource resource) {
            super(file);
            this.resource = resource;
        }

        public InputStream open() {
            RepositoryTransportDeployWagon.this.transferEventSupport.fireTransferStarted(RepositoryTransportDeployWagon.this.transferEvent(this.resource, 1, 6));
            return new ObservingInputStream(super.open(), this.resource);
        }

        protected class ObservingInputStream
        extends InputStream {
            private final InputStream inputStream;
            private final TransferEvent transferEvent;
            private final byte[] singleByteBuffer = new byte[1];

            public ObservingInputStream(InputStream inputStream, Resource resource) {
                this.inputStream = inputStream;
                this.transferEvent = RepositoryTransportDeployWagon.this.transferEvent(resource, 3, 6);
            }

            @Override
            public void close() throws IOException {
                this.inputStream.close();
            }

            @Override
            public int read() throws IOException {
                int result = this.inputStream.read();
                if (result >= 0) {
                    this.singleByteBuffer[0] = (byte)result;
                    this.logTransfer(this.singleByteBuffer, 1);
                }
                return result;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int read = this.inputStream.read(b, off, len);
                if (read > 0) {
                    this.logTransfer(b, read);
                }
                return read;
            }

            private void logTransfer(byte[] bytes, int read) {
                RepositoryTransportDeployWagon.this.transferEventSupport.fireTransferProgress(this.transferEvent, bytes, read);
            }
        }
    }
}

