/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleDescriptorConverter;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.IvyDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

class IvyModuleResolveMetaDataBuilder {
    private final List<Artifact> artifacts = Lists.newArrayList();
    private final DefaultModuleDescriptor ivyDescriptor;
    private final IvyModuleDescriptorConverter converter;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IvyModuleResolveMetaDataBuilder(DefaultModuleDescriptor module, IvyModuleDescriptorConverter converter, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.ivyDescriptor = module;
        this.converter = converter;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public void addArtifact(IvyArtifactName newArtifact, Set<String> configurations) {
        this.artifacts.add(new Artifact(newArtifact, configurations));
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public DefaultMutableIvyModuleResolveMetadata build() {
        ModuleDescriptorState descriptorState = this.converter.forIvyModuleDescriptor((ModuleDescriptor)this.ivyDescriptor);
        for (Artifact artifact : this.artifacts) {
            descriptorState.addArtifact(artifact.getArtifactName(), artifact.getConfigurations());
        }
        List<Configuration> configurations = this.converter.extractConfigurations((ModuleDescriptor)this.ivyDescriptor);
        List<IvyDependencyMetadata> dependencies = this.converter.extractDependencies((ModuleDescriptor)this.ivyDescriptor);
        ModuleComponentIdentifier cid = descriptorState.getComponentIdentifier();
        ModuleVersionIdentifier mvi = this.moduleIdentifierFactory.moduleWithVersion(cid.getGroup(), cid.getModule(), cid.getVersion());
        return new DefaultMutableIvyModuleResolveMetadata(mvi, cid, descriptorState, configurations, dependencies);
    }
}

