/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompiler;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.util.TreeVisitor;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerDaemonManager;

public class DefaultScalaToolProvider
implements ToolProvider {
    public static final String DEFAULT_ZINC_VERSION = "0.3.7";
    private final File gradleUserHomeDir;
    private final File rootProjectDir;
    private final WorkerDaemonManager compilerDaemonManager;
    private final Set<File> resolvedScalaClasspath;
    private final Set<File> resolvedZincClasspath;

    public DefaultScalaToolProvider(File gradleUserHomeDir, File rootProjectDir, WorkerDaemonManager compilerDaemonManager, Set<File> resolvedScalaClasspath, Set<File> resolvedZincClasspath) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.rootProjectDir = rootProjectDir;
        this.compilerDaemonManager = compilerDaemonManager;
        this.resolvedScalaClasspath = resolvedScalaClasspath;
        this.resolvedZincClasspath = resolvedZincClasspath;
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        if (ScalaJavaJointCompileSpec.class.isAssignableFrom(spec)) {
            ZincScalaCompiler scalaCompiler = new ZincScalaCompiler(this.resolvedScalaClasspath, this.resolvedZincClasspath, this.gradleUserHomeDir);
            return new NormalizingScalaCompiler((Compiler<ScalaJavaJointCompileSpec>)new DaemonScalaCompiler<ScalaJavaJointCompileSpec>(this.rootProjectDir, scalaCompiler, (WorkerDaemonFactory)this.compilerDaemonManager, this.resolvedZincClasspath));
        }
        throw new IllegalArgumentException(String.format("Cannot create Compiler for unsupported CompileSpec type '%s'", spec.getSimpleName()));
    }

    public <T> T get(Class<T> toolType) {
        throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
    }

    public boolean isAvailable() {
        return true;
    }

    public void explain(TreeVisitor<? super String> visitor) {
    }
}

