/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J.\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "checkForErrors", "", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin-compiler"})
public final class TopDownAnalyzerFacadeForJS {
    public static final TopDownAnalyzerFacadeForJS INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull JsConfig config) {
        Collection<ModuleDescriptorImpl> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(config, "config");
        Project project = config.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "config.project");
        ProjectContext projectContext = ContextKt.ProjectContext(project);
        Name name2 = Name.special("<" + config.getModuleId() + ">");
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.special(\"<${config.moduleId}>\")");
        MutableModuleContext context = ContextKt.ContextForNewModule(projectContext, name2, JsPlatform.INSTANCE.getBuiltIns(), null);
        Iterable iterable = config.getModuleDescriptors();
        Collection collection2 = CollectionsKt.listOf(context.getModule());
        MutableModuleContext mutableModuleContext = context;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsModuleDescriptor jsModuleDescriptor = (JsModuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            ModuleDescriptorImpl moduleDescriptorImpl = (ModuleDescriptorImpl)it.getData();
            collection.add(moduleDescriptorImpl);
        }
        collection = (List)destination$iv$iv;
        mutableModuleContext.setDependencies(CollectionsKt.plus((Collection)CollectionsKt.plus(collection2, (Iterable)collection), (Iterable)CollectionsKt.listOf(JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule())));
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context.getModule(), config.getModuleKind());
        return TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files2, trace, context, config);
    }

    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull JsConfig config) {
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(moduleContext, "moduleContext");
        Intrinsics.checkParameterIsNotNull(config, "config");
        Collection<KtFile> allFiles = JsConfig.withJsLibAdded(files2, config);
        DeclarationProviderFactory declarationProviderFactory2 = new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), allFiles);
        LanguageVersionSettingsImpl languageVersionSettingsImpl = config.getConfiguration().get(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, LanguageVersionSettingsImpl.DEFAULT);
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettingsImpl, "config.configuration.get\u2026sionSettingsImpl.DEFAULT)");
        LazyTopDownAnalyzer analyzerForJs = InjectionKt.createTopDownAnalyzerForJs(moduleContext, trace, declarationProviderFactory2, languageVersionSettingsImpl);
        LazyTopDownAnalyzer.analyzeDeclarations$default(analyzerForJs, TopDownAnalysisMode.TopLevelDeclarations, files2, null, 4, null);
        return JsAnalysisResult.Companion.success(trace, moduleContext.getModule());
    }

    @JvmStatic
    public static final void checkForErrors(@NotNull Collection<? extends KtFile> allFiles, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(allFiles, "allFiles");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (KtFile ktFile : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(ktFile);
        }
    }

    private TopDownAnalyzerFacadeForJS() {
        INSTANCE = this;
    }

    static {
        new TopDownAnalyzerFacadeForJS();
    }
}

