/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.translate.context.AliasingContext;
import org.jetbrains.kotlin.js.translate.context.DeferredCallSite;
import org.jetbrains.kotlin.js.translate.context.DynamicContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;

public class TranslationContext {
    @NotNull
    private final DynamicContext dynamicContext;
    @NotNull
    private final StaticContext staticContext;
    @NotNull
    private final AliasingContext aliasingContext;
    @Nullable
    private final UsageTracker usageTracker;
    @Nullable
    private final TranslationContext parent;
    @Nullable
    private final DeclarationDescriptor declarationDescriptor;
    @Nullable
    private final ClassDescriptor classDescriptor;
    @Nullable
    private final VariableDescriptor continuationParameterDescriptor;
    private final Map<JsExpression, TemporaryConstVariable> expressionToTempConstVariableCache;

    @NotNull
    public static TranslationContext rootContext(@NotNull StaticContext staticContext, @NotNull JsFunction rootFunction) {
        if (staticContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "rootContext"));
        }
        if (rootFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFunction", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "rootContext"));
        }
        JsBlock block = new JsBlock(staticContext.getTopLevelStatements());
        DynamicContext rootDynamicContext = DynamicContext.rootContext(rootFunction.getScope(), block);
        AliasingContext rootAliasingContext = AliasingContext.getCleanContext();
        TranslationContext translationContext = new TranslationContext(null, staticContext, rootDynamicContext, rootAliasingContext, null, null);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "rootContext"));
        }
        return translationContext;
    }

    private TranslationContext(@Nullable TranslationContext parent2, @NotNull StaticContext staticContext, @NotNull DynamicContext dynamicContext, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker, @Nullable DeclarationDescriptor declarationDescriptor) {
        if (staticContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "<init>"));
        }
        if (dynamicContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamicContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "<init>"));
        }
        if (aliasingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasingContext", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "<init>"));
        }
        this.expressionToTempConstVariableCache = new HashMap<JsExpression, TemporaryConstVariable>();
        this.parent = parent2;
        this.dynamicContext = dynamicContext;
        this.staticContext = staticContext;
        this.aliasingContext = aliasingContext;
        this.usageTracker = usageTracker;
        this.declarationDescriptor = declarationDescriptor;
        this.classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : (parent2 != null ? parent2.classDescriptor : null);
        this.continuationParameterDescriptor = this.calculateContinuationParameter();
    }

    private VariableDescriptor calculateContinuationParameter() {
        FunctionDescriptor function2;
        if (this.parent != null && this.parent.declarationDescriptor == this.declarationDescriptor) {
            return this.parent.continuationParameterDescriptor;
        }
        if (this.declarationDescriptor instanceof FunctionDescriptor && (function2 = (FunctionDescriptor)this.declarationDescriptor).isSuspend() && !(function2 instanceof AnonymousFunctionDescriptor)) {
            ClassDescriptor continuationDescriptor = DescriptorUtilKt.findContinuationClassDescriptor(this.getCurrentModule(), NoLookupLocation.FROM_BACKEND);
            return new LocalVariableDescriptor(this.declarationDescriptor, Annotations.Companion.getEMPTY(), Name.identifier("continuation"), continuationDescriptor.getDefaultType(), false, false, SourceElement.NO_SOURCE);
        }
        return null;
    }

    @NotNull
    public Collection<StaticContext.ImportedModule> getImportedModules() {
        Collection<StaticContext.ImportedModule> collection = this.staticContext.getImportedModules();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getImportedModules"));
        }
        return collection;
    }

    @Nullable
    public UsageTracker usageTracker() {
        return this.usageTracker;
    }

    @NotNull
    public DynamicContext dynamicContext() {
        DynamicContext dynamicContext = this.dynamicContext;
        if (dynamicContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "dynamicContext"));
        }
        return dynamicContext;
    }

    @NotNull
    public TranslationContext contextWithScope(@NotNull JsFunction fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "contextWithScope"));
        }
        TranslationContext translationContext = this.newFunctionBody(fun, this.aliasingContext, this.declarationDescriptor);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "contextWithScope"));
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext newFunctionBody(@NotNull JsFunction fun, @Nullable AliasingContext aliasingContext, DeclarationDescriptor descriptor2) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBody"));
        }
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        if (aliasingContext == null) {
            aliasingContext = this.aliasingContext.inner();
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, aliasingContext, this.usageTracker, descriptor2);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBody"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newFunctionBodyWithUsageTracker(@NotNull JsFunction fun, @NotNull MemberDescriptor descriptor2) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBodyWithUsageTracker"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBodyWithUsageTracker"));
        }
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        UsageTracker usageTracker = new UsageTracker(this.usageTracker, descriptor2, fun.getScope());
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext.inner(), usageTracker, descriptor2);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newFunctionBodyWithUsageTracker"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerWithUsageTracker(@NotNull JsScope scope, @NotNull MemberDescriptor descriptor2) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerWithUsageTracker"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerWithUsageTracker"));
        }
        UsageTracker usageTracker = new UsageTracker(this.usageTracker, descriptor2, scope);
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext, this.aliasingContext.inner(), usageTracker, descriptor2);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerWithUsageTracker"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext inner(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "inner"));
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext, this.aliasingContext.inner(), this.usageTracker, descriptor2);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "inner"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerBlock(@NotNull JsBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerBlock"));
        }
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext.innerBlock(block), this.aliasingContext, this.usageTracker, this.declarationDescriptor);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerBlock"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerBlock() {
        TranslationContext translationContext = this.innerBlock(new JsBlock());
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerBlock"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newDeclaration"));
        }
        JsBlock innerBlock = this.getBlockForDescriptor(descriptor2);
        if (innerBlock == null) {
            innerBlock = this.dynamicContext.jsBlock();
        }
        DynamicContext dynamicContext = DynamicContext.newContext(this.getScopeForDescriptor(descriptor2), innerBlock);
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext, this.usageTracker, descriptor2);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "newDeclaration"));
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext innerWithAliasingContext(AliasingContext aliasingContext) {
        TranslationContext translationContext = new TranslationContext(this, this.staticContext, this.dynamicContext, aliasingContext, this.usageTracker, this.declarationDescriptor);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerWithAliasingContext"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsExpression alias) {
        if (correspondingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "correspondingDescriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliased"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliased"));
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.inner(correspondingDescriptor, alias));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliased"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithAliasesForExpressions(@NotNull Map<KtExpression, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliasesForExpressions"));
        }
        if (aliases.isEmpty()) {
            TranslationContext translationContext = this;
            if (translationContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliasesForExpressions"));
            }
            return translationContext;
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.withExpressionsAliased(aliases));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithAliasesForExpressions"));
        }
        return translationContext;
    }

    @NotNull
    public TranslationContext innerContextWithDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithDescriptorsAliased"));
        }
        if (aliases.isEmpty()) {
            TranslationContext translationContext = this;
            if (translationContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithDescriptorsAliased"));
            }
            return translationContext;
        }
        TranslationContext translationContext = this.innerWithAliasingContext(this.aliasingContext.withDescriptorsAliased(aliases));
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "innerContextWithDescriptorsAliased"));
        }
        return translationContext;
    }

    @Nullable
    private JsBlock getBlockForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getBlockForDescriptor"));
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.getFunctionObject((CallableDescriptor)descriptor2).getBody();
        }
        return null;
    }

    @Nullable
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @NotNull
    public BindingContext bindingContext() {
        BindingContext bindingContext = this.staticContext.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "bindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public BindingTrace bindingTrace() {
        BindingTrace bindingTrace = this.staticContext.getBindingTrace();
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "bindingTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getScopeForDescriptor"));
        }
        JsScope jsScope = this.staticContext.getScopeForDescriptor(descriptor2);
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getScopeForDescriptor"));
        }
        return jsScope;
    }

    @NotNull
    public JsName getNameForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForElement"));
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(this.bindingContext(), element);
        JsName jsName = this.getNameForDescriptor(descriptor2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForElement"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForDescriptor"));
        }
        JsName jsName = this.staticContext.getNameForDescriptor(descriptor2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getInnerNameForDescriptor"));
        }
        JsName jsName = this.staticContext.getInnerNameForDescriptor(descriptor2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getInnerNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForObjectInstance(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForObjectInstance"));
        }
        JsName jsName = this.staticContext.getNameForObjectInstance(descriptor2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForObjectInstance"));
        }
        return jsName;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        if (descriptor2 instanceof MemberDescriptor && this.isFromCurrentModule(descriptor2) && this.isPublicInlineFunction()) {
            this.staticContext.export((MemberDescriptor)descriptor2, true);
        }
        JsNameRef jsNameRef = this.staticContext.getQualifiedReference(descriptor2);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef getInnerReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getInnerReference"));
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            JsNameRef jsNameRef = this.getQualifiedReference(descriptor2);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getInnerReference"));
            }
            return jsNameRef;
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(this.getInnerNameForDescriptor(descriptor2), null);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getInnerReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsName getNameForBackingField(@NotNull PropertyDescriptor property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForBackingField"));
        }
        JsName jsName = this.staticContext.getNameForBackingField(property);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getNameForBackingField"));
        }
        return jsName;
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression) {
        TemporaryVariable temporaryVariable = this.dynamicContext.declareTemporary(initExpression);
        if (temporaryVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "declareTemporary"));
        }
        return temporaryVariable;
    }

    @NotNull
    public JsExpression defineTemporary(@NotNull JsExpression initExpression) {
        if (initExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initExpression", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "defineTemporary"));
        }
        TemporaryVariable var = this.dynamicContext.declareTemporary(initExpression);
        this.addStatementToCurrentBlock(var.assignmentStatement());
        JsNameRef jsNameRef = var.reference();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "defineTemporary"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression cacheExpressionIfNeeded(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "cacheExpressionIfNeeded"));
        }
        JsExpression jsExpression = TranslationUtils.isCacheNeeded(expression) ? this.defineTemporary(expression) : expression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "cacheExpressionIfNeeded"));
        }
        return jsExpression;
    }

    @NotNull
    public TemporaryConstVariable getOrDeclareTemporaryConstVariable(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getOrDeclareTemporaryConstVariable"));
        }
        TemporaryConstVariable tempVar = this.expressionToTempConstVariableCache.get(expression);
        if (tempVar == null) {
            TemporaryVariable tmpVar = this.declareTemporary(expression);
            tempVar = new TemporaryConstVariable(tmpVar.name(), tmpVar.assignmentExpression());
            this.expressionToTempConstVariableCache.put(expression, tempVar);
            this.expressionToTempConstVariableCache.put(tmpVar.assignmentExpression(), tempVar);
        }
        TemporaryConstVariable temporaryConstVariable = tempVar;
        if (temporaryConstVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getOrDeclareTemporaryConstVariable"));
        }
        return temporaryConstVariable;
    }

    public void associateExpressionToLazyValue(JsExpression expression, TemporaryConstVariable temporaryConstVariable) {
        assert (expression == temporaryConstVariable.assignmentExpression());
        this.expressionToTempConstVariableCache.put(expression, temporaryConstVariable);
    }

    @NotNull
    public Namer namer() {
        Namer namer = this.staticContext.getNamer();
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "namer"));
        }
        return namer;
    }

    @NotNull
    public Intrinsics intrinsics() {
        Intrinsics intrinsics = this.staticContext.getIntrinsics();
        if (intrinsics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "intrinsics"));
        }
        return intrinsics;
    }

    @NotNull
    public JsProgram program() {
        JsProgram jsProgram = this.staticContext.getProgram();
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "program"));
        }
        return jsProgram;
    }

    @NotNull
    public JsConfig getConfig() {
        JsConfig jsConfig = this.staticContext.getConfig();
        if (jsConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getConfig"));
        }
        return jsConfig;
    }

    @NotNull
    public JsScope scope() {
        JsScope jsScope = this.dynamicContext.getScope();
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "scope"));
        }
        return jsScope;
    }

    @NotNull
    public AliasingContext aliasingContext() {
        AliasingContext aliasingContext = this.aliasingContext;
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "aliasingContext"));
        }
        return aliasingContext;
    }

    @NotNull
    public JsFunction getFunctionObject(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getFunctionObject"));
        }
        JsFunction jsFunction = this.staticContext.getFunctionWithScope(descriptor2);
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getFunctionObject"));
        }
        return jsFunction;
    }

    public void addStatementToCurrentBlock(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addStatementToCurrentBlock"));
        }
        this.dynamicContext.jsBlock().getStatements().add(statement);
    }

    public void addStatementsToCurrentBlock(@NotNull Collection<JsStatement> statements) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addStatementsToCurrentBlock"));
        }
        this.dynamicContext.jsBlock().getStatements().addAll(statements);
    }

    public void addStatementsToCurrentBlockFrom(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addStatementsToCurrentBlockFrom"));
        }
        this.addStatementsToCurrentBlockFrom(context.dynamicContext().jsBlock());
    }

    public void addStatementsToCurrentBlockFrom(@NotNull JsBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addStatementsToCurrentBlockFrom"));
        }
        this.dynamicContext.jsBlock().getStatements().addAll(block.getStatements());
    }

    public boolean currentBlockIsEmpty() {
        return this.dynamicContext.jsBlock().isEmpty();
    }

    public void moveVarsFrom(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "moveVarsFrom"));
        }
        this.dynamicContext.moveVarsFrom(context.dynamicContext());
    }

    @NotNull
    public JsBlock getCurrentBlock() {
        JsBlock jsBlock = this.dynamicContext.jsBlock();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getCurrentBlock"));
        }
        return jsBlock;
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getAliasForDescriptor"));
        }
        JsExpression nameRef = this.captureIfNeedAndGetCapturedName(descriptor2);
        if (nameRef != null) {
            return nameRef;
        }
        return this.aliasingContext.getAliasForDescriptor(descriptor2);
    }

    @NotNull
    public JsExpression getDispatchReceiver(@NotNull ReceiverParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
        }
        JsExpression alias = this.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
            }
            return jsExpression;
        }
        if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.isCoroutineLambda(descriptor2.getContainingDeclaration())) {
            JsNameRef result2 = new JsNameRef("$$controller$$", JsAstUtils.stateMachineReceiver());
            MetadataProperties.setCoroutineController(result2, true);
            JsNameRef jsNameRef = result2;
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
            }
            return jsNameRef;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration())) {
            if (this.isConstructorOrDirectScope(descriptor2.getContainingDeclaration())) {
                JsLiteral.JsValueLiteral jsValueLiteral = JsLiteral.THIS;
                if (jsValueLiteral == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
                }
                return jsValueLiteral;
            }
            ClassDescriptor objectDescriptor = (ClassDescriptor)descriptor2.getContainingDeclaration();
            JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(objectDescriptor, this);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
            }
            return jsExpression;
        }
        if (descriptor2.getValue() instanceof ExtensionReceiver) {
            JsLiteral.JsValueLiteral jsValueLiteral = JsLiteral.THIS;
            if (jsValueLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
            }
            return jsValueLiteral;
        }
        ClassifierDescriptor classifier2 = descriptor2.getValue().getType().getConstructor().getDeclarationDescriptor();
        assert (classifier2 instanceof ClassDescriptor);
        ClassDescriptor cls = (ClassDescriptor)classifier2;
        assert (this.classDescriptor != null) : "Can't get ReceiverParameterDescriptor in top level";
        JsExpression receiver = this.getAliasForDescriptor(this.classDescriptor.getThisAsReceiverParameter());
        if (receiver == null) {
            receiver = JsLiteral.THIS;
        }
        JsExpression jsExpression = this.getDispatchReceiverPath(cls, receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiver"));
        }
        return jsExpression;
    }

    private boolean isConstructorOrDirectScope(DeclarationDescriptor descriptor2) {
        return descriptor2 == DescriptorUtils.getParentOfType(this.declarationDescriptor, ClassDescriptor.class, false);
    }

    @NotNull
    private JsExpression getDispatchReceiverPath(@Nullable ClassDescriptor cls, JsExpression thisExpression) {
        JsExpression alias;
        if (cls != null && (alias = this.getAliasForDescriptor(cls)) != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiverPath"));
            }
            return jsExpression;
        }
        if (this.classDescriptor == cls || this.parent == null) {
            JsExpression jsExpression = thisExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiverPath"));
            }
            return jsExpression;
        }
        if (this.classDescriptor != this.parent.classDescriptor) {
            JsNameRef jsNameRef = new JsNameRef("$outer", this.parent.getDispatchReceiverPath(cls, thisExpression));
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiverPath"));
            }
            return jsNameRef;
        }
        JsExpression jsExpression = this.parent.getDispatchReceiverPath(cls, thisExpression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getDispatchReceiverPath"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression captureIfNeedAndGetCapturedName(DeclarationDescriptor descriptor2) {
        if (this.usageTracker != null) {
            this.usageTracker.used(descriptor2);
            JsName name2 = UsageTrackerKt.getNameForCapturedDescriptor(this.usageTracker, descriptor2);
            if (name2 != null) {
                JsExpression result2;
                if (this.shouldCaptureViaThis()) {
                    result2 = JsLiteral.THIS;
                    int depth = this.getOuterLocalClassDepth();
                    for (int i = 0; i < depth; ++i) {
                        result2 = new JsNameRef("$outer", result2);
                    }
                    result2 = new JsNameRef(name2, result2);
                } else {
                    result2 = name2.makeRef();
                }
                return result2;
            }
        }
        return null;
    }

    private int getOuterLocalClassDepth() {
        if (this.usageTracker == null) {
            return 0;
        }
        MemberDescriptor capturingDescriptor = this.usageTracker.getContainingDescriptor();
        if (!(capturingDescriptor instanceof ClassDescriptor)) {
            return 0;
        }
        ClassDescriptor capturingClassDescriptor = (ClassDescriptor)capturingDescriptor;
        ClassDescriptor currentDescriptor = this.classDescriptor;
        if (currentDescriptor == null) {
            return 0;
        }
        int depth = 0;
        while (currentDescriptor != capturingClassDescriptor) {
            DeclarationDescriptor container2 = currentDescriptor.getContainingDeclaration();
            if (!(container2 instanceof ClassDescriptor)) {
                return 0;
            }
            currentDescriptor = (ClassDescriptor)container2;
            ++depth;
        }
        return depth;
    }

    private boolean shouldCaptureViaThis() {
        if (this.declarationDescriptor == null) {
            return false;
        }
        if (DescriptorUtils.isDescriptorWithLocalVisibility(this.declarationDescriptor)) {
            return false;
        }
        return !(this.declarationDescriptor instanceof ConstructorDescriptor) || !DescriptorUtils.isDescriptorWithLocalVisibility(this.declarationDescriptor.getContainingDeclaration());
    }

    @Nullable
    public DeclarationDescriptor getDeclarationDescriptor() {
        return this.declarationDescriptor;
    }

    public void putClassOrConstructorClosure(@NotNull MemberDescriptor descriptor2, @NotNull List<DeclarationDescriptor> closure) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "putClassOrConstructorClosure"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "putClassOrConstructorClosure"));
        }
        this.staticContext.putClassOrConstructorClosure(descriptor2, closure);
    }

    @Nullable
    public List<DeclarationDescriptor> getClassOrConstructorClosure(@NotNull MemberDescriptor classOrConstructor) {
        if (classOrConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrConstructor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getClassOrConstructorClosure"));
        }
        if (classOrConstructor instanceof TypeAliasConstructorDescriptor) {
            ClassConstructorDescriptor constructorDescriptor = ((TypeAliasConstructorDescriptor)classOrConstructor).getUnderlyingConstructorDescriptor();
            return this.getClassOrConstructorClosure(constructorDescriptor);
        }
        List<DeclarationDescriptor> result2 = this.staticContext.getClassOrConstructorClosure(classOrConstructor);
        if (result2 == null && classOrConstructor instanceof ConstructorDescriptor && ((ConstructorDescriptor)classOrConstructor).isPrimary()) {
            result2 = this.staticContext.getClassOrConstructorClosure((ClassDescriptor)classOrConstructor.getContainingDeclaration());
        }
        return result2;
    }

    @NotNull
    public JsExpression getArgumentForClosureConstructor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getArgumentForClosureConstructor"));
        }
        JsExpression alias = this.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getArgumentForClosureConstructor"));
            }
            return jsExpression;
        }
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            JsExpression jsExpression = this.getDispatchReceiver((ReceiverParameterDescriptor)descriptor2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getArgumentForClosureConstructor"));
            }
            return jsExpression;
        }
        if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
            JsLiteral.JsValueLiteral jsValueLiteral = JsLiteral.THIS;
            if (jsValueLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getArgumentForClosureConstructor"));
            }
            return jsValueLiteral;
        }
        JsNameRef jsNameRef = this.getNameForDescriptor(descriptor2).makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getArgumentForClosureConstructor"));
        }
        return jsNameRef;
    }

    @Nullable
    public JsName getOuterClassReference(ClassDescriptor descriptor2) {
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (!(container2 instanceof ClassDescriptor) || !descriptor2.isInner()) {
            return null;
        }
        return this.staticContext.getScopeForDescriptor(descriptor2).declareName("$outer");
    }

    public void startDeclaration() {
        ClassDescriptor classDescriptor = this.classDescriptor;
        if (classDescriptor != null && !(classDescriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.staticContext.getDeferredCallSites().put(classDescriptor, new ArrayList());
        }
    }

    @NotNull
    public List<DeferredCallSite> endDeclaration() {
        List<DeferredCallSite> result2 = null;
        if (this.classDescriptor != null) {
            result2 = this.staticContext.getDeferredCallSites().remove(this.classDescriptor);
        }
        if (result2 == null) {
            result2 = Collections.emptyList();
        }
        List<DeferredCallSite> list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "endDeclaration"));
        }
        return list2;
    }

    public boolean shouldBeDeferred(@NotNull ClassConstructorDescriptor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "shouldBeDeferred"));
        }
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        return this.staticContext.getDeferredCallSites().containsKey(classDescriptor);
    }

    public void deferConstructorCall(@NotNull ClassConstructorDescriptor constructor, @NotNull List<JsExpression> invocationArgs) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "deferConstructorCall"));
        }
        if (invocationArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocationArgs", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "deferConstructorCall"));
        }
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        List<DeferredCallSite> callSites = this.staticContext.getDeferredCallSites().get(classDescriptor);
        if (callSites == null) {
            throw new IllegalStateException("This method should be call only when `shouldBeDeferred` method reports true for given constructor: " + constructor);
        }
        callSites.add(new DeferredCallSite(constructor, invocationArgs, this));
    }

    @Nullable
    public JsExpression getModuleExpressionFor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getModuleExpressionFor"));
        }
        return this.staticContext.getModuleExpressionFor(descriptor2);
    }

    public void addDeclarationStatement(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addDeclarationStatement"));
        }
        this.staticContext.getDeclarationStatements().add(statement);
    }

    public void addTopLevelStatement(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addTopLevelStatement"));
        }
        this.staticContext.getTopLevelStatements().add(statement);
    }

    @NotNull
    public JsName createGlobalName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "createGlobalName"));
        }
        JsName jsName = this.staticContext.getRootFunction().getScope().declareTemporaryName(suggestedName);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "createGlobalName"));
        }
        return jsName;
    }

    @NotNull
    public JsFunction createRootScopedFunction(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "createRootScopedFunction"));
        }
        JsFunction jsFunction = this.createRootScopedFunction(descriptor2.toString());
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "createRootScopedFunction"));
        }
        return jsFunction;
    }

    @NotNull
    public JsFunction createRootScopedFunction(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "createRootScopedFunction"));
        }
        JsFunction jsFunction = new JsFunction((JsScope)this.staticContext.getRootFunction().getScope(), new JsBlock(), description);
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "createRootScopedFunction"));
        }
        return jsFunction;
    }

    public void addClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "addClass"));
        }
        this.staticContext.addClass(classDescriptor);
    }

    public void export(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "export"));
        }
        this.staticContext.export(descriptor2, false);
    }

    public boolean isFromCurrentModule(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "isFromCurrentModule"));
        }
        return this.staticContext.getCurrentModule() == DescriptorUtilsKt.getModule(descriptor2);
    }

    public boolean isPublicInlineFunction() {
        DeclarationDescriptor descriptor2 = this.declarationDescriptor;
        while (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor function2 = (FunctionDescriptor)descriptor2;
            if (function2.isInline() && DescriptorUtilsKt.isEffectivelyPublicApi(function2)) {
                return true;
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return false;
    }

    @Nullable
    public VariableDescriptor getContinuationParameterDescriptor() {
        return this.continuationParameterDescriptor;
    }

    @NotNull
    public ModuleDescriptor getCurrentModule() {
        ModuleDescriptor moduleDescriptor = this.staticContext.getCurrentModule();
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TranslationContext", "getCurrentModule"));
        }
        return moduleDescriptor;
    }

    @Nullable
    public TranslationContext getParent() {
        return this.parent;
    }
}

