/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ByteList;

public class TypeConverter {
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        return TypeConverter.convertToType19(obj, target, convertMethod, raise2);
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites, boolean raise2) {
        return TypeConverter.convertToType19(context, obj, target, sites, raise2);
    }

    public static IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(obj.getRuntime().getCurrentContext(), convertMethod);
        return r == null ? TypeConverter.handleUncoercibleObject(raise2, obj, target) : r;
    }

    public static IRubyObject convertToType19(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(context, sites);
        return r == null ? TypeConverter.handleUncoercibleObject(raise2, obj, target) : r;
    }

    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod) {
        return TypeConverter.convertToType19(obj, target, convertMethod);
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        return TypeConverter.convertToType19(context, obj, target, sites);
    }

    public static IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            String cname = obj.getMetaClass().toString();
            throw obj.getRuntime().newTypeError("can't convert " + cname + " to " + target.getName() + " (" + cname + "#" + convertMethod + " gives " + val.getMetaClass() + ")");
        }
        return val;
    }

    public static IRubyObject convertToType19(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(context, obj, target, sites, true);
        if (!target.isInstance(val)) {
            String cname = obj.getMetaClass().toString();
            throw obj.getRuntime().newTypeError("can't convert " + cname + " to " + target.getName() + " (" + cname + "#" + sites.methodName + " gives " + val.getMetaClass() + ")");
        }
        return val;
    }

    public static RubyNumeric toFloat(Ruby runtime, IRubyObject obj) {
        RubyClass floatClass = runtime.getFloat();
        if (floatClass.isInstance(obj)) {
            return (RubyNumeric)obj;
        }
        if (!runtime.getNumeric().isInstance(obj)) {
            throw runtime.newTypeError(obj, "Float");
        }
        return (RubyNumeric)TypeConverter.convertToType19(obj, floatClass, "to_f", true);
    }

    public static IRubyObject checkData(IRubyObject obj) {
        if (obj instanceof DataType) {
            return obj;
        }
        throw obj.getRuntime().newTypeError("wrong argument type " + TypeConverter.typeAsString(obj) + " (expected Data)");
    }

    private static String typeAsString(IRubyObject obj) {
        if (obj.isNil()) {
            return "nil";
        }
        if (obj instanceof RubyBoolean) {
            return obj.isTrue() ? "true" : "false";
        }
        return obj.getMetaClass().getRealClass().getName();
    }

    public static RubySymbol checkID(IRubyObject obj) {
        Ruby runtime = obj.getRuntime();
        if (obj instanceof RubySymbol || obj instanceof RubyString) {
            return RubySymbol.newHardSymbol(runtime, obj);
        }
        IRubyObject str = TypeConverter.convertToTypeWithCheck(obj, runtime.getString(), "to_str");
        if (!str.isNil()) {
            return RubySymbol.newHardSymbol(runtime, str);
        }
        ThreadContext context = runtime.getCurrentContext();
        throw runtime.newTypeError(obj.callMethod(context, "inspect") + " is not a symbol nor a string");
    }

    public static RubySymbol checkID(Ruby runtime, String name2) {
        return RubySymbol.newHardSymbol(runtime, name2.intern());
    }

    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, String convertMethod) {
        return TypeConverter.convertToTypeWithCheck19(obj, target, convertMethod);
    }

    public static IRubyObject convertToTypeWithCheck(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        return TypeConverter.convertToTypeWithCheck19(context, obj, target, sites);
    }

    public static IRubyObject convertToTypeWithCheck19(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw TypeConverter.newTypeError(obj, target, convertMethod, val);
        }
        return val;
    }

    public static IRubyObject convertToTypeWithCheck19(ThreadContext context, IRubyObject obj, RubyClass target, JavaSites.CheckedSites sites) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(context, obj, target, sites, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw TypeConverter.newTypeError(obj, target, sites.methodName, val);
        }
        return val;
    }

    public static RaiseException newTypeError(IRubyObject obj, RubyClass target, String convertMethod, IRubyObject val) {
        String cname = obj.getMetaClass().getName();
        return obj.getRuntime().newTypeError("can't convert " + cname + " to " + target.getName() + " (" + cname + "#" + convertMethod + " gives " + val.getMetaClass().getName() + ")");
    }

    public static IRubyObject checkIntegerType(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getInteger(), sites.to_int_checked);
        return conv instanceof RubyInteger ? conv : context.nil;
    }

    public static IRubyObject checkIntegerType(Ruby runtime, IRubyObject obj, String method) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        if (method.equals("to_int")) {
            return TypeConverter.checkIntegerType(runtime.getCurrentContext(), obj);
        }
        if (method.equals("to_i")) {
            ThreadContext context = runtime.getCurrentContext();
            JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
            IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getInteger(), sites.to_i_checked);
            return conv instanceof RubyInteger ? conv : runtime.getNil();
        }
        IRubyObject conv = TypeConverter.convertToType(obj, runtime.getInteger(), method, false);
        return conv instanceof RubyInteger ? conv : runtime.getNil();
    }

    public static IRubyObject checkFloatType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyFloat) {
            return obj;
        }
        if (!(obj instanceof RubyNumeric)) {
            return runtime.getNil();
        }
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        return TypeConverter.convertToTypeWithCheck(context, obj, runtime.getFloat(), sites.to_f_checked);
    }

    public static IRubyObject checkHashType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyHash) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getHash(), "to_hash");
    }

    public static IRubyObject checkHashType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyHash) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getHash(), sites);
    }

    public static IRubyObject checkStringType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getString(), "to_str");
    }

    public static IRubyObject checkStringType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getString(), sites);
    }

    public static IRubyObject checkStringType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj, RubyClass target) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, target, sites);
    }

    public static IRubyObject checkArrayType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getArray(), "to_ary");
    }

    public static IRubyObject checkArrayType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getArray(), sites);
    }

    public static IRubyObject ioCheckIO(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyIO) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getIO(), "to_io");
    }

    public static RubyIO ioGetIO(Ruby runtime, IRubyObject obj) {
        return (RubyIO)TypeConverter.convertToType(obj, runtime.getIO(), "to_io");
    }

    public static IRubyObject checkArrayType(IRubyObject self2) {
        Ruby runtime = self2.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        return TypeConverter.convertToTypeWithCheck19(context, self2, runtime.getArray(), TypeConverter.sites((ThreadContext)context).to_ary_checked);
    }

    public static IRubyObject handleUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target) {
        return TypeConverter.handleImplicitlyUncoercibleObject(raise2, obj, target);
    }

    public static IRubyObject handleImplicitlyUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target) {
        if (raise2) {
            throw obj.getRuntime().newTypeError("no implicit conversion of " + TypeConverter.typeAsString(obj) + " into " + target);
        }
        return obj.getRuntime().getNil();
    }

    public static void checkType(ThreadContext context, IRubyObject x, RubyModule t) {
        if (x == RubyBasicObject.UNDEF) {
            throw context.runtime.newRuntimeError("bug: undef leaked to the Ruby space");
        }
        ClassIndex xt = x.getMetaClass().getClassIndex();
        if (xt != t.getClassIndex()) {
            String tname = x.getMetaClass().toString();
            if (tname != null) {
                throw context.runtime.newTypeError("wrong argument type " + tname + " (expected " + t.getName() + ")");
            }
            throw context.runtime.newRuntimeError("bug: unknown type " + (Object)((Object)t.getClassIndex()) + " (" + (Object)((Object)xt) + " given)");
        }
    }

    public static IRubyObject convertToInteger(ThreadContext context, IRubyObject val, int base) {
        IRubyObject tmp;
        Ruby runtime;
        block11: {
            runtime = context.runtime;
            do {
                if (val instanceof RubyFloat) {
                    double value2;
                    if (base != 0) {
                        TypeConverter.raiseIntegerBaseError(context);
                    }
                    if ((value2 = ((RubyFloat)val).getValue()) <= 9.223372036854776E18 || value2 >= -9.223372036854776E18) {
                        return RubyNumeric.dbl2num(context.runtime, value2);
                    }
                } else {
                    if (val instanceof RubyFixnum || val instanceof RubyBignum) {
                        if (base != 0) {
                            TypeConverter.raiseIntegerBaseError(context);
                        }
                        return val;
                    }
                    if (val instanceof RubyString) {
                        return RubyNumeric.str2inum(context.runtime, (RubyString)val, base, true);
                    }
                    if (val instanceof RubyNil) {
                        if (base != 0) {
                            TypeConverter.raiseIntegerBaseError(context);
                        }
                        throw context.runtime.newTypeError("can't convert nil into Integer");
                    }
                }
                if (base == 0) break block11;
            } while (!(tmp = TypeConverter.checkStringType(context.runtime, val)).isNil());
            TypeConverter.raiseIntegerBaseError(context);
        }
        if ((tmp = TypeConverter.convertToType19(val, runtime.getString(), "to_int", false)).isNil()) {
            return val.convertToInteger("to_i");
        }
        return tmp;
    }

    public static RubyArray rb_Array(ThreadContext context, IRubyObject val) {
        IRubyObject tmp = TypeConverter.checkArrayType(val);
        if (tmp.isNil()) {
            JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
            tmp = TypeConverter.convertToTypeWithCheck19(context, val, context.runtime.getArray(), sites.to_a_checked);
            if (tmp.isNil()) {
                return context.runtime.newArray(val);
            }
        }
        return (RubyArray)tmp;
    }

    public static RubyArray to_ary(ThreadContext context, IRubyObject ary) {
        return (RubyArray)TypeConverter.convertToType19(context, ary, context.runtime.getArray(), TypeConverter.sites((ThreadContext)context).to_ary_checked);
    }

    private static void raiseIntegerBaseError(ThreadContext context) {
        throw context.runtime.newArgumentError("base specified for non string value");
    }

    private static JavaSites.TypeConverterSites sites(ThreadContext context) {
        return context.sites.TypeConverter;
    }

    @Deprecated
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod, boolean raise2) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise2, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    @Deprecated
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    @Deprecated
    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    @Deprecated
    public static String convertToIdentifier(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return new String(ByteList.plain(((RubyString)obj).getByteList()), RubyEncoding.ISO).intern();
        }
        return obj.asJavaString().intern();
    }

    @Deprecated
    public static IRubyObject convertToTypeOrRaise(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }
}

