/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ToolListener;
import CH.ifa.draw.framework.ViewChangeListener;
import CH.ifa.draw.util.Undoable;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;

public abstract class AbstractTool
implements Tool,
ViewChangeListener {
    private DrawingEditor myDrawingEditor;
    protected int fAnchorX;
    protected int fAnchorY;
    private Undoable myUndoActivity;
    private EventDispatcher myEventDispatcher;
    private boolean myIsUsable;
    private boolean myIsEnabled;

    public AbstractTool(DrawingEditor newDrawingEditor) {
        this.myDrawingEditor = newDrawingEditor;
        this.setEventDispatcher(this.createEventDispatcher());
        this.setEnabled(true);
        this.checkUsable();
        this.editor().addViewChangeListener(this);
    }

    public void activate() {
        if (this.view() != null) {
            this.view().clearSelection();
            this.view().checkDamage();
            this.getEventDispatcher().fireToolActivatedEvent();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            if (this.view() != null) {
                this.view().setCursor(Cursor.getDefaultCursor());
            }
            this.getEventDispatcher().fireToolDeactivatedEvent();
        }
    }

    public void viewSelectionChanged(DrawingView oldView, DrawingView newView) {
        if (this.isActive()) {
            this.deactivate();
            this.activate();
        }
        this.checkUsable();
    }

    public void viewCreated(DrawingView view) {
    }

    public void viewDestroying(DrawingView view) {
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.fAnchorX = x;
        this.fAnchorY = y;
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
    }

    public void keyDown(KeyEvent evt, int key) {
    }

    public Drawing drawing() {
        return this.view().drawing();
    }

    public DrawingEditor editor() {
        return this.myDrawingEditor;
    }

    public DrawingView view() {
        return this.editor().view();
    }

    public boolean isUsable() {
        return this.isEnabled() && this.myIsUsable;
    }

    public void setUsable(boolean newIsUsable) {
        if (this.isUsable() != newIsUsable) {
            this.myIsUsable = newIsUsable;
            if (this.isUsable()) {
                this.getEventDispatcher().fireToolUsableEvent();
            } else {
                this.getEventDispatcher().fireToolUnusableEvent();
            }
        }
    }

    public void setEnabled(boolean newIsEnabled) {
        if (this.isEnabled() != newIsEnabled) {
            this.myIsEnabled = newIsEnabled;
            if (this.isEnabled()) {
                this.getEventDispatcher().fireToolEnabledEvent();
            } else {
                this.getEventDispatcher().fireToolDisabledEvent();
                this.setUsable(false);
                this.deactivate();
            }
        }
    }

    public boolean isEnabled() {
        return this.myIsEnabled;
    }

    public Undoable getUndoActivity() {
        return this.myUndoActivity;
    }

    public void setUndoActivity(Undoable newUndoActivity) {
        this.myUndoActivity = newUndoActivity;
    }

    public boolean isActive() {
        return this.editor().tool() == this && this.isUsable();
    }

    public void addToolListener(ToolListener newToolListener) {
        this.getEventDispatcher().addToolListener(newToolListener);
    }

    public void removeToolListener(ToolListener oldToolListener) {
        this.getEventDispatcher().removeToolListener(oldToolListener);
    }

    private void setEventDispatcher(EventDispatcher newEventDispatcher) {
        this.myEventDispatcher = newEventDispatcher;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    public EventDispatcher createEventDispatcher() {
        return new EventDispatcher(this);
    }

    protected void checkUsable() {
        if (this.isEnabled()) {
            this.setUsable(this.view() != null && this.view().isInteractive());
        }
    }

    public static class EventDispatcher {
        private Vector myRegisteredListeners = new Vector();
        private Tool myObservedTool;

        public EventDispatcher(Tool newObservedTool) {
            this.myObservedTool = newObservedTool;
        }

        public void fireToolUsableEvent() {
            Enumeration le = this.myRegisteredListeners.elements();
            while (le.hasMoreElements()) {
                ((ToolListener)le.nextElement()).toolUsable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolUnusableEvent() {
            Enumeration le = this.myRegisteredListeners.elements();
            while (le.hasMoreElements()) {
                ((ToolListener)le.nextElement()).toolUnusable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolActivatedEvent() {
            Enumeration le = this.myRegisteredListeners.elements();
            while (le.hasMoreElements()) {
                ((ToolListener)le.nextElement()).toolActivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDeactivatedEvent() {
            Enumeration le = this.myRegisteredListeners.elements();
            while (le.hasMoreElements()) {
                ((ToolListener)le.nextElement()).toolDeactivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolEnabledEvent() {
            Enumeration le = this.myRegisteredListeners.elements();
            while (le.hasMoreElements()) {
                ((ToolListener)le.nextElement()).toolEnabled(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDisabledEvent() {
            Enumeration le = this.myRegisteredListeners.elements();
            while (le.hasMoreElements()) {
                ((ToolListener)le.nextElement()).toolDisabled(new EventObject(this.myObservedTool));
            }
        }

        public void addToolListener(ToolListener newToolListener) {
            if (!this.myRegisteredListeners.contains(newToolListener)) {
                this.myRegisteredListeners.add(newToolListener);
            }
        }

        public void removeToolListener(ToolListener oldToolListener) {
            if (this.myRegisteredListeners.contains(oldToolListener)) {
                this.myRegisteredListeners.remove(oldToolListener);
            }
        }
    }
}

