/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.WriterConstants;
import org.objectweb.asm.commons.Method;

public class ScriptInterface {
    private final Class<?> iface;
    private final Method executeMethod;
    private final Definition.Type executeMethodReturnType;
    private final List<MethodArgument> executeArguments;
    private final List<Method> usesMethods;

    public ScriptInterface(Class<?> iface) {
        Class<?>[] types;
        this.iface = iface;
        java.lang.reflect.Method executeMethod = null;
        ArrayList<Method> usesMethods = new ArrayList<Method>();
        for (java.lang.reflect.Method m : iface.getMethods()) {
            if (m.isDefault()) continue;
            if (m.getName().equals("execute")) {
                if (executeMethod == null) {
                    executeMethod = m;
                    continue;
                }
                throw new IllegalArgumentException("Painless can only implement interfaces that have a single method named [execute] but [" + iface.getName() + "] has more than one.");
            }
            if (m.getName().startsWith("uses$")) {
                if (!m.getReturnType().equals(Boolean.TYPE)) {
                    throw new IllegalArgumentException("Painless can only implement uses$ methods that return boolean but [" + iface.getName() + "#" + m.getName() + "] returns [" + m.getReturnType().getName() + "].");
                }
                if (m.getParameterTypes().length > 0) {
                    throw new IllegalArgumentException("Painless can only implement uses$ methods that do not take parameters but [" + iface.getName() + "#" + m.getName() + "] does.");
                }
                usesMethods.add(new Method(m.getName(), WriterConstants.USES_PARAMETER_METHOD_TYPE.toMethodDescriptorString()));
                continue;
            }
            throw new IllegalArgumentException("Painless can only implement methods named [execute] and [uses$argName] but [" + iface.getName() + "] contains a method named [" + m.getName() + "]");
        }
        MethodType methodType = MethodType.methodType(executeMethod.getReturnType(), executeMethod.getParameterTypes());
        this.executeMethod = new Method(executeMethod.getName(), methodType.toMethodDescriptorString());
        this.executeMethodReturnType = ScriptInterface.definitionTypeForClass(executeMethod.getReturnType(), componentType -> "Painless can only implement execute methods returning a whitelisted type but [" + iface.getName() + "#execute] returns [" + componentType.getName() + "] which isn't whitelisted.");
        LinkedHashSet<String> argumentNames = new LinkedHashSet<String>();
        ArrayList<MethodArgument> arguments = new ArrayList<MethodArgument>();
        String[] argumentNamesConstant = ScriptInterface.readArgumentNamesConstant(iface);
        if (argumentNamesConstant.length != (types = executeMethod.getParameterTypes()).length) {
            throw new IllegalArgumentException("[" + iface.getName() + "#ARGUMENTS] has length [2] but [" + iface.getName() + "#execute] takes [1] argument.");
        }
        for (int arg = 0; arg < types.length; ++arg) {
            arguments.add(ScriptInterface.methodArgument(types[arg], argumentNamesConstant[arg]));
            argumentNames.add(argumentNamesConstant[arg]);
        }
        this.executeArguments = Collections.unmodifiableList(arguments);
        for (Method usesMethod : usesMethods) {
            if (argumentNames.contains(usesMethod.getName().substring("uses$".length()))) continue;
            throw new IllegalArgumentException("Painless can only implement uses$ methods that match a parameter name but [" + iface.getName() + "#" + usesMethod.getName() + "] doesn't match any of " + argumentNames + ".");
        }
        this.usesMethods = Collections.unmodifiableList(usesMethods);
    }

    public Class<?> getInterface() {
        return this.iface;
    }

    public Method getExecuteMethod() {
        return this.executeMethod;
    }

    public Definition.Type getExecuteMethodReturnType() {
        return this.executeMethodReturnType;
    }

    public List<MethodArgument> getExecuteArguments() {
        return this.executeArguments;
    }

    public List<Method> getUsesMethods() {
        return this.usesMethods;
    }

    private static MethodArgument methodArgument(Class<?> type, String argName) {
        Definition.Type defType = ScriptInterface.definitionTypeForClass(type, componentType -> "[" + argName + "] is of unknown type [" + componentType.getName() + ". Painless interfaces can only accept arguments that are of whitelisted types.");
        return new MethodArgument(defType, argName);
    }

    private static Definition.Type definitionTypeForClass(Class<?> type, Function<Class<?>, String> unknownErrorMessageSource) {
        Definition.Struct struct;
        int dimensions = 0;
        Class<?> componentType = type;
        while (componentType.isArray()) {
            ++dimensions;
            componentType = componentType.getComponentType();
        }
        if (componentType.equals(Object.class)) {
            struct = Definition.DEF_TYPE.struct;
        } else {
            Definition.RuntimeClass runtimeClass = Definition.getRuntimeClass(componentType);
            if (runtimeClass == null) {
                throw new IllegalArgumentException(unknownErrorMessageSource.apply(componentType));
            }
            struct = runtimeClass.getStruct();
        }
        return Definition.getType(struct, dimensions);
    }

    private static String[] readArgumentNamesConstant(Class<?> iface) {
        Field argumentNamesField;
        try {
            argumentNamesField = iface.getField("ARGUMENTS");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Painless needs a constant [String[] ARGUMENTS] on all interfaces it implements with the names of the method arguments but [" + iface.getName() + "] doesn't have one.", e);
        }
        if (!argumentNamesField.getType().equals(String[].class)) {
            throw new IllegalArgumentException("Painless needs a constant [String[] ARGUMENTS] on all interfaces it implements with the names of the method arguments but [" + iface.getName() + "] doesn't have one.");
        }
        try {
            return (String[])argumentNamesField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Error trying to read [" + iface.getName() + "#ARGUMENTS]", e);
        }
    }

    public static class MethodArgument {
        private final Definition.Type type;
        private final String name;

        public MethodArgument(Definition.Type type, String name) {
            this.type = type;
            this.name = name;
        }

        public Definition.Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

