/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalBucketMetricValue
extends InternalNumericMetricsAggregation.SingleValue {
    public static final String NAME = "bucket_metric_value";
    private double value;
    private String[] keys;

    public InternalBucketMetricValue(String name, String[] keys, double value, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.keys = keys;
        this.value = value;
        this.format = formatter;
    }

    public InternalBucketMetricValue(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.value = in.readDouble();
        this.keys = in.readStringArray();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.value);
        out.writeStringArray(this.keys);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public double value() {
        return this.value;
    }

    public String[] keys() {
        return this.keys;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.value();
        }
        if (path.size() == 1 && "keys".equals(path.get(0))) {
            return this.keys();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.value));
        }
        builder.startArray("keys");
        for (String key : this.keys) {
            builder.value(key);
        }
        builder.endArray();
        return builder;
    }
}

