# From 6.2 to 6.3
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/6.2-to-6.3.md) for the most up to date instructions.*

**Requires version: 6.1 or 6.2.**

## 0. Backup

It's useful to make a backup just in case things go south: (With MySQL, this may require granting "LOCK TABLES" privileges to the GitLab user on the database version)

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

## 1. Stop server

    sudo service gitlab stop

## 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch --all
sudo -u git -H git checkout 6-3-stable
# For GitLab Enterprise Edition: sudo -u git -H git checkout 6-3-stable-ee
```

## 3. Update gitlab-shell (and its config)

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.7.9 # Addresses multiple critical security vulnerabilities
```

The gitlab-shell config changed recently, so check for config file changes and make `/home/git/gitlab-shell/config.yml` the same as <https://github.com/gitlabhq/gitlab-shell/blob/master/config.yml.example>

## 4. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u git -H vim Gemfile

# MySQL

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test postgres --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test mysql --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test mysql --deployment

# Both MySQL and PostgreSQL
# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production
```

## 5. Update config files

TIP: to see what changed in gitlab.yml.example in this release use next command:

```
git diff 6-2-stable:config/gitlab.yml.example 6-3-stable:config/gitlab.yml.example
```

- Make `/home/git/gitlab/config/gitlab.yml` same as https://gitlab.com/gitlab-org/gitlab-ce/blob/6-3-stable/config/gitlab.yml.example but with your settings.
- Make `/home/git/gitlab/config/unicorn.rb` same as https://gitlab.com/gitlab-org/gitlab-ce/blob/6-3-stable/config/unicorn.rb.example but with your settings.

```bash
# Copy rack attack middleware config
cd /home/git/gitlab
sudo -u git -H cp config/initializers/rack_attack.rb.example config/initializers/rack_attack.rb
```

## 6. Update Init script

```bash
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

## 7. Start application

    sudo service gitlab start
    sudo service nginx restart

## 8. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade complete!

## Things went south? Revert to previous version (6.2)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 6.1 to 6.2](6.1-to-6.2.md), except for the database migration (the backup is already migrated to the previous version).

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
