/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class PsiSearchScopeUtil {
    @Nullable
    public static SearchScope union(@Nullable SearchScope a, @Nullable SearchScope b) {
        return a == null ? b : (b == null ? a : a.union(b));
    }

    @Deprecated
    @NotNull
    public static SearchScope scopesUnion(@NotNull SearchScope scope1, @NotNull SearchScope scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope1", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "scopesUnion"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "scopesUnion"));
        }
        SearchScope searchScope = scope1.union(scope2);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "scopesUnion"));
        }
        return searchScope;
    }

    public static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "isInScope"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "isInScope"));
        }
        if (scope instanceof LocalSearchScope) {
            LocalSearchScope local = (LocalSearchScope)scope;
            return PsiSearchScopeUtil.isInScope(local, element);
        }
        GlobalSearchScope globalScope = (GlobalSearchScope)scope;
        return PsiSearchScopeUtil.isInScope(globalScope, element);
    }

    public static boolean isInScope(@NotNull GlobalSearchScope globalScope, @NotNull PsiElement element) {
        if (globalScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalScope", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "isInScope"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "isInScope"));
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return true;
        }
        PsiElement context = file2.getContext();
        if (context != null) {
            file2 = context.getContainingFile();
        }
        if (file2 == null) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        return virtualFile == null || globalScope.contains(virtualFile);
    }

    public static boolean isInScope(@NotNull LocalSearchScope local, @NotNull PsiElement element) {
        PsiElement[] scopeElements;
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "isInScope"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil", "isInScope"));
        }
        for (PsiElement scopeElement : scopeElements = local.getScope()) {
            if (!PsiTreeUtil.isAncestor(scopeElement, element, false)) continue;
            return true;
        }
        return false;
    }
}

