/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.DynamicIncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicIncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedIncrementTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.util.AstUtil;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class IncrementTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtUnaryExpression expression;
    @NotNull
    protected final AccessTranslator accessTranslator;
    @NotNull
    private final JsBlock accessBlock;

    public static boolean isIncrement(IElementType operationToken) {
        return OperatorConventions.INCREMENT_OPERATIONS.contains(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
        }
        if (IncrementTranslator.isDynamic(context, expression)) {
            JsExpression jsExpression = DynamicIncrementTranslator.doTranslate(expression, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
            }
            return jsExpression;
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression)) {
            JsExpression jsExpression = new IntrinsicIncrementTranslator(expression, context).translateIncrementExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = new OverloadedIncrementTranslator(expression, context).translateIncrementExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translate"));
        }
        return jsExpression;
    }

    protected IncrementTranslator(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "<init>"));
        }
        super(context);
        this.accessBlock = new JsBlock();
        this.expression = expression;
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression);
        this.accessTranslator = AccessTranslationUtils.getAccessTranslator(baseExpression, this.context().innerBlock(this.accessBlock)).getCached();
    }

    @NotNull
    protected JsExpression translateIncrementExpression() {
        if (PsiUtils.isPrefix(this.expression)) {
            JsExpression jsExpression = this.asPrefix();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translateIncrementExpression"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.asPostfix();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "translateIncrementExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression asPrefix() {
        JsExpression result2;
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        JsExpression reassignment = this.variableReassignment(getExpression);
        this.accessBlock.getStatements().add(JsAstUtils.asSyntheticStatement(reassignment));
        JsExpression getNewValue = this.accessTranslator.translateAsGet();
        if (this.accessBlock.getStatements().size() == 1) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, reassignment, getNewValue);
        } else {
            this.context().getCurrentBlock().getStatements().addAll(this.accessBlock.getStatements());
            result2 = getNewValue;
        }
        MetadataProperties.setSynthetic(result2, true);
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "asPrefix"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression asPostfix() {
        JsExpression result2;
        TemporaryVariable t1 = this.context().declareTemporary(this.accessTranslator.translateAsGet());
        this.accessBlock.getStatements().add(t1.assignmentStatement());
        JsExpression variableReassignment = this.variableReassignment(t1.reference());
        this.accessBlock.getStatements().add(JsAstUtils.asSyntheticStatement(variableReassignment));
        if (this.accessBlock.getStatements().size() == 2) {
            result2 = AstUtil.newSequence(t1.assignmentExpression(), variableReassignment, t1.reference());
        } else {
            this.context().getCurrentBlock().getStatements().addAll(this.accessBlock.getStatements());
            result2 = t1.reference();
        }
        MetadataProperties.setSynthetic(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "asPostfix"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression variableReassignment(@NotNull JsExpression toCallMethodUpon) {
        if (toCallMethodUpon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCallMethodUpon", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "variableReassignment"));
        }
        JsExpression overloadedMethodCallOnPropertyGetter = this.operationExpression(toCallMethodUpon);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(overloadedMethodCallOnPropertyGetter);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IncrementTranslator", "variableReassignment"));
        }
        return jsExpression;
    }

    @NotNull
    abstract JsExpression operationExpression(@NotNull JsExpression var1);

    private static boolean isDynamic(TranslationContext context, KtUnaryExpression expression) {
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (operationDescriptor != null);
        return DynamicCallsKt.isDynamic(operationDescriptor);
    }
}

