/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class KotlinPathsFromHomeDir
implements KotlinPaths {
    private final File homePath;

    public KotlinPathsFromHomeDir(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "<init>"));
        }
        this.homePath = homePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        File file2 = this.homePath;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getHomePath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getLibPath() {
        File file2 = new File(this.homePath, "lib");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getLibPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getRuntimePath() {
        File file2 = this.getLibraryFile("kotlin-runtime.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getRuntimePath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getReflectPath() {
        File file2 = this.getLibraryFile("kotlin-reflect.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getReflectPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getScriptRuntimePath() {
        File file2 = this.getLibraryFile("kotlin-script-runtime.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getScriptRuntimePath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getKotlinTestPath() {
        File file2 = this.getLibraryFile("kotlin-test.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getKotlinTestPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getRuntimeSourcesPath() {
        File file2 = this.getLibraryFile("kotlin-runtime-sources.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getRuntimeSourcesPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getJsStdLibJarPath() {
        File file2 = this.getLibraryFile("kotlin-stdlib-js.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getJsStdLibJarPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getJsStdLibSrcJarPath() {
        File file2 = this.getLibraryFile("kotlin-stdlib-js-sources.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getJsStdLibSrcJarPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getJsKotlinTestJarPath() {
        File file2 = this.getLibraryFile("kotlin-test-js.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getJsKotlinTestJarPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getAllOpenPluginJarPath() {
        File file2 = this.getLibraryFile("allopen-compiler-plugin.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getAllOpenPluginJarPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getNoArgPluginJarPath() {
        File file2 = this.getLibraryFile("noarg-compiler-plugin.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getNoArgPluginJarPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getCompilerPath() {
        File file2 = this.getLibraryFile("kotlin-compiler.jar");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getCompilerPath"));
        }
        return file2;
    }

    @Override
    @NotNull
    public File getBuildNumberFile() {
        File file2 = new File(this.homePath, "build.txt");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getBuildNumberFile"));
        }
        return file2;
    }

    @NotNull
    private File getLibraryFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getLibraryFile"));
        }
        File file2 = new File(this.getLibPath(), fileName);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinPathsFromHomeDir", "getLibraryFile"));
        }
        return file2;
    }
}

