/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutionException;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerConfiguration;
import org.gradle.workers.internal.ParamSpec;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.WorkerDaemon;
import org.gradle.workers.internal.WorkerDaemonAction;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerDaemonProtocol;
import org.gradle.workers.internal.WorkerDaemonRunnableAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerExecutor
implements WorkerExecutor {
    private final ListeningExecutorService executor;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final Class<? extends WorkerDaemonProtocol> serverImplementationClass;
    private final FileResolver fileResolver;
    private final BuildOperationWorkerRegistry buildOperationWorkerRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;

    public DefaultWorkerExecutor(WorkerDaemonFactory workerDaemonFactory, FileResolver fileResolver, Class<? extends WorkerDaemonProtocol> serverImplementationClass, ExecutorFactory executorFactory, BuildOperationWorkerRegistry buildOperationWorkerRegistry, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker) {
        this.workerDaemonFactory = workerDaemonFactory;
        this.fileResolver = fileResolver;
        this.serverImplementationClass = serverImplementationClass;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executorFactory.create("Worker Daemon Execution"));
        this.buildOperationWorkerRegistry = buildOperationWorkerRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
    }

    @Override
    public void submit(Class<? extends Runnable> actionClass, Action<WorkerConfiguration> configAction) {
        DefaultWorkerConfiguration configuration = new DefaultWorkerConfiguration(this.fileResolver);
        configAction.execute((Object)configuration);
        ParamSpec spec = new ParamSpec(configuration.getParams());
        String description = configuration.getDisplayName() != null ? configuration.getDisplayName() : actionClass.getName();
        WorkerDaemonRunnableAction action = new WorkerDaemonRunnableAction(description, actionClass);
        this.submit(action, spec, configuration.getForkOptions().getWorkingDir(), this.getDaemonForkOptions(actionClass, configuration));
    }

    private void submit(final WorkerDaemonAction action, final WorkSpec spec, final File workingDir, final DaemonForkOptions daemonForkOptions) {
        final BuildOperationWorkerRegistry.Operation currentWorkerOperation = this.buildOperationWorkerRegistry.getCurrent();
        final BuildOperationExecutor.Operation currentBuildOperation = this.buildOperationExecutor.getCurrentOperation();
        ListenableFuture workerDaemonResult = this.executor.submit((Callable)new Callable<DefaultWorkResult>(){

            @Override
            public DefaultWorkResult call() throws Exception {
                try {
                    WorkerDaemon daemon = DefaultWorkerExecutor.this.workerDaemonFactory.getDaemon(DefaultWorkerExecutor.this.serverImplementationClass, workingDir, daemonForkOptions);
                    return daemon.execute(action, spec, currentWorkerOperation, currentBuildOperation);
                }
                catch (Throwable t) {
                    throw new WorkExecutionException(action.getDescription(), t);
                }
            }
        });
        this.registerAsyncWork(action.getDescription(), (Future<DefaultWorkResult>)workerDaemonResult);
    }

    void registerAsyncWork(final String description, final Future<DefaultWorkResult> workItem) {
        this.asyncWorkTracker.registerWork(this.buildOperationExecutor.getCurrentOperation(), new AsyncWorkCompletion(){

            public void waitForCompletion() {
                try {
                    DefaultWorkResult result = (DefaultWorkResult)workItem.get();
                    if (!result.isSuccess()) {
                        throw new WorkExecutionException(description, result.getException());
                    }
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                catch (ExecutionException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        });
    }

    @Override
    public void await() throws WorkerExecutionException {
        BuildOperationExecutor.Operation currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            this.asyncWorkTracker.waitForCompletion(currentOperation);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private WorkerExecutionException workerExecutionException(List<? extends Throwable> failures) {
        if (failures.size() == 1) {
            throw new WorkerExecutionException("There was a failure while executing work items", failures);
        }
        throw new WorkerExecutionException("There were multiple failures while executing work items", failures);
    }

    DaemonForkOptions getDaemonForkOptions(Class<?> actionClass, WorkerConfiguration configuration) {
        List paramTypes = CollectionUtils.collect((Object[])configuration.getParams(), (Transformer)new Transformer<Class<?>, Object>(){

            public Class<?> transform(Object o) {
                return o.getClass();
            }
        });
        return this.toDaemonOptions(actionClass, paramTypes, configuration.getForkOptions(), configuration.getClasspath());
    }

    private DaemonForkOptions toDaemonOptions(Class<?> actionClass, Iterable<Class<?>> paramClasses, JavaForkOptions forkOptions, Iterable<File> classpath) {
        ImmutableSet.Builder classpathBuilder = ImmutableSet.builder();
        ImmutableSet.Builder sharedPackagesBuilder = ImmutableSet.builder();
        if (classpath != null) {
            classpathBuilder.addAll(classpath);
        }
        DefaultWorkerExecutor.addVisibilityFor(actionClass, (ImmutableSet.Builder<File>)classpathBuilder, (ImmutableSet.Builder<String>)sharedPackagesBuilder);
        for (Class<?> paramClass : paramClasses) {
            DefaultWorkerExecutor.addVisibilityFor(paramClass, (ImmutableSet.Builder<File>)classpathBuilder, (ImmutableSet.Builder<String>)sharedPackagesBuilder);
        }
        ImmutableSet daemonClasspath = classpathBuilder.build();
        ImmutableSet daemonSharedPackages = sharedPackagesBuilder.build();
        return new DaemonForkOptions(forkOptions.getMinHeapSize(), forkOptions.getMaxHeapSize(), forkOptions.getAllJvmArgs(), (Iterable<File>)daemonClasspath, (Iterable<String>)daemonSharedPackages);
    }

    private static void addVisibilityFor(Class<?> visibleClass, ImmutableSet.Builder<File> classpathBuilder, ImmutableSet.Builder<String> sharedPackagesBuilder) {
        if (visibleClass.getClassLoader() != null) {
            classpathBuilder.addAll((Iterable)ClasspathUtil.getClasspath((ClassLoader)visibleClass.getClassLoader()).getAsFiles());
        }
        if (visibleClass.getPackage() == null || "".equals(visibleClass.getPackage().getName())) {
            sharedPackagesBuilder.add((Object)"DEFAULT");
        } else {
            sharedPackagesBuilder.add((Object)visibleClass.getPackage().getName());
        }
    }

    @Contextual
    private static class WorkExecutionException
    extends RuntimeException {
        public WorkExecutionException(String description) {
            this(description, null);
        }

        public WorkExecutionException(String description, Throwable cause) {
            super("A failure occurred while executing " + description, cause);
        }
    }
}

