/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.process.internal.health.memory.MemoryHolder;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.health.memory.TotalPhysicalMemoryProvider;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.WorkerDaemon;
import org.gradle.workers.internal.WorkerDaemonAction;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.gradle.workers.internal.WorkerDaemonExpiration;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerDaemonProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WorkerDaemonManager
implements WorkerDaemonFactory,
Stoppable {
    private final WorkerDaemonClientsManager clientsManager;
    private final MemoryManager memoryManager;
    private final WorkerDaemonExpiration workerDaemonExpiration;
    private final BuildOperationWorkerRegistry buildOperationWorkerRegistry;
    private final BuildOperationExecutor buildOperationExecutor;

    public WorkerDaemonManager(WorkerDaemonClientsManager clientsManager, MemoryManager memoryManager, BuildOperationWorkerRegistry buildOperationWorkerRegistry, BuildOperationExecutor buildOperationExecutor) {
        this.clientsManager = clientsManager;
        this.memoryManager = memoryManager;
        this.workerDaemonExpiration = new WorkerDaemonExpiration(clientsManager, WorkerDaemonManager.getTotalPhysicalMemory());
        memoryManager.addMemoryHolder((MemoryHolder)this.workerDaemonExpiration);
        this.buildOperationWorkerRegistry = buildOperationWorkerRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public WorkerDaemon getDaemon(final Class<? extends WorkerDaemonProtocol> serverImplementationClass, final File workingDir, final DaemonForkOptions forkOptions) {
        return new WorkerDaemon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T extends WorkSpec> DefaultWorkResult execute(WorkerDaemonAction<T> action, T spec, BuildOperationWorkerRegistry.Operation parentWorkerOperation, BuildOperationExecutor.Operation parentBuildOperation) {
                WorkerDaemonClient client = WorkerDaemonManager.this.clientsManager.reserveIdleClient(forkOptions);
                if (client == null) {
                    client = WorkerDaemonManager.this.clientsManager.reserveNewClient(serverImplementationClass, workingDir, forkOptions);
                }
                try {
                    DefaultWorkResult defaultWorkResult = client.execute(action, spec, parentWorkerOperation, parentBuildOperation);
                    return defaultWorkResult;
                }
                finally {
                    WorkerDaemonManager.this.clientsManager.release(client);
                }
            }

            @Override
            public <T extends WorkSpec> DefaultWorkResult execute(WorkerDaemonAction<T> action, T spec) {
                return this.execute(action, spec, WorkerDaemonManager.this.buildOperationWorkerRegistry.getCurrent(), WorkerDaemonManager.this.buildOperationExecutor.getCurrentOperation());
            }
        };
    }

    public void stop() {
        this.clientsManager.stop();
        this.memoryManager.removeMemoryHolder((MemoryHolder)this.workerDaemonExpiration);
    }

    private static long getTotalPhysicalMemory() {
        try {
            return TotalPhysicalMemoryProvider.getTotalPhysicalMemory();
        }
        catch (UnsupportedOperationException e) {
            return -1L;
        }
    }
}

