/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.NoBuildDependenciesArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.specs.Spec;

public class DefaultVisitedArtifactResults
implements VisitedArtifactsResults {
    private final Map<Long, ArtifactSet> artifactsById;
    private final Set<Long> buildableArtifacts;

    public DefaultVisitedArtifactResults(Map<Long, ArtifactSet> artifactsById, Set<Long> buildableArtifacts) {
        this.artifactsById = artifactsById;
        this.buildableArtifacts = buildableArtifacts;
    }

    @Override
    public SelectedArtifactResults select(Spec<? super ComponentIdentifier> componentFilter, Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> selector) {
        LinkedHashSet allArtifactSets = Sets.newLinkedHashSet();
        ImmutableMap.Builder resolvedArtifactsById = ImmutableMap.builder();
        for (Map.Entry<Long, ArtifactSet> entry : this.artifactsById.entrySet()) {
            ArtifactSet artifactSet = entry.getValue();
            long id = entry.getKey();
            ResolvedArtifactSet resolvedArtifacts = artifactSet.select(componentFilter, selector);
            if (!this.buildableArtifacts.contains(id)) {
                resolvedArtifacts = NoBuildDependenciesArtifactSet.of(resolvedArtifacts);
            }
            allArtifactSets.add(resolvedArtifacts);
            resolvedArtifactsById.put((Object)id, (Object)resolvedArtifacts);
        }
        return new DefaultSelectedArtifactResults(CompositeArtifactSet.of(allArtifactSets), (Map<Long, ResolvedArtifactSet>)resolvedArtifactsById.build());
    }

    private static class DefaultSelectedArtifactResults
    implements SelectedArtifactResults {
        private final ResolvedArtifactSet allArtifacts;
        private final Map<Long, ResolvedArtifactSet> resolvedArtifactsById;

        DefaultSelectedArtifactResults(ResolvedArtifactSet allArtifacts, Map<Long, ResolvedArtifactSet> resolvedArtifactsById) {
            this.allArtifacts = allArtifacts;
            this.resolvedArtifactsById = resolvedArtifactsById;
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this.allArtifacts;
        }

        @Override
        public ResolvedArtifactSet getArtifacts(long id) {
            return this.resolvedArtifactsById.get(id);
        }
    }
}

