/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.AmbiguousTransformException;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.VariantAttributeMatchingCache;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.text.TreeFormatter;

public class DefaultArtifactTransforms
implements ArtifactTransforms {
    private final VariantAttributeMatchingCache matchingCache;

    public DefaultArtifactTransforms(VariantAttributeMatchingCache matchingCache) {
        this.matchingCache = matchingCache;
    }

    @Override
    public Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> variantSelector(AttributeContainerInternal requested) {
        return new AttributeMatchingVariantSelector((AttributeContainerInternal)requested.asImmutable());
    }

    private void formatAttributes(TreeFormatter formatter, AttributeContainerInternal attributes) {
        for (Attribute attribute : Ordering.usingToString().sortedCopy((Iterable)attributes.keySet())) {
            formatter.node(attribute.getName() + " '" + attributes.getAttribute(attribute) + "'");
        }
    }

    private class ArtifactTransformingVisitor
    implements ArtifactVisitor {
        private final ArtifactVisitor visitor;
        private final AttributeContainerInternal target;
        private final Transformer<List<File>, File> transform;

        private ArtifactTransformingVisitor(ArtifactVisitor visitor, AttributeContainerInternal target, Transformer<List<File>, File> transform) {
            this.visitor = visitor;
            this.target = target;
            this.transform = transform;
        }

        @Override
        public void visitArtifact(AttributeContainer variant, ResolvedArtifact artifact) {
            List transformedFiles;
            try {
                transformedFiles = (List)this.transform.transform((Object)artifact.getFile());
            }
            catch (Throwable t) {
                this.visitor.visitFailure(t);
                return;
            }
            TaskDependency buildDependencies = ((Buildable)artifact).getBuildDependencies();
            for (File output : transformedFiles) {
                ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(artifact.getId().getComponentIdentifier(), output.getName());
                String extension = Files.getFileExtension((String)output.getName());
                DefaultIvyArtifactName artifactName = new DefaultIvyArtifactName(output.getName(), extension, extension);
                DefaultResolvedArtifact resolvedArtifact = new DefaultResolvedArtifact(artifact.getModuleVersion().getId(), (IvyArtifactName)artifactName, (ComponentArtifactIdentifier)newId, buildDependencies, output);
                this.visitor.visitArtifact((AttributeContainer)this.target, resolvedArtifact);
            }
        }

        @Override
        public void visitFailure(Throwable failure) {
            this.visitor.visitFailure(failure);
        }

        @Override
        public boolean includeFiles() {
            return this.visitor.includeFiles();
        }

        @Override
        public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
            List result;
            try {
                result = (List)this.transform.transform((Object)file);
            }
            catch (Throwable t) {
                this.visitor.visitFailure(t);
                return;
            }
            if (!result.isEmpty()) {
                for (File outputFile : result) {
                    this.visitor.visitFile(new ComponentFileArtifactIdentifier(artifactIdentifier.getComponentIdentifier(), outputFile.getName()), (AttributeContainer)this.target, outputFile);
                }
            }
        }
    }

    private class TransformingArtifactSet
    implements ResolvedArtifactSet {
        private final ResolvedArtifactSet delegate;
        private final AttributeContainerInternal target;
        private final Transformer<List<File>, File> transform;

        TransformingArtifactSet(ResolvedArtifactSet delegate, AttributeContainerInternal target, Transformer<List<File>, File> transform) {
            this.delegate = delegate;
            this.target = target;
            this.transform = transform;
        }

        @Override
        public Set<ResolvedArtifact> getArtifacts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void collectBuildDependencies(Collection<? super TaskDependency> dest) {
            this.delegate.collectBuildDependencies(dest);
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            this.delegate.visit(new ArtifactTransformingVisitor(visitor, this.target, this.transform));
        }
    }

    private class AttributeMatchingVariantSelector
    implements Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> {
        private final AttributeContainerInternal requested;

        private AttributeMatchingVariantSelector(AttributeContainerInternal requested) {
            this.requested = requested;
        }

        public String toString() {
            return "Variant selector for " + this.requested;
        }

        public ResolvedArtifactSet transform(Collection<? extends ResolvedVariant> variants) {
            List<? extends ResolvedVariant> matches = DefaultArtifactTransforms.this.matchingCache.selectMatches(variants, this.requested);
            if (matches.size() > 0) {
                return matches.get(0).getArtifacts();
            }
            ArrayList<Pair> candidates = new ArrayList<Pair>();
            for (ResolvedVariant resolvedVariant : variants) {
                ImmutableAttributes variantAttributes = resolvedVariant.getAttributes().asImmutable();
                ConsumerVariantMatchResult matchResult = new ConsumerVariantMatchResult();
                DefaultArtifactTransforms.this.matchingCache.collectConsumerVariants((AttributeContainerInternal)variantAttributes, this.requested, matchResult);
                for (ConsumerVariantMatchResult.ConsumerVariant consumerVariant : matchResult.getMatches()) {
                    candidates.add(Pair.of((Object)resolvedVariant, (Object)consumerVariant));
                }
            }
            if (candidates.size() == 1) {
                Pair result = (Pair)candidates.get(0);
                return new TransformingArtifactSet(((ResolvedVariant)result.getLeft()).getArtifacts(), ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).attributes, ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).transformer);
            }
            if (!candidates.isEmpty()) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Found multiple transforms that can produce a variant for consumer attributes");
                formatter.startChildren();
                DefaultArtifactTransforms.this.formatAttributes(formatter, this.requested);
                formatter.endChildren();
                formatter.node("Found the following transforms");
                formatter.startChildren();
                for (Pair candidate : candidates) {
                    formatter.node("Transform from variant");
                    formatter.startChildren();
                    DefaultArtifactTransforms.this.formatAttributes(formatter, ((ResolvedVariant)candidate.getLeft()).getAttributes());
                    formatter.endChildren();
                }
                formatter.endChildren();
                throw new AmbiguousTransformException(formatter.toString());
            }
            return ResolvedArtifactSet.EMPTY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributeMatchingVariantSelector)) {
                return false;
            }
            AttributeMatchingVariantSelector that = (AttributeMatchingVariantSelector)o;
            return Objects.equal((Object)this.requested, (Object)that.requested);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.requested});
        }
    }
}

