/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.CompatibilityRuleChainInternal;
import org.gradle.api.internal.attributes.DisambiguationRuleChainInternal;
import org.gradle.internal.Cast;

public class ComponentAttributeMatcher {
    private final boolean ignoreAdditionalProducerAttributes;
    private final boolean ignoreAdditionalConsumerAttributes;

    public ComponentAttributeMatcher() {
        this(false, false);
    }

    private ComponentAttributeMatcher(boolean ignoreAdditionalProducerAttributes, boolean ignoreAdditionalConsumerAttributes) {
        this.ignoreAdditionalProducerAttributes = ignoreAdditionalProducerAttributes;
        this.ignoreAdditionalConsumerAttributes = ignoreAdditionalConsumerAttributes;
    }

    public ComponentAttributeMatcher ignoreAdditionalProducerAttributes() {
        return new ComponentAttributeMatcher(true, this.ignoreAdditionalConsumerAttributes);
    }

    public ComponentAttributeMatcher ignoreAdditionalConsumerAttributes() {
        return new ComponentAttributeMatcher(this.ignoreAdditionalProducerAttributes, true);
    }

    public boolean isMatching(AttributesSchemaInternal schema, AttributeContainer candidate, AttributeContainer requested) {
        MatchDetails details = new MatchDetails();
        this.doMatchCandidate(schema, schema, (HasAttributes)candidate, requested, details);
        return details.compatible;
    }

    public <T extends HasAttributes> List<T> match(AttributesSchemaInternal consumerAttributeSchema, AttributesSchemaInternal producerAttributeSchema, List<T> candidates, AttributeContainer requested) {
        return new Matcher<T>(consumerAttributeSchema, producerAttributeSchema, candidates, requested).getMatches();
    }

    private void doMatchCandidate(AttributesSchemaInternal consumerAttributeSchema, AttributesSchemaInternal producerAttributeSchema, HasAttributes candidate, AttributeContainer requested, MatchDetails details) {
        Set requestedAttributes = (Set)Cast.uncheckedCast((Object)requested.keySet());
        AttributeContainer candidateAttributesContainer = candidate.getAttributes();
        Set candidateAttributes = (Set)Cast.uncheckedCast((Object)candidateAttributesContainer.keySet());
        Sets.SetView allAttributes = Sets.union((Set)requestedAttributes, (Set)candidateAttributes);
        for (Attribute attribute : allAttributes) {
            AttributeValue<Object> requestedValue = this.attributeValue((Attribute<Object>)attribute, consumerAttributeSchema, requested);
            AttributeValue<Object> actualValue = this.attributeValue((Attribute<Object>)attribute, producerAttributeSchema, candidateAttributesContainer);
            if (!requestedValue.isPresent() && this.ignoreAdditionalProducerAttributes) {
                details.matchesByAttribute.put(attribute, actualValue.get());
                continue;
            }
            if (!actualValue.isPresent() && this.ignoreAdditionalConsumerAttributes) continue;
            details.update((Attribute<Object>)attribute, consumerAttributeSchema, producerAttributeSchema, (AttributeValue<Object>)requestedValue, (AttributeValue<Object>)actualValue);
        }
    }

    private AttributeValue<Object> attributeValue(Attribute<Object> attribute, AttributesSchema schema, AttributeContainer container) {
        if (container.contains(attribute)) {
            return AttributeValue.of((Object)container.getAttribute(attribute));
        }
        if (schema.hasAttribute(attribute)) {
            return AttributeValue.missing();
        }
        return AttributeValue.unknown();
    }

    private static class CandidateDetails<T>
    implements MultipleCandidatesDetails<Object> {
        private final ListMultimap<Object, T> candidatesByValue;
        private final List<T> best;

        public CandidateDetails(ListMultimap<Object, T> candidatesByValue, List<T> best) {
            this.candidatesByValue = candidatesByValue;
            this.best = best;
        }

        public Set<Object> getCandidateValues() {
            return this.candidatesByValue.keySet();
        }

        public void closestMatch(Object candidate) {
            List hasAttributes = this.candidatesByValue.get(candidate);
            for (Object attributes : hasAttributes) {
                this.best.add(attributes);
            }
        }
    }

    private static class MatchDetails {
        private final Map<Attribute<Object>, Object> matchesByAttribute = Maps.newHashMap();
        private boolean compatible = true;

        private MatchDetails() {
        }

        private void update(final Attribute<Object> attribute, AttributesSchema consumerSchema, AttributesSchema producerSchema, final AttributeValue<Object> consumerValue, final AttributeValue<Object> producerValue) {
            AttributesSchema schemaToUse = consumerSchema;
            boolean missingOrUnknown = false;
            if (consumerValue.isUnknown() || consumerValue.isMissing()) {
                schemaToUse = producerSchema;
                missingOrUnknown = true;
            } else if (producerValue.isUnknown() || producerValue.isMissing()) {
                missingOrUnknown = true;
            }
            AttributeMatchingStrategy strategy = schemaToUse.getMatchingStrategy(attribute);
            CompatibilityRuleChainInternal compatibilityRules = (CompatibilityRuleChainInternal)strategy.getCompatibilityRules();
            if (missingOrUnknown) {
                if (compatibilityRules.isCompatibleWhenMissing()) {
                    if (producerValue.isPresent()) {
                        this.matchesByAttribute.put(attribute, producerValue.get());
                    }
                } else {
                    this.compatible = false;
                }
                return;
            }
            CompatibilityCheckDetails<Object> details = new CompatibilityCheckDetails<Object>(){

                public Object getConsumerValue() {
                    return consumerValue.get();
                }

                public Object getProducerValue() {
                    return producerValue.get();
                }

                public void compatible() {
                    MatchDetails.this.matchesByAttribute.put(attribute, producerValue.get());
                }

                public void incompatible() {
                    MatchDetails.this.compatible = false;
                }
            };
            try {
                compatibilityRules.execute((Object)details);
            }
            catch (Exception ex) {
                throw new GradleException("Unexpected error thrown when trying to match attribute values with " + strategy, (Throwable)ex);
            }
        }
    }

    private class Matcher<T extends HasAttributes> {
        private final AttributesSchemaInternal consumerAttributeSchema;
        private final AttributesSchemaInternal producerAttributeSchema;
        private final Map<T, MatchDetails> matchDetails = Maps.newHashMap();
        private final AttributeContainer requested;

        public Matcher(AttributesSchemaInternal consumerAttributeSchema, AttributesSchemaInternal producerAttributeSchema, Iterable<T> candidates, AttributeContainer requested) {
            this.consumerAttributeSchema = consumerAttributeSchema;
            this.producerAttributeSchema = producerAttributeSchema;
            for (HasAttributes cand : candidates) {
                if (cand.getAttributes().isEmpty()) continue;
                this.matchDetails.put(cand, new MatchDetails());
            }
            this.requested = requested;
            this.doMatch();
        }

        private void doMatch() {
            for (Map.Entry<T, MatchDetails> entry : this.matchDetails.entrySet()) {
                ComponentAttributeMatcher.this.doMatchCandidate(this.consumerAttributeSchema, this.producerAttributeSchema, (HasAttributes)entry.getKey(), this.requested, entry.getValue());
            }
        }

        public List<T> getMatches() {
            ArrayList<T> matches = new ArrayList<T>(1);
            for (Map.Entry<T, MatchDetails> entry : this.matchDetails.entrySet()) {
                MatchDetails details = entry.getValue();
                if (!details.compatible) continue;
                matches.add(entry.getKey());
            }
            return this.disambiguateUsingClosestMatch(matches);
        }

        private List<T> disambiguateUsingClosestMatch(List<T> matches) {
            if (matches.size() > 1) {
                return this.selectClosestMatches(matches);
            }
            return matches;
        }

        private List<T> selectClosestMatches(List<T> matches) {
            ArrayList remainingMatches = Lists.newArrayList(matches);
            ArrayList best = Lists.newArrayListWithCapacity((int)matches.size());
            ArrayListMultimap candidatesByValue = ArrayListMultimap.create();
            HashSet allAttributes = Sets.newHashSet();
            for (MatchDetails details : this.matchDetails.values()) {
                allAttributes.addAll(details.matchesByAttribute.keySet());
            }
            for (Attribute attribute : allAttributes) {
                for (HasAttributes match : matches) {
                    Map matchedAttributes = this.matchDetails.get(match).matchesByAttribute;
                    Object val = matchedAttributes.get(attribute);
                    candidatesByValue.put(val, (Object)match);
                }
                AttributesSchemaInternal schemaToUse = this.consumerAttributeSchema.hasAttribute(attribute) ? this.consumerAttributeSchema : this.producerAttributeSchema;
                this.disambiguate(remainingMatches, (ListMultimap<Object, T>)candidatesByValue, (AttributeMatchingStrategy<?>)schemaToUse.getMatchingStrategy(attribute), best);
                if (remainingMatches.isEmpty()) {
                    return matches;
                }
                candidatesByValue.clear();
                best.clear();
            }
            if (!remainingMatches.isEmpty()) {
                return remainingMatches;
            }
            return null;
        }

        private void disambiguate(List<T> remainingMatches, ListMultimap<Object, T> candidatesByValue, AttributeMatchingStrategy<?> matchingStrategy, List<T> best) {
            if (candidatesByValue.isEmpty()) {
                return;
            }
            AttributeMatchingStrategy ms = (AttributeMatchingStrategy)Cast.uncheckedCast(matchingStrategy);
            CandidateDetails<T> details = new CandidateDetails<T>(candidatesByValue, best);
            DisambiguationRuleChainInternal disambiguationRules = (DisambiguationRuleChainInternal)ms.getDisambiguationRules();
            disambiguationRules.execute(details);
            remainingMatches.retainAll(best);
        }
    }
}

