/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotMapSerializer;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileCollectionSnapshot
implements FileCollectionSnapshot {
    private final Map<String, NormalizedFileSnapshot> snapshots;
    private final TaskFilePropertyCompareStrategy compareStrategy;
    private final boolean pathIsAbsolute;
    private final Factory<List<File>> cachedElementsFactory = Factories.softReferenceCache((Factory)new Factory<List<File>>(){

        public List<File> create() {
            return DefaultFileCollectionSnapshot.this.doGetElements();
        }
    });
    private final Factory<List<File>> cachedFilesFactory = Factories.softReferenceCache((Factory)new Factory<List<File>>(){

        public List<File> create() {
            return DefaultFileCollectionSnapshot.this.doGetFiles();
        }
    });

    public DefaultFileCollectionSnapshot(Map<String, NormalizedFileSnapshot> snapshots, TaskFilePropertyCompareStrategy compareStrategy, boolean pathIsAbsolute) {
        this.snapshots = snapshots;
        this.compareStrategy = compareStrategy;
        this.pathIsAbsolute = pathIsAbsolute;
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public boolean isEmpty() {
        return this.snapshots.isEmpty();
    }

    @Override
    public Iterator<TaskStateChange> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, String fileType) {
        return this.compareStrategy.iterateContentChangesSince(this.snapshots, oldSnapshot.getSnapshots(), fileType, this.pathIsAbsolute);
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        this.compareStrategy.appendToHasher(hasher, this.snapshots);
    }

    public List<File> getElements() {
        return (List)this.cachedElementsFactory.create();
    }

    private List<File> doGetElements() {
        ArrayList files = Lists.newArrayListWithCapacity((int)this.snapshots.size());
        for (String name : this.snapshots.keySet()) {
            files.add(new File(name));
        }
        return files;
    }

    public List<File> getFiles() {
        return (List)this.cachedFilesFactory.create();
    }

    private List<File> doGetFiles() {
        ArrayList files = Lists.newArrayList();
        for (Map.Entry<String, NormalizedFileSnapshot> entry : this.snapshots.entrySet()) {
            if (!(entry.getValue().getSnapshot() instanceof FileHashSnapshot)) continue;
            files.add(new File(entry.getKey()));
        }
        return files;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializerImpl
    extends AbstractSerializer<DefaultFileCollectionSnapshot> {
        private final SnapshotMapSerializer snapshotMapSerializer;

        public SerializerImpl(StringInterner stringInterner) {
            this.snapshotMapSerializer = new SnapshotMapSerializer(stringInterner);
        }

        public DefaultFileCollectionSnapshot read(Decoder decoder) throws Exception {
            TaskFilePropertyCompareStrategy compareStrategy = TaskFilePropertyCompareStrategy.values()[decoder.readSmallInt()];
            Object snapshots = this.snapshotMapSerializer.read(decoder);
            boolean pathIsUnique = decoder.readBoolean();
            return new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)snapshots, compareStrategy, pathIsUnique);
        }

        public void write(Encoder encoder, DefaultFileCollectionSnapshot value) throws Exception {
            encoder.writeSmallInt(value.compareStrategy.ordinal());
            this.snapshotMapSerializer.write(encoder, value.snapshots);
            encoder.writeBoolean(value.pathIsAbsolute);
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            SerializerImpl rhs = (SerializerImpl)((Object)obj);
            return Objects.equal((Object)((Object)this.snapshotMapSerializer), (Object)((Object)rhs.snapshotMapSerializer));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.snapshotMapSerializer});
        }
    }
}

